/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution.scheduler;

import com.google.common.collect.ImmutableMap;
import io.airlift.stats.CounterStat;
import io.prestosql.execution.scheduler.NodeScheduler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;
import org.weakref.jmx.JmxException;
import org.weakref.jmx.MBeanExport;
import org.weakref.jmx.MBeanExporter;

public final class NodeSchedulerExporter {
    @GuardedBy(value="this")
    private final List<MBeanExport> mbeanExports = new ArrayList<MBeanExport>();

    @Inject
    public NodeSchedulerExporter(NodeScheduler nodeScheduler, MBeanExporter exporter) {
        Objects.requireNonNull(nodeScheduler, "nodeScheduler is null");
        Objects.requireNonNull(exporter, "exporter is null");
        Map<String, CounterStat> topologicalSplitCounters = nodeScheduler.getTopologicalSplitCounters();
        for (Map.Entry<String, CounterStat> entry : topologicalSplitCounters.entrySet()) {
            try {
                this.mbeanExports.add(exporter.exportWithGeneratedName((Object)entry.getValue(), NodeScheduler.class, (Map)ImmutableMap.of((Object)"segment", (Object)entry.getKey())));
            }
            catch (JmxException jmxException) {}
        }
    }

    @PreDestroy
    public synchronized void destroy() {
        for (MBeanExport mbeanExport : this.mbeanExports) {
            try {
                mbeanExport.unexport();
            }
            catch (JmxException jmxException) {}
        }
        this.mbeanExports.clear();
    }
}

