/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution.scheduler;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.log.Logger;
import io.prestosql.execution.NodeTaskMap;
import io.prestosql.execution.RemoteTask;
import io.prestosql.execution.scheduler.BucketNodeMap;
import io.prestosql.execution.scheduler.NodeAssignmentStats;
import io.prestosql.execution.scheduler.NodeMap;
import io.prestosql.execution.scheduler.NodeScheduler;
import io.prestosql.execution.scheduler.NodeSelector;
import io.prestosql.execution.scheduler.ResettableRandomizedIterator;
import io.prestosql.execution.scheduler.SplitPlacementResult;
import io.prestosql.metadata.InternalNode;
import io.prestosql.metadata.InternalNodeManager;
import io.prestosql.metadata.Split;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class SimpleNodeSelector
implements NodeSelector {
    private static final Logger log = Logger.get(SimpleNodeSelector.class);
    private final InternalNodeManager nodeManager;
    private final NodeTaskMap nodeTaskMap;
    private final boolean includeCoordinator;
    private final AtomicReference<Supplier<NodeMap>> nodeMap;
    private final int minCandidates;
    private final int maxSplitsPerNode;
    private final int maxPendingSplitsPerTask;

    public SimpleNodeSelector(InternalNodeManager nodeManager, NodeTaskMap nodeTaskMap, boolean includeCoordinator, Supplier<NodeMap> nodeMap, int minCandidates, int maxSplitsPerNode, int maxPendingSplitsPerTask) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.nodeTaskMap = Objects.requireNonNull(nodeTaskMap, "nodeTaskMap is null");
        this.includeCoordinator = includeCoordinator;
        this.nodeMap = new AtomicReference<Supplier<NodeMap>>(nodeMap);
        this.minCandidates = minCandidates;
        this.maxSplitsPerNode = maxSplitsPerNode;
        this.maxPendingSplitsPerTask = maxPendingSplitsPerTask;
    }

    @Override
    public void lockDownNodes() {
        this.nodeMap.set((Supplier<NodeMap>)Suppliers.ofInstance((Object)this.nodeMap.get().get()));
    }

    @Override
    public List<InternalNode> allNodes() {
        return ImmutableList.copyOf((Collection)((NodeMap)this.nodeMap.get().get()).getNodesByHostAndPort().values());
    }

    @Override
    public InternalNode selectCurrentNode() {
        return this.nodeManager.getCurrentNode();
    }

    @Override
    public List<InternalNode> selectRandomNodes(int limit, Set<InternalNode> excludedNodes) {
        return NodeScheduler.selectNodes(limit, NodeScheduler.randomizedNodes((NodeMap)this.nodeMap.get().get(), this.includeCoordinator, excludedNodes));
    }

    @Override
    public SplitPlacementResult computeAssignments(Set<Split> splits, List<RemoteTask> existingTasks) {
        HashMultimap assignment = HashMultimap.create();
        NodeMap nodeMap = (NodeMap)this.nodeMap.get().get();
        NodeAssignmentStats assignmentStats = new NodeAssignmentStats(this.nodeTaskMap, nodeMap, existingTasks);
        ResettableRandomizedIterator<InternalNode> randomCandidates = NodeScheduler.randomizedNodes(nodeMap, this.includeCoordinator, (Set<InternalNode>)ImmutableSet.of());
        HashSet<InternalNode> blockedExactNodes = new HashSet<InternalNode>();
        boolean splitWaitingForAnyNode = false;
        for (Split split : splits) {
            int totalSplitCount;
            randomCandidates.reset();
            List<InternalNode> candidateNodes = !split.isRemotelyAccessible() ? NodeScheduler.selectExactNodes(nodeMap, split.getAddresses(), this.includeCoordinator) : NodeScheduler.selectNodes(this.minCandidates, randomCandidates);
            if (candidateNodes.isEmpty()) {
                log.debug("No nodes available to schedule %s. Available nodes %s", new Object[]{split, nodeMap.getNodesByHost().keys()});
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE, "No nodes available to run query");
            }
            InternalNode chosenNode = null;
            int min = Integer.MAX_VALUE;
            for (InternalNode node : candidateNodes) {
                totalSplitCount = assignmentStats.getTotalSplitCount(node);
                if (totalSplitCount >= min || totalSplitCount >= this.maxSplitsPerNode) continue;
                chosenNode = node;
                min = totalSplitCount;
            }
            if (chosenNode == null) {
                for (InternalNode node : candidateNodes) {
                    totalSplitCount = assignmentStats.getQueuedSplitCountForStage(node);
                    if (totalSplitCount >= min || totalSplitCount >= this.maxPendingSplitsPerTask) continue;
                    chosenNode = node;
                    min = totalSplitCount;
                }
            }
            if (chosenNode != null) {
                assignment.put(chosenNode, (Object)split);
                assignmentStats.addAssignedSplit(chosenNode);
                continue;
            }
            if (split.isRemotelyAccessible()) {
                splitWaitingForAnyNode = true;
                continue;
            }
            if (splitWaitingForAnyNode) continue;
            blockedExactNodes.addAll(candidateNodes);
        }
        ListenableFuture<?> blocked = splitWaitingForAnyNode ? NodeScheduler.toWhenHasSplitQueueSpaceFuture(existingTasks, NodeScheduler.calculateLowWatermark(this.maxPendingSplitsPerTask)) : NodeScheduler.toWhenHasSplitQueueSpaceFuture(blockedExactNodes, existingTasks, NodeScheduler.calculateLowWatermark(this.maxPendingSplitsPerTask));
        return new SplitPlacementResult(blocked, (Multimap<InternalNode, Split>)assignment);
    }

    @Override
    public SplitPlacementResult computeAssignments(Set<Split> splits, List<RemoteTask> existingTasks, BucketNodeMap bucketNodeMap) {
        return NodeScheduler.selectDistributionNodes((NodeMap)this.nodeMap.get().get(), this.nodeTaskMap, this.maxSplitsPerNode, this.maxPendingSplitsPerTask, splits, existingTasks, bucketNodeMap);
    }
}

