/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution.scheduler;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.log.Logger;
import io.airlift.stats.CounterStat;
import io.prestosql.execution.NodeTaskMap;
import io.prestosql.execution.RemoteTask;
import io.prestosql.execution.scheduler.BucketNodeMap;
import io.prestosql.execution.scheduler.NetworkLocation;
import io.prestosql.execution.scheduler.NetworkLocationCache;
import io.prestosql.execution.scheduler.NodeAssignmentStats;
import io.prestosql.execution.scheduler.NodeMap;
import io.prestosql.execution.scheduler.NodeScheduler;
import io.prestosql.execution.scheduler.NodeSelector;
import io.prestosql.execution.scheduler.ResettableRandomizedIterator;
import io.prestosql.execution.scheduler.SplitPlacementResult;
import io.prestosql.metadata.InternalNode;
import io.prestosql.metadata.InternalNodeManager;
import io.prestosql.metadata.Split;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.HostAddress;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public class TopologyAwareNodeSelector
implements NodeSelector {
    private static final Logger log = Logger.get(TopologyAwareNodeSelector.class);
    private final InternalNodeManager nodeManager;
    private final NodeTaskMap nodeTaskMap;
    private final boolean includeCoordinator;
    private final AtomicReference<Supplier<NodeMap>> nodeMap;
    private final int minCandidates;
    private final int maxSplitsPerNode;
    private final int maxPendingSplitsPerTask;
    private final List<CounterStat> topologicalSplitCounters;
    private final List<String> networkLocationSegmentNames;
    private final NetworkLocationCache networkLocationCache;

    public TopologyAwareNodeSelector(InternalNodeManager nodeManager, NodeTaskMap nodeTaskMap, boolean includeCoordinator, Supplier<NodeMap> nodeMap, int minCandidates, int maxSplitsPerNode, int maxPendingSplitsPerTask, List<CounterStat> topologicalSplitCounters, List<String> networkLocationSegmentNames, NetworkLocationCache networkLocationCache) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.nodeTaskMap = Objects.requireNonNull(nodeTaskMap, "nodeTaskMap is null");
        this.includeCoordinator = includeCoordinator;
        this.nodeMap = new AtomicReference<Supplier<NodeMap>>(nodeMap);
        this.minCandidates = minCandidates;
        this.maxSplitsPerNode = maxSplitsPerNode;
        this.maxPendingSplitsPerTask = maxPendingSplitsPerTask;
        this.topologicalSplitCounters = Objects.requireNonNull(topologicalSplitCounters, "topologicalSplitCounters is null");
        this.networkLocationSegmentNames = Objects.requireNonNull(networkLocationSegmentNames, "networkLocationSegmentNames is null");
        this.networkLocationCache = Objects.requireNonNull(networkLocationCache, "networkLocationCache is null");
    }

    @Override
    public void lockDownNodes() {
        this.nodeMap.set((Supplier<NodeMap>)Suppliers.ofInstance((Object)this.nodeMap.get().get()));
    }

    @Override
    public List<InternalNode> allNodes() {
        return ImmutableList.copyOf((Collection)((NodeMap)this.nodeMap.get().get()).getNodesByHostAndPort().values());
    }

    @Override
    public InternalNode selectCurrentNode() {
        return this.nodeManager.getCurrentNode();
    }

    @Override
    public List<InternalNode> selectRandomNodes(int limit, Set<InternalNode> excludedNodes) {
        return NodeScheduler.selectNodes(limit, NodeScheduler.randomizedNodes((NodeMap)this.nodeMap.get().get(), this.includeCoordinator, excludedNodes));
    }

    @Override
    public SplitPlacementResult computeAssignments(Set<Split> splits, List<RemoteTask> existingTasks) {
        NodeMap nodeMap = (NodeMap)this.nodeMap.get().get();
        HashMultimap assignment = HashMultimap.create();
        NodeAssignmentStats assignmentStats = new NodeAssignmentStats(this.nodeTaskMap, nodeMap, existingTasks);
        int[] topologicCounters = new int[this.topologicalSplitCounters.size()];
        HashSet<NetworkLocation> filledLocations = new HashSet<NetworkLocation>();
        HashSet<InternalNode> blockedExactNodes = new HashSet<InternalNode>();
        boolean splitWaitingForAnyNode = false;
        for (Split split : splits) {
            if (!split.isRemotelyAccessible()) {
                List<InternalNode> candidateNodes = NodeScheduler.selectExactNodes(nodeMap, split.getAddresses(), this.includeCoordinator);
                if (candidateNodes.isEmpty()) {
                    log.debug("No nodes available to schedule %s. Available nodes %s", new Object[]{split, nodeMap.getNodesByHost().keys()});
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE, "No nodes available to run query");
                }
                InternalNode chosenNode = this.bestNodeSplitCount(candidateNodes.iterator(), this.minCandidates, this.maxPendingSplitsPerTask, assignmentStats);
                if (chosenNode != null) {
                    assignment.put((Object)chosenNode, (Object)split);
                    assignmentStats.addAssignedSplit(chosenNode);
                    continue;
                }
                if (splitWaitingForAnyNode) continue;
                blockedExactNodes.addAll(candidateNodes);
                continue;
            }
            InternalNode chosenNode = null;
            int depth = this.networkLocationSegmentNames.size();
            int chosenDepth = 0;
            HashSet<NetworkLocation> locations = new HashSet<NetworkLocation>();
            for (HostAddress host : split.getAddresses()) {
                locations.add(this.networkLocationCache.get(host));
            }
            if (locations.isEmpty()) {
                locations.add(NetworkLocation.ROOT_LOCATION);
                depth = 0;
            }
            block2: for (int i = depth; i >= 0 && chosenNode == null; --i) {
                for (NetworkLocation location : locations) {
                    if (location.getSegments().size() < i || filledLocations.contains(location = location.subLocation(0, i))) continue;
                    Set nodes = nodeMap.getWorkersByNetworkPath().get((Object)location);
                    chosenNode = this.bestNodeSplitCount(new ResettableRandomizedIterator<InternalNode>(nodes), this.minCandidates, this.calculateMaxPendingSplits(i, depth), assignmentStats);
                    if (chosenNode != null) {
                        chosenDepth = i;
                        continue block2;
                    }
                    filledLocations.add(location);
                }
            }
            if (chosenNode != null) {
                assignment.put(chosenNode, (Object)split);
                assignmentStats.addAssignedSplit(chosenNode);
                int n = chosenDepth;
                topologicCounters[n] = topologicCounters[n] + 1;
                continue;
            }
            splitWaitingForAnyNode = true;
        }
        for (int i = 0; i < topologicCounters.length; ++i) {
            if (topologicCounters[i] <= 0) continue;
            this.topologicalSplitCounters.get(i).update((long)topologicCounters[i]);
        }
        int maxPendingForWildcardNetworkAffinity = this.calculateMaxPendingSplits(0, this.networkLocationSegmentNames.size());
        ListenableFuture<?> blocked = splitWaitingForAnyNode ? NodeScheduler.toWhenHasSplitQueueSpaceFuture(existingTasks, NodeScheduler.calculateLowWatermark(maxPendingForWildcardNetworkAffinity)) : NodeScheduler.toWhenHasSplitQueueSpaceFuture(blockedExactNodes, existingTasks, NodeScheduler.calculateLowWatermark(maxPendingForWildcardNetworkAffinity));
        return new SplitPlacementResult(blocked, (Multimap<InternalNode, Split>)assignment);
    }

    private int calculateMaxPendingSplits(int splitAffinity, int totalDepth) {
        if (totalDepth == 0) {
            return this.maxPendingSplitsPerTask;
        }
        double queueFraction = 0.5 * (1.0 + (double)splitAffinity / (double)totalDepth);
        return (int)Math.ceil((double)this.maxPendingSplitsPerTask * queueFraction);
    }

    @Override
    public SplitPlacementResult computeAssignments(Set<Split> splits, List<RemoteTask> existingTasks, BucketNodeMap bucketNodeMap) {
        return NodeScheduler.selectDistributionNodes((NodeMap)this.nodeMap.get().get(), this.nodeTaskMap, this.maxSplitsPerNode, this.maxPendingSplitsPerTask, splits, existingTasks, bucketNodeMap);
    }

    @Nullable
    private InternalNode bestNodeSplitCount(Iterator<InternalNode> candidates, int minCandidatesWhenFull, int maxPendingSplitsPerTask, NodeAssignmentStats assignmentStats) {
        InternalNode bestQueueNotFull = null;
        int min = Integer.MAX_VALUE;
        for (int fullCandidatesConsidered = 0; candidates.hasNext() && (fullCandidatesConsidered < minCandidatesWhenFull || bestQueueNotFull == null); ++fullCandidatesConsidered) {
            InternalNode node = candidates.next();
            if (assignmentStats.getTotalSplitCount(node) >= this.maxSplitsPerNode) continue;
            return node;
        }
        return bestQueueNotFull;
    }
}

