/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution.scheduler.group;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.SettableFuture;
import io.prestosql.execution.Lifespan;
import io.prestosql.execution.scheduler.BucketNodeMap;
import io.prestosql.execution.scheduler.SourceScheduler;
import io.prestosql.execution.scheduler.group.LifespanScheduler;
import io.prestosql.metadata.InternalNode;
import io.prestosql.spi.connector.ConnectorPartitionHandle;
import io.prestosql.spi.connector.NotPartitionedPartitionHandle;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import javax.annotation.concurrent.GuardedBy;

public class FixedLifespanScheduler
implements LifespanScheduler {
    private final Int2ObjectMap<InternalNode> driverGroupToNodeMap;
    private final Map<InternalNode, IntListIterator> nodeToDriverGroupsMap;
    private final List<ConnectorPartitionHandle> partitionHandles;
    private final OptionalInt concurrentLifespansPerTask;
    private boolean initialScheduled;
    private SettableFuture<?> newDriverGroupReady = SettableFuture.create();
    @GuardedBy(value="this")
    private final List<Lifespan> recentlyCompletedDriverGroups = new ArrayList<Lifespan>();
    private int totalDriverGroupsScheduled;

    public FixedLifespanScheduler(BucketNodeMap bucketNodeMap, List<ConnectorPartitionHandle> partitionHandles, OptionalInt concurrentLifespansPerTask) {
        Preconditions.checkArgument((!partitionHandles.equals(ImmutableList.of((Object)NotPartitionedPartitionHandle.NOT_PARTITIONED)) ? 1 : 0) != 0);
        Preconditions.checkArgument((partitionHandles.size() == bucketNodeMap.getBucketCount() ? 1 : 0) != 0);
        HashMap<InternalNode, IntList> nodeToDriverGroupMap = new HashMap<InternalNode, IntList>();
        Int2ObjectOpenHashMap driverGroupToNodeMap = new Int2ObjectOpenHashMap();
        for (int bucket = 0; bucket < bucketNodeMap.getBucketCount(); ++bucket) {
            InternalNode node = bucketNodeMap.getAssignedNode(bucket).get();
            nodeToDriverGroupMap.computeIfAbsent(node, key -> new IntArrayList()).add(bucket);
            driverGroupToNodeMap.put(bucket, (Object)node);
        }
        this.driverGroupToNodeMap = driverGroupToNodeMap;
        this.nodeToDriverGroupsMap = (Map)nodeToDriverGroupMap.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((IntList)entry.getValue()).iterator()));
        this.partitionHandles = Objects.requireNonNull(partitionHandles, "partitionHandles is null");
        if (concurrentLifespansPerTask.isPresent()) {
            Preconditions.checkArgument((concurrentLifespansPerTask.getAsInt() >= 1 ? 1 : 0) != 0, (Object)"concurrentLifespansPerTask must be great or equal to 1 if present");
        }
        this.concurrentLifespansPerTask = Objects.requireNonNull(concurrentLifespansPerTask, "concurrentLifespansPerTask is null");
    }

    @Override
    public void scheduleInitial(SourceScheduler scheduler) {
        Preconditions.checkState((!this.initialScheduled ? 1 : 0) != 0);
        this.initialScheduled = true;
        block0: for (Map.Entry<InternalNode, IntListIterator> entry : this.nodeToDriverGroupsMap.entrySet()) {
            IntListIterator driverGroupsIterator = entry.getValue();
            int driverGroupsScheduled = 0;
            while (driverGroupsIterator.hasNext()) {
                int driverGroupId = driverGroupsIterator.nextInt();
                scheduler.startLifespan(Lifespan.driverGroup(driverGroupId), this.partitionHandles.get(driverGroupId));
                ++this.totalDriverGroupsScheduled;
                if (!this.concurrentLifespansPerTask.isPresent() || ++driverGroupsScheduled != this.concurrentLifespansPerTask.getAsInt()) continue;
                continue block0;
            }
        }
        Verify.verify((this.totalDriverGroupsScheduled <= this.driverGroupToNodeMap.size() ? 1 : 0) != 0);
        if (this.totalDriverGroupsScheduled == this.driverGroupToNodeMap.size()) {
            scheduler.noMoreLifespans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLifespanFinished(Iterable<Lifespan> newlyCompletedDriverGroups) {
        SettableFuture<?> newDriverGroupReady;
        Preconditions.checkState((boolean)this.initialScheduled);
        FixedLifespanScheduler fixedLifespanScheduler = this;
        synchronized (fixedLifespanScheduler) {
            for (Lifespan newlyCompletedDriverGroup : newlyCompletedDriverGroups) {
                Preconditions.checkArgument((!newlyCompletedDriverGroup.isTaskWide() ? 1 : 0) != 0);
                this.recentlyCompletedDriverGroups.add(newlyCompletedDriverGroup);
            }
            newDriverGroupReady = this.newDriverGroupReady;
        }
        newDriverGroupReady.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SettableFuture schedule(SourceScheduler scheduler) {
        ImmutableList recentlyCompletedDriverGroups;
        Preconditions.checkState((boolean)this.initialScheduled);
        FixedLifespanScheduler fixedLifespanScheduler = this;
        synchronized (fixedLifespanScheduler) {
            recentlyCompletedDriverGroups = ImmutableList.copyOf(this.recentlyCompletedDriverGroups);
            this.recentlyCompletedDriverGroups.clear();
            this.newDriverGroupReady = SettableFuture.create();
        }
        for (Lifespan driverGroup : recentlyCompletedDriverGroups) {
            IntListIterator driverGroupsIterator = this.nodeToDriverGroupsMap.get(this.driverGroupToNodeMap.get(driverGroup.getId()));
            if (!driverGroupsIterator.hasNext()) continue;
            int driverGroupId = driverGroupsIterator.nextInt();
            scheduler.startLifespan(Lifespan.driverGroup(driverGroupId), this.partitionHandles.get(driverGroupId));
            ++this.totalDriverGroupsScheduled;
        }
        Verify.verify((this.totalDriverGroupsScheduled <= this.driverGroupToNodeMap.size() ? 1 : 0) != 0);
        if (this.totalDriverGroupsScheduled == this.driverGroupToNodeMap.size()) {
            scheduler.noMoreLifespans();
        }
        return this.newDriverGroupReady;
    }
}

