/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Primitives;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.slice.Slice;
import io.prestosql.block.BlockSerdeUtil;
import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.FunctionInvokerProvider;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionListBuilder;
import io.prestosql.metadata.OperatorNotFoundException;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SignatureBinder;
import io.prestosql.metadata.SpecializedFunctionKey;
import io.prestosql.metadata.SqlAggregationFunction;
import io.prestosql.metadata.SqlFunction;
import io.prestosql.metadata.SqlScalarFunction;
import io.prestosql.operator.aggregation.ApproximateCountDistinctAggregation;
import io.prestosql.operator.aggregation.ApproximateDoublePercentileAggregations;
import io.prestosql.operator.aggregation.ApproximateDoublePercentileArrayAggregations;
import io.prestosql.operator.aggregation.ApproximateLongPercentileAggregations;
import io.prestosql.operator.aggregation.ApproximateLongPercentileArrayAggregations;
import io.prestosql.operator.aggregation.ApproximateRealPercentileAggregations;
import io.prestosql.operator.aggregation.ApproximateRealPercentileArrayAggregations;
import io.prestosql.operator.aggregation.ApproximateSetAggregation;
import io.prestosql.operator.aggregation.ArbitraryAggregationFunction;
import io.prestosql.operator.aggregation.AverageAggregations;
import io.prestosql.operator.aggregation.BitwiseAndAggregation;
import io.prestosql.operator.aggregation.BitwiseOrAggregation;
import io.prestosql.operator.aggregation.BooleanAndAggregation;
import io.prestosql.operator.aggregation.BooleanOrAggregation;
import io.prestosql.operator.aggregation.CentralMomentsAggregation;
import io.prestosql.operator.aggregation.ChecksumAggregationFunction;
import io.prestosql.operator.aggregation.CountAggregation;
import io.prestosql.operator.aggregation.CountColumn;
import io.prestosql.operator.aggregation.CountIfAggregation;
import io.prestosql.operator.aggregation.DecimalAverageAggregation;
import io.prestosql.operator.aggregation.DecimalSumAggregation;
import io.prestosql.operator.aggregation.DefaultApproximateCountDistinctAggregation;
import io.prestosql.operator.aggregation.DoubleCorrelationAggregation;
import io.prestosql.operator.aggregation.DoubleCovarianceAggregation;
import io.prestosql.operator.aggregation.DoubleHistogramAggregation;
import io.prestosql.operator.aggregation.DoubleRegressionAggregation;
import io.prestosql.operator.aggregation.DoubleSumAggregation;
import io.prestosql.operator.aggregation.GeometricMeanAggregations;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.operator.aggregation.IntervalDayToSecondAverageAggregation;
import io.prestosql.operator.aggregation.IntervalDayToSecondSumAggregation;
import io.prestosql.operator.aggregation.IntervalYearToMonthAverageAggregation;
import io.prestosql.operator.aggregation.IntervalYearToMonthSumAggregation;
import io.prestosql.operator.aggregation.LongSumAggregation;
import io.prestosql.operator.aggregation.MapAggregationFunction;
import io.prestosql.operator.aggregation.MapUnionAggregation;
import io.prestosql.operator.aggregation.MaxAggregationFunction;
import io.prestosql.operator.aggregation.MaxDataSizeForStats;
import io.prestosql.operator.aggregation.MaxNAggregationFunction;
import io.prestosql.operator.aggregation.MergeHyperLogLogAggregation;
import io.prestosql.operator.aggregation.MergeQuantileDigestFunction;
import io.prestosql.operator.aggregation.MinAggregationFunction;
import io.prestosql.operator.aggregation.MinNAggregationFunction;
import io.prestosql.operator.aggregation.QuantileDigestAggregationFunction;
import io.prestosql.operator.aggregation.RealAverageAggregation;
import io.prestosql.operator.aggregation.RealCorrelationAggregation;
import io.prestosql.operator.aggregation.RealCovarianceAggregation;
import io.prestosql.operator.aggregation.RealGeometricMeanAggregations;
import io.prestosql.operator.aggregation.RealHistogramAggregation;
import io.prestosql.operator.aggregation.RealRegressionAggregation;
import io.prestosql.operator.aggregation.RealSumAggregation;
import io.prestosql.operator.aggregation.ReduceAggregationFunction;
import io.prestosql.operator.aggregation.SumDataSizeForStats;
import io.prestosql.operator.aggregation.VarianceAggregation;
import io.prestosql.operator.aggregation.arrayagg.ArrayAggregationFunction;
import io.prestosql.operator.aggregation.histogram.Histogram;
import io.prestosql.operator.aggregation.minmaxby.MaxByAggregationFunction;
import io.prestosql.operator.aggregation.minmaxby.MaxByNAggregationFunction;
import io.prestosql.operator.aggregation.minmaxby.MinByAggregationFunction;
import io.prestosql.operator.aggregation.minmaxby.MinByNAggregationFunction;
import io.prestosql.operator.aggregation.multimapagg.MultimapAggregationFunction;
import io.prestosql.operator.scalar.ArrayCardinalityFunction;
import io.prestosql.operator.scalar.ArrayCombinationsFunction;
import io.prestosql.operator.scalar.ArrayConcatFunction;
import io.prestosql.operator.scalar.ArrayConstructor;
import io.prestosql.operator.scalar.ArrayContains;
import io.prestosql.operator.scalar.ArrayDistinctFromOperator;
import io.prestosql.operator.scalar.ArrayDistinctFunction;
import io.prestosql.operator.scalar.ArrayElementAtFunction;
import io.prestosql.operator.scalar.ArrayEqualOperator;
import io.prestosql.operator.scalar.ArrayExceptFunction;
import io.prestosql.operator.scalar.ArrayFilterFunction;
import io.prestosql.operator.scalar.ArrayFlattenFunction;
import io.prestosql.operator.scalar.ArrayFunctions;
import io.prestosql.operator.scalar.ArrayGreaterThanOperator;
import io.prestosql.operator.scalar.ArrayGreaterThanOrEqualOperator;
import io.prestosql.operator.scalar.ArrayHashCodeOperator;
import io.prestosql.operator.scalar.ArrayIndeterminateOperator;
import io.prestosql.operator.scalar.ArrayIntersectFunction;
import io.prestosql.operator.scalar.ArrayJoin;
import io.prestosql.operator.scalar.ArrayLessThanOperator;
import io.prestosql.operator.scalar.ArrayLessThanOrEqualOperator;
import io.prestosql.operator.scalar.ArrayMaxFunction;
import io.prestosql.operator.scalar.ArrayMinFunction;
import io.prestosql.operator.scalar.ArrayNgramsFunction;
import io.prestosql.operator.scalar.ArrayNotEqualOperator;
import io.prestosql.operator.scalar.ArrayPositionFunction;
import io.prestosql.operator.scalar.ArrayReduceFunction;
import io.prestosql.operator.scalar.ArrayRemoveFunction;
import io.prestosql.operator.scalar.ArrayReverseFunction;
import io.prestosql.operator.scalar.ArrayShuffleFunction;
import io.prestosql.operator.scalar.ArraySliceFunction;
import io.prestosql.operator.scalar.ArraySortComparatorFunction;
import io.prestosql.operator.scalar.ArraySortFunction;
import io.prestosql.operator.scalar.ArraySubscriptOperator;
import io.prestosql.operator.scalar.ArrayToArrayCast;
import io.prestosql.operator.scalar.ArrayToElementConcatFunction;
import io.prestosql.operator.scalar.ArrayToJsonCast;
import io.prestosql.operator.scalar.ArrayTransformFunction;
import io.prestosql.operator.scalar.ArrayUnionFunction;
import io.prestosql.operator.scalar.ArraysOverlapFunction;
import io.prestosql.operator.scalar.BitwiseFunctions;
import io.prestosql.operator.scalar.CastFromUnknownOperator;
import io.prestosql.operator.scalar.CharacterStringCasts;
import io.prestosql.operator.scalar.ColorFunctions;
import io.prestosql.operator.scalar.CombineHashFunction;
import io.prestosql.operator.scalar.ConcatFunction;
import io.prestosql.operator.scalar.DataSizeFunctions;
import io.prestosql.operator.scalar.DateTimeFunctions;
import io.prestosql.operator.scalar.ElementToArrayConcatFunction;
import io.prestosql.operator.scalar.EmptyMapConstructor;
import io.prestosql.operator.scalar.FailureFunction;
import io.prestosql.operator.scalar.Greatest;
import io.prestosql.operator.scalar.HmacFunctions;
import io.prestosql.operator.scalar.HyperLogLogFunctions;
import io.prestosql.operator.scalar.IdentityCast;
import io.prestosql.operator.scalar.JoniRegexpCasts;
import io.prestosql.operator.scalar.JoniRegexpFunctions;
import io.prestosql.operator.scalar.JoniRegexpReplaceLambdaFunction;
import io.prestosql.operator.scalar.JsonFunctions;
import io.prestosql.operator.scalar.JsonOperators;
import io.prestosql.operator.scalar.JsonStringToArrayCast;
import io.prestosql.operator.scalar.JsonStringToMapCast;
import io.prestosql.operator.scalar.JsonStringToRowCast;
import io.prestosql.operator.scalar.JsonToArrayCast;
import io.prestosql.operator.scalar.JsonToMapCast;
import io.prestosql.operator.scalar.JsonToRowCast;
import io.prestosql.operator.scalar.Least;
import io.prestosql.operator.scalar.MapCardinalityFunction;
import io.prestosql.operator.scalar.MapConcatFunction;
import io.prestosql.operator.scalar.MapConstructor;
import io.prestosql.operator.scalar.MapDistinctFromOperator;
import io.prestosql.operator.scalar.MapElementAtFunction;
import io.prestosql.operator.scalar.MapEntriesFunction;
import io.prestosql.operator.scalar.MapEqualOperator;
import io.prestosql.operator.scalar.MapFilterFunction;
import io.prestosql.operator.scalar.MapFromEntriesFunction;
import io.prestosql.operator.scalar.MapHashCodeOperator;
import io.prestosql.operator.scalar.MapIndeterminateOperator;
import io.prestosql.operator.scalar.MapKeys;
import io.prestosql.operator.scalar.MapNotEqualOperator;
import io.prestosql.operator.scalar.MapSubscriptOperator;
import io.prestosql.operator.scalar.MapToJsonCast;
import io.prestosql.operator.scalar.MapToMapCast;
import io.prestosql.operator.scalar.MapTransformKeyFunction;
import io.prestosql.operator.scalar.MapTransformValueFunction;
import io.prestosql.operator.scalar.MapValues;
import io.prestosql.operator.scalar.MapZipWithFunction;
import io.prestosql.operator.scalar.MathFunctions;
import io.prestosql.operator.scalar.MultimapFromEntriesFunction;
import io.prestosql.operator.scalar.QuantileDigestFunctions;
import io.prestosql.operator.scalar.Re2JCastToRegexpFunction;
import io.prestosql.operator.scalar.Re2JRegexpFunctions;
import io.prestosql.operator.scalar.Re2JRegexpReplaceLambdaFunction;
import io.prestosql.operator.scalar.RepeatFunction;
import io.prestosql.operator.scalar.RowDistinctFromOperator;
import io.prestosql.operator.scalar.RowEqualOperator;
import io.prestosql.operator.scalar.RowGreaterThanOperator;
import io.prestosql.operator.scalar.RowGreaterThanOrEqualOperator;
import io.prestosql.operator.scalar.RowHashCodeOperator;
import io.prestosql.operator.scalar.RowIndeterminateOperator;
import io.prestosql.operator.scalar.RowLessThanOperator;
import io.prestosql.operator.scalar.RowLessThanOrEqualOperator;
import io.prestosql.operator.scalar.RowNotEqualOperator;
import io.prestosql.operator.scalar.RowToJsonCast;
import io.prestosql.operator.scalar.RowToRowCast;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.operator.scalar.SequenceFunction;
import io.prestosql.operator.scalar.SessionFunctions;
import io.prestosql.operator.scalar.SplitToMapFunction;
import io.prestosql.operator.scalar.SplitToMultimapFunction;
import io.prestosql.operator.scalar.StringFunctions;
import io.prestosql.operator.scalar.TryCastFunction;
import io.prestosql.operator.scalar.TryFunction;
import io.prestosql.operator.scalar.TypeOfFunction;
import io.prestosql.operator.scalar.UrlFunctions;
import io.prestosql.operator.scalar.VarbinaryFunctions;
import io.prestosql.operator.scalar.WilsonInterval;
import io.prestosql.operator.scalar.WordStemFunction;
import io.prestosql.operator.scalar.ZipFunction;
import io.prestosql.operator.scalar.ZipWithFunction;
import io.prestosql.operator.window.AggregateWindowFunction;
import io.prestosql.operator.window.CumulativeDistributionFunction;
import io.prestosql.operator.window.DenseRankFunction;
import io.prestosql.operator.window.FirstValueFunction;
import io.prestosql.operator.window.LagFunction;
import io.prestosql.operator.window.LastValueFunction;
import io.prestosql.operator.window.LeadFunction;
import io.prestosql.operator.window.NTileFunction;
import io.prestosql.operator.window.NthValueFunction;
import io.prestosql.operator.window.PercentRankFunction;
import io.prestosql.operator.window.RankFunction;
import io.prestosql.operator.window.RowNumberFunction;
import io.prestosql.operator.window.SqlWindowFunction;
import io.prestosql.operator.window.WindowFunctionSupplier;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.sql.analyzer.TypeSignatureProvider;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.type.BigintOperators;
import io.prestosql.type.BooleanOperators;
import io.prestosql.type.CharOperators;
import io.prestosql.type.ColorOperators;
import io.prestosql.type.DateOperators;
import io.prestosql.type.DateTimeOperators;
import io.prestosql.type.DecimalCasts;
import io.prestosql.type.DecimalInequalityOperators;
import io.prestosql.type.DecimalOperators;
import io.prestosql.type.DecimalSaturatedFloorCasts;
import io.prestosql.type.DecimalToDecimalCasts;
import io.prestosql.type.DoubleOperators;
import io.prestosql.type.HyperLogLogOperators;
import io.prestosql.type.IntegerOperators;
import io.prestosql.type.IntervalDayTimeOperators;
import io.prestosql.type.IntervalYearMonthOperators;
import io.prestosql.type.IpAddressOperators;
import io.prestosql.type.LikeFunctions;
import io.prestosql.type.QuantileDigestOperators;
import io.prestosql.type.RealOperators;
import io.prestosql.type.SmallintOperators;
import io.prestosql.type.TimeOperators;
import io.prestosql.type.TimeWithTimeZoneOperators;
import io.prestosql.type.TimestampOperators;
import io.prestosql.type.TimestampWithTimeZoneOperators;
import io.prestosql.type.TinyintOperators;
import io.prestosql.type.TypeRegistry;
import io.prestosql.type.TypeUtils;
import io.prestosql.type.UnknownOperators;
import io.prestosql.type.UnknownType;
import io.prestosql.type.VarbinaryOperators;
import io.prestosql.type.VarcharOperators;
import io.prestosql.type.setdigest.BuildSetDigestAggregation;
import io.prestosql.type.setdigest.MergeSetDigestAggregation;
import io.prestosql.type.setdigest.SetDigestFunctions;
import io.prestosql.type.setdigest.SetDigestOperators;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class FunctionRegistry {
    private static final String MAGIC_LITERAL_FUNCTION_PREFIX = "$literal$";
    private static final String OPERATOR_PREFIX = "$operator$";
    private static final Set<Class<?>> SUPPORTED_LITERAL_TYPES = ImmutableSet.of(Long.TYPE, Double.TYPE, Slice.class, Boolean.TYPE);
    private final TypeManager typeManager;
    private final LoadingCache<Signature, SpecializedFunctionKey> specializedFunctionKeyCache;
    private final LoadingCache<SpecializedFunctionKey, ScalarFunctionImplementation> specializedScalarCache;
    private final LoadingCache<SpecializedFunctionKey, InternalAggregationFunction> specializedAggregationCache;
    private final LoadingCache<SpecializedFunctionKey, WindowFunctionSupplier> specializedWindowCache;
    private final MagicLiteralFunction magicLiteralFunction;
    private volatile FunctionMap functions = new FunctionMap();
    private final FunctionInvokerProvider functionInvokerProvider;

    public FunctionRegistry(TypeManager typeManager, BlockEncodingSerde blockEncodingSerde, FeaturesConfig featuresConfig) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.magicLiteralFunction = new MagicLiteralFunction(blockEncodingSerde);
        this.specializedFunctionKeyCache = CacheBuilder.newBuilder().maximumSize(1000L).build(CacheLoader.from(this::doGetSpecializedFunctionKey));
        this.specializedScalarCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS).build(CacheLoader.from(key -> ((SqlScalarFunction)key.getFunction()).specialize(key.getBoundVariables(), key.getArity(), typeManager, this)));
        this.specializedAggregationCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS).build(CacheLoader.from(key -> ((SqlAggregationFunction)key.getFunction()).specialize(key.getBoundVariables(), key.getArity(), typeManager, this)));
        this.specializedWindowCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS).build(CacheLoader.from(key -> {
            if (key.getFunction() instanceof SqlAggregationFunction) {
                return AggregateWindowFunction.supplier(key.getFunction().getSignature(), (InternalAggregationFunction)this.specializedAggregationCache.getUnchecked(key));
            }
            return ((SqlWindowFunction)key.getFunction()).specialize(key.getBoundVariables(), key.getArity(), typeManager, this);
        }));
        FunctionListBuilder builder = new FunctionListBuilder().window(RowNumberFunction.class).window(RankFunction.class).window(DenseRankFunction.class).window(PercentRankFunction.class).window(CumulativeDistributionFunction.class).window(NTileFunction.class).window(FirstValueFunction.class).window(LastValueFunction.class).window(NthValueFunction.class).window(LagFunction.class).window(LeadFunction.class).aggregate(ApproximateCountDistinctAggregation.class).aggregate(DefaultApproximateCountDistinctAggregation.class).aggregate(SumDataSizeForStats.class).aggregate(MaxDataSizeForStats.class).aggregates(CountAggregation.class).aggregates(VarianceAggregation.class).aggregates(CentralMomentsAggregation.class).aggregates(ApproximateLongPercentileAggregations.class).aggregates(ApproximateLongPercentileArrayAggregations.class).aggregates(ApproximateDoublePercentileAggregations.class).aggregates(ApproximateDoublePercentileArrayAggregations.class).aggregates(ApproximateRealPercentileAggregations.class).aggregates(ApproximateRealPercentileArrayAggregations.class).aggregates(CountIfAggregation.class).aggregates(BooleanAndAggregation.class).aggregates(BooleanOrAggregation.class).aggregates(DoubleSumAggregation.class).aggregates(RealSumAggregation.class).aggregates(LongSumAggregation.class).aggregates(IntervalDayToSecondSumAggregation.class).aggregates(IntervalYearToMonthSumAggregation.class).aggregates(AverageAggregations.class).function(RealAverageAggregation.REAL_AVERAGE_AGGREGATION).aggregates(IntervalDayToSecondAverageAggregation.class).aggregates(IntervalYearToMonthAverageAggregation.class).aggregates(GeometricMeanAggregations.class).aggregates(RealGeometricMeanAggregations.class).aggregates(MergeHyperLogLogAggregation.class).aggregates(ApproximateSetAggregation.class).functions(QuantileDigestAggregationFunction.QDIGEST_AGG, QuantileDigestAggregationFunction.QDIGEST_AGG_WITH_WEIGHT, QuantileDigestAggregationFunction.QDIGEST_AGG_WITH_WEIGHT_AND_ERROR).function(MergeQuantileDigestFunction.MERGE).aggregates(DoubleHistogramAggregation.class).aggregates(RealHistogramAggregation.class).aggregates(DoubleCovarianceAggregation.class).aggregates(RealCovarianceAggregation.class).aggregates(DoubleRegressionAggregation.class).aggregates(RealRegressionAggregation.class).aggregates(DoubleCorrelationAggregation.class).aggregates(RealCorrelationAggregation.class).aggregates(BitwiseOrAggregation.class).aggregates(BitwiseAndAggregation.class).scalar(RepeatFunction.class).scalars(SequenceFunction.class).scalars(SessionFunctions.class).scalars(StringFunctions.class).scalars(WordStemFunction.class).scalar(SplitToMapFunction.class).scalar(SplitToMultimapFunction.class).scalars(VarbinaryFunctions.class).scalars(UrlFunctions.class).scalars(MathFunctions.class).scalar(MathFunctions.Abs.class).scalar(MathFunctions.Sign.class).scalar(MathFunctions.Round.class).scalar(MathFunctions.RoundN.class).scalar(MathFunctions.Truncate.class).scalar(MathFunctions.TruncateN.class).scalar(MathFunctions.Ceiling.class).scalar(MathFunctions.Floor.class).scalars(BitwiseFunctions.class).scalars(DateTimeFunctions.class).scalars(JsonFunctions.class).scalars(ColorFunctions.class).scalars(ColorOperators.class).scalar(ColorOperators.ColorDistinctFromOperator.class).scalars(HyperLogLogFunctions.class).scalars(QuantileDigestFunctions.class).scalars(UnknownOperators.class).scalar(UnknownOperators.UnknownDistinctFromOperator.class).scalars(BooleanOperators.class).scalar(BooleanOperators.BooleanDistinctFromOperator.class).scalars(BigintOperators.class).scalar(BigintOperators.BigintDistinctFromOperator.class).scalars(IntegerOperators.class).scalar(IntegerOperators.IntegerDistinctFromOperator.class).scalars(SmallintOperators.class).scalar(SmallintOperators.SmallintDistinctFromOperator.class).scalars(TinyintOperators.class).scalar(TinyintOperators.TinyintDistinctFromOperator.class).scalars(DoubleOperators.class).scalar(DoubleOperators.DoubleDistinctFromOperator.class).scalars(RealOperators.class).scalar(RealOperators.RealDistinctFromOperator.class).scalars(VarcharOperators.class).scalar(VarcharOperators.VarcharDistinctFromOperator.class).scalars(VarbinaryOperators.class).scalar(VarbinaryOperators.VarbinaryDistinctFromOperator.class).scalars(DateOperators.class).scalar(DateOperators.DateDistinctFromOperator.class).scalars(TimeOperators.class).scalar(TimeOperators.TimeDistinctFromOperator.class).scalars(TimestampOperators.class).scalar(TimestampOperators.TimestampDistinctFromOperator.class).scalars(IntervalDayTimeOperators.class).scalar(IntervalDayTimeOperators.IntervalDayTimeDistinctFromOperator.class).scalars(IntervalYearMonthOperators.class).scalar(IntervalYearMonthOperators.IntervalYearMonthDistinctFromOperator.class).scalars(TimeWithTimeZoneOperators.class).scalar(TimeWithTimeZoneOperators.TimeWithTimeZoneDistinctFromOperator.class).scalars(TimestampWithTimeZoneOperators.class).scalar(TimestampWithTimeZoneOperators.TimestampWithTimeZoneDistinctFromOperator.class).scalars(DateTimeOperators.class).scalars(HyperLogLogOperators.class).scalars(QuantileDigestOperators.class).scalars(IpAddressOperators.class).scalar(IpAddressOperators.IpAddressDistinctFromOperator.class).scalars(LikeFunctions.class).scalars(ArrayFunctions.class).scalars(HmacFunctions.class).scalars(DataSizeFunctions.class).scalar(ArrayCardinalityFunction.class).scalar(ArrayContains.class).scalar(ArrayFilterFunction.class).scalar(ArrayPositionFunction.class).scalars(CombineHashFunction.class).scalars(JsonOperators.class).scalar(JsonOperators.JsonDistinctFromOperator.class).scalars(FailureFunction.class).scalars(JoniRegexpCasts.class).scalars(CharacterStringCasts.class).scalars(CharOperators.class).scalar(CharOperators.CharDistinctFromOperator.class).scalar(DecimalOperators.Negation.class).scalar(DecimalOperators.HashCode.class).scalar(DecimalOperators.Indeterminate.class).scalar(DecimalOperators.XxHash64Operator.class).functions(IdentityCast.IDENTITY_CAST, CastFromUnknownOperator.CAST_FROM_UNKNOWN).scalar(ArrayLessThanOperator.class).scalar(ArrayLessThanOrEqualOperator.class).scalar(ArrayRemoveFunction.class).scalar(ArrayGreaterThanOperator.class).scalar(ArrayGreaterThanOrEqualOperator.class).scalar(ArrayElementAtFunction.class).scalar(ArraySortFunction.class).scalar(ArraySortComparatorFunction.class).scalar(ArrayShuffleFunction.class).scalar(ArrayReverseFunction.class).scalar(ArrayMinFunction.class).scalar(ArrayMaxFunction.class).scalar(ArrayDistinctFunction.class).scalar(ArrayNotEqualOperator.class).scalar(ArrayEqualOperator.class).scalar(ArrayHashCodeOperator.class).scalar(ArrayIntersectFunction.class).scalar(ArraysOverlapFunction.class).scalar(ArrayDistinctFromOperator.class).scalar(ArrayUnionFunction.class).scalar(ArrayExceptFunction.class).scalar(ArraySliceFunction.class).scalar(ArrayIndeterminateOperator.class).scalar(ArrayCombinationsFunction.class).scalar(ArrayNgramsFunction.class).scalar(MapDistinctFromOperator.class).scalar(MapEqualOperator.class).scalar(MapEntriesFunction.class).scalar(MapFromEntriesFunction.class).scalar(MultimapFromEntriesFunction.class).scalar(MapNotEqualOperator.class).scalar(MapKeys.class).scalar(MapValues.class).scalar(MapCardinalityFunction.class).scalar(EmptyMapConstructor.class).scalar(MapIndeterminateOperator.class).scalar(TypeOfFunction.class).scalar(TryFunction.class).functions(ZipWithFunction.ZIP_WITH_FUNCTION, MapZipWithFunction.MAP_ZIP_WITH_FUNCTION).functions(ZipFunction.ZIP_FUNCTIONS).functions(ArrayJoin.ARRAY_JOIN, ArrayJoin.ARRAY_JOIN_WITH_NULL_REPLACEMENT).functions(ArrayToArrayCast.ARRAY_TO_ARRAY_CAST).functions(ArrayToElementConcatFunction.ARRAY_TO_ELEMENT_CONCAT_FUNCTION, ElementToArrayConcatFunction.ELEMENT_TO_ARRAY_CONCAT_FUNCTION).function(MapHashCodeOperator.MAP_HASH_CODE).function(MapElementAtFunction.MAP_ELEMENT_AT).function(MapConcatFunction.MAP_CONCAT_FUNCTION).function(MapToMapCast.MAP_TO_MAP_CAST).function(ArrayFlattenFunction.ARRAY_FLATTEN_FUNCTION).function(ArrayConcatFunction.ARRAY_CONCAT_FUNCTION).functions(ArrayConstructor.ARRAY_CONSTRUCTOR, ArraySubscriptOperator.ARRAY_SUBSCRIPT, ArrayToJsonCast.ARRAY_TO_JSON, JsonToArrayCast.JSON_TO_ARRAY, JsonStringToArrayCast.JSON_STRING_TO_ARRAY).function(new ArrayAggregationFunction(featuresConfig.getArrayAggGroupImplementation())).functions(new MapSubscriptOperator()).functions(MapConstructor.MAP_CONSTRUCTOR, MapToJsonCast.MAP_TO_JSON, JsonToMapCast.JSON_TO_MAP, JsonStringToMapCast.JSON_STRING_TO_MAP).functions(MapAggregationFunction.MAP_AGG, MapUnionAggregation.MAP_UNION).function(ReduceAggregationFunction.REDUCE_AGG).function(new MultimapAggregationFunction(featuresConfig.getMultimapAggGroupImplementation())).functions(DecimalCasts.DECIMAL_TO_VARCHAR_CAST, DecimalCasts.DECIMAL_TO_INTEGER_CAST, DecimalCasts.DECIMAL_TO_BIGINT_CAST, DecimalCasts.DECIMAL_TO_DOUBLE_CAST, DecimalCasts.DECIMAL_TO_REAL_CAST, DecimalCasts.DECIMAL_TO_BOOLEAN_CAST, DecimalCasts.DECIMAL_TO_TINYINT_CAST, DecimalCasts.DECIMAL_TO_SMALLINT_CAST).functions(DecimalCasts.VARCHAR_TO_DECIMAL_CAST, DecimalCasts.INTEGER_TO_DECIMAL_CAST, DecimalCasts.BIGINT_TO_DECIMAL_CAST, DecimalCasts.DOUBLE_TO_DECIMAL_CAST, DecimalCasts.REAL_TO_DECIMAL_CAST, DecimalCasts.BOOLEAN_TO_DECIMAL_CAST, DecimalCasts.TINYINT_TO_DECIMAL_CAST, DecimalCasts.SMALLINT_TO_DECIMAL_CAST).functions(DecimalCasts.JSON_TO_DECIMAL_CAST, DecimalCasts.DECIMAL_TO_JSON_CAST).functions(DecimalOperators.DECIMAL_ADD_OPERATOR, DecimalOperators.DECIMAL_SUBTRACT_OPERATOR, DecimalOperators.DECIMAL_MULTIPLY_OPERATOR, DecimalOperators.DECIMAL_DIVIDE_OPERATOR, DecimalOperators.DECIMAL_MODULUS_OPERATOR).functions(DecimalInequalityOperators.DECIMAL_EQUAL_OPERATOR, DecimalInequalityOperators.DECIMAL_NOT_EQUAL_OPERATOR).functions(DecimalInequalityOperators.DECIMAL_LESS_THAN_OPERATOR, DecimalInequalityOperators.DECIMAL_LESS_THAN_OR_EQUAL_OPERATOR).functions(DecimalInequalityOperators.DECIMAL_GREATER_THAN_OPERATOR, DecimalInequalityOperators.DECIMAL_GREATER_THAN_OR_EQUAL_OPERATOR).function(DecimalSaturatedFloorCasts.DECIMAL_TO_DECIMAL_SATURATED_FLOOR_CAST).functions(DecimalSaturatedFloorCasts.DECIMAL_TO_BIGINT_SATURATED_FLOOR_CAST, DecimalSaturatedFloorCasts.BIGINT_TO_DECIMAL_SATURATED_FLOOR_CAST).functions(DecimalSaturatedFloorCasts.DECIMAL_TO_INTEGER_SATURATED_FLOOR_CAST, DecimalSaturatedFloorCasts.INTEGER_TO_DECIMAL_SATURATED_FLOOR_CAST).functions(DecimalSaturatedFloorCasts.DECIMAL_TO_SMALLINT_SATURATED_FLOOR_CAST, DecimalSaturatedFloorCasts.SMALLINT_TO_DECIMAL_SATURATED_FLOOR_CAST).functions(DecimalSaturatedFloorCasts.DECIMAL_TO_TINYINT_SATURATED_FLOOR_CAST, DecimalSaturatedFloorCasts.TINYINT_TO_DECIMAL_SATURATED_FLOOR_CAST).function(DecimalInequalityOperators.DECIMAL_BETWEEN_OPERATOR).function(DecimalInequalityOperators.DECIMAL_DISTINCT_FROM_OPERATOR).function(new Histogram(featuresConfig.getHistogramGroupImplementation())).function(ChecksumAggregationFunction.CHECKSUM_AGGREGATION).function(IdentityCast.IDENTITY_CAST).function(ArbitraryAggregationFunction.ARBITRARY_AGGREGATION).functions(Greatest.GREATEST, Least.LEAST).functions(MaxByAggregationFunction.MAX_BY, MinByAggregationFunction.MIN_BY, MaxByNAggregationFunction.MAX_BY_N_AGGREGATION, MinByNAggregationFunction.MIN_BY_N_AGGREGATION).functions(MaxAggregationFunction.MAX_AGGREGATION, MinAggregationFunction.MIN_AGGREGATION, MaxNAggregationFunction.MAX_N_AGGREGATION, MinNAggregationFunction.MIN_N_AGGREGATION).function(CountColumn.COUNT_COLUMN).functions(RowHashCodeOperator.ROW_HASH_CODE, RowToJsonCast.ROW_TO_JSON, JsonToRowCast.JSON_TO_ROW, JsonStringToRowCast.JSON_STRING_TO_ROW, RowDistinctFromOperator.ROW_DISTINCT_FROM, RowEqualOperator.ROW_EQUAL, RowGreaterThanOperator.ROW_GREATER_THAN, RowGreaterThanOrEqualOperator.ROW_GREATER_THAN_OR_EQUAL, RowLessThanOperator.ROW_LESS_THAN, RowLessThanOrEqualOperator.ROW_LESS_THAN_OR_EQUAL, RowNotEqualOperator.ROW_NOT_EQUAL, RowToRowCast.ROW_TO_ROW_CAST, RowIndeterminateOperator.ROW_INDETERMINATE).functions(ConcatFunction.VARCHAR_CONCAT, ConcatFunction.VARBINARY_CONCAT).function(DecimalToDecimalCasts.DECIMAL_TO_DECIMAL_CAST).function(Re2JCastToRegexpFunction.castVarcharToRe2JRegexp(featuresConfig.getRe2JDfaStatesLimit(), featuresConfig.getRe2JDfaRetries())).function(Re2JCastToRegexpFunction.castCharToRe2JRegexp(featuresConfig.getRe2JDfaStatesLimit(), featuresConfig.getRe2JDfaRetries())).function(DecimalAverageAggregation.DECIMAL_AVERAGE_AGGREGATION).function(DecimalSumAggregation.DECIMAL_SUM_AGGREGATION).function(MathFunctions.DECIMAL_MOD_FUNCTION).functions(ArrayTransformFunction.ARRAY_TRANSFORM_FUNCTION, ArrayReduceFunction.ARRAY_REDUCE_FUNCTION).functions(MapFilterFunction.MAP_FILTER_FUNCTION, MapTransformKeyFunction.MAP_TRANSFORM_KEY_FUNCTION, MapTransformValueFunction.MAP_TRANSFORM_VALUE_FUNCTION).function(TryCastFunction.TRY_CAST).aggregate(MergeSetDigestAggregation.class).aggregate(BuildSetDigestAggregation.class).scalars(SetDigestFunctions.class).scalars(SetDigestOperators.class).scalars(WilsonInterval.class);
        switch (featuresConfig.getRegexLibrary()) {
            case JONI: {
                builder.scalars(JoniRegexpFunctions.class);
                builder.scalar(JoniRegexpReplaceLambdaFunction.class);
                break;
            }
            case RE2J: {
                builder.scalars(Re2JRegexpFunctions.class);
                builder.scalar(Re2JRegexpReplaceLambdaFunction.class);
            }
        }
        this.addFunctions(builder.getFunctions());
        if (typeManager instanceof TypeRegistry) {
            ((TypeRegistry)typeManager).setFunctionRegistry(this);
        }
        this.functionInvokerProvider = new FunctionInvokerProvider(this);
    }

    public FunctionInvokerProvider getFunctionInvokerProvider() {
        return this.functionInvokerProvider;
    }

    public final synchronized void addFunctions(List<? extends SqlFunction> functions) {
        for (SqlFunction sqlFunction : functions) {
            for (SqlFunction existingFunction : this.functions.list()) {
                Preconditions.checkArgument((!sqlFunction.getSignature().equals(existingFunction.getSignature()) ? 1 : 0) != 0, (String)"Function already registered: %s", (Object)sqlFunction.getSignature());
            }
        }
        this.functions = new FunctionMap(this.functions, functions);
    }

    public List<SqlFunction> list() {
        return (List)this.functions.list().stream().filter(function -> !function.isHidden()).collect(ImmutableList.toImmutableList());
    }

    public boolean isAggregationFunction(QualifiedName name) {
        return Iterables.any(this.functions.get(name), function -> function.getSignature().getKind() == FunctionKind.AGGREGATE);
    }

    public Signature resolveFunction(QualifiedName name, List<TypeSignatureProvider> parameterTypes) {
        Collection<SqlFunction> allCandidates = this.functions.get(name);
        List<SqlFunction> exactCandidates = allCandidates.stream().filter(function -> function.getSignature().getTypeVariableConstraints().isEmpty()).collect(Collectors.toList());
        Optional<Signature> match = this.matchFunctionExact(exactCandidates, parameterTypes);
        if (match.isPresent()) {
            return match.get();
        }
        List<SqlFunction> genericCandidates = allCandidates.stream().filter(function -> !function.getSignature().getTypeVariableConstraints().isEmpty()).collect(Collectors.toList());
        match = this.matchFunctionExact(genericCandidates, parameterTypes);
        if (match.isPresent()) {
            return match.get();
        }
        match = this.matchFunctionWithCoercion(allCandidates, parameterTypes);
        if (match.isPresent()) {
            return match.get();
        }
        ArrayList<String> expectedParameters = new ArrayList<String>();
        for (SqlFunction function2 : allCandidates) {
            expectedParameters.add(String.format("%s(%s) %s", name, Joiner.on((String)", ").join(function2.getSignature().getArgumentTypes()), Joiner.on((String)", ").join(function2.getSignature().getTypeVariableConstraints())));
        }
        String parameters = Joiner.on((String)", ").join(parameterTypes);
        String message = String.format("Function %s not registered", name);
        if (!expectedParameters.isEmpty()) {
            String expected = Joiner.on((String)", ").join(expectedParameters);
            message = String.format("Unexpected parameters (%s) for function %s. Expected: %s", parameters, name, expected);
        }
        if (name.getSuffix().startsWith(MAGIC_LITERAL_FUNCTION_PREFIX)) {
            String typeName = name.getSuffix().substring(MAGIC_LITERAL_FUNCTION_PREFIX.length());
            Type type = this.typeManager.getType(TypeSignature.parseTypeSignature((String)typeName));
            Preconditions.checkArgument((parameterTypes.size() == 1 ? 1 : 0) != 0, (String)"Expected one argument to literal function, but got %s", parameterTypes);
            Type parameterType = this.typeManager.getType(parameterTypes.get(0).getTypeSignature());
            return FunctionRegistry.getMagicLiteralFunctionSignature(type);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, message);
    }

    private Optional<Signature> matchFunctionExact(List<SqlFunction> candidates, List<TypeSignatureProvider> actualParameters) {
        return this.matchFunction(candidates, actualParameters, false);
    }

    private Optional<Signature> matchFunctionWithCoercion(Collection<SqlFunction> candidates, List<TypeSignatureProvider> actualParameters) {
        return this.matchFunction(candidates, actualParameters, true);
    }

    private Optional<Signature> matchFunction(Collection<SqlFunction> candidates, List<TypeSignatureProvider> parameters, boolean coercionAllowed) {
        List<ApplicableFunction> applicableFunctions = this.identifyApplicableFunctions(candidates, parameters, coercionAllowed);
        if (applicableFunctions.isEmpty()) {
            return Optional.empty();
        }
        if (coercionAllowed) {
            Preconditions.checkState((!(applicableFunctions = this.selectMostSpecificFunctions(applicableFunctions, parameters)).isEmpty() ? 1 : 0) != 0, (Object)"at least single function must be left");
        }
        if (applicableFunctions.size() == 1) {
            return Optional.of(((ApplicableFunction)Iterables.getOnlyElement(applicableFunctions)).getBoundSignature());
        }
        StringBuilder errorMessageBuilder = new StringBuilder();
        errorMessageBuilder.append("Could not choose a best candidate operator. Explicit type casts must be added.\n");
        errorMessageBuilder.append("Candidates are:\n");
        for (ApplicableFunction function : applicableFunctions) {
            errorMessageBuilder.append("\t * ");
            errorMessageBuilder.append(function.getBoundSignature().toString());
            errorMessageBuilder.append("\n");
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_FUNCTION_CALL, errorMessageBuilder.toString());
    }

    private List<ApplicableFunction> identifyApplicableFunctions(Collection<SqlFunction> candidates, List<TypeSignatureProvider> actualParameters, boolean allowCoercion) {
        ImmutableList.Builder applicableFunctions = ImmutableList.builder();
        for (SqlFunction function : candidates) {
            Signature declaredSignature = function.getSignature();
            Optional<Signature> boundSignature = new SignatureBinder(this.typeManager, declaredSignature, allowCoercion).bind(actualParameters);
            if (!boundSignature.isPresent()) continue;
            applicableFunctions.add((Object)new ApplicableFunction(declaredSignature, boundSignature.get()));
        }
        return applicableFunctions.build();
    }

    private List<ApplicableFunction> selectMostSpecificFunctions(List<ApplicableFunction> applicableFunctions, List<TypeSignatureProvider> parameters) {
        Preconditions.checkArgument((!applicableFunctions.isEmpty() ? 1 : 0) != 0);
        List<ApplicableFunction> mostSpecificFunctions = this.selectMostSpecificFunctions(applicableFunctions);
        if (mostSpecificFunctions.size() <= 1) {
            return mostSpecificFunctions;
        }
        Optional<List<Type>> optionalParameterTypes = FunctionRegistry.toTypes(parameters, this.typeManager);
        if (!optionalParameterTypes.isPresent()) {
            return mostSpecificFunctions;
        }
        List<Type> parameterTypes = optionalParameterTypes.get();
        if (!FunctionRegistry.someParameterIsUnknown(parameterTypes)) {
            return mostSpecificFunctions;
        }
        List<ApplicableFunction> unknownOnlyCastFunctions = this.getUnknownOnlyCastFunctions(applicableFunctions, parameterTypes);
        if (!unknownOnlyCastFunctions.isEmpty() && (mostSpecificFunctions = unknownOnlyCastFunctions).size() == 1) {
            return mostSpecificFunctions;
        }
        if (this.returnTypeIsTheSame(mostSpecificFunctions) && this.allReturnNullOnGivenInputTypes(mostSpecificFunctions, parameterTypes)) {
            ApplicableFunction selectedFunction = (ApplicableFunction)Ordering.usingToString().reverse().sortedCopy(mostSpecificFunctions).get(0);
            return ImmutableList.of((Object)selectedFunction);
        }
        return mostSpecificFunctions;
    }

    private List<ApplicableFunction> selectMostSpecificFunctions(List<ApplicableFunction> candidates) {
        ArrayList<ApplicableFunction> representatives = new ArrayList<ApplicableFunction>();
        for (ApplicableFunction current : candidates) {
            boolean found = false;
            for (int i = 0; i < representatives.size(); ++i) {
                ApplicableFunction representative = (ApplicableFunction)representatives.get(i);
                if (this.isMoreSpecificThan(current, representative)) {
                    representatives.set(i, current);
                }
                if (!this.isMoreSpecificThan(current, representative) && !this.isMoreSpecificThan(representative, current)) continue;
                found = true;
                break;
            }
            if (found) continue;
            representatives.add(current);
        }
        return representatives;
    }

    private static boolean someParameterIsUnknown(List<Type> parameters) {
        return parameters.stream().anyMatch(type -> type.equals((Object)UnknownType.UNKNOWN));
    }

    private List<ApplicableFunction> getUnknownOnlyCastFunctions(List<ApplicableFunction> applicableFunction, List<Type> actualParameters) {
        return (List)applicableFunction.stream().filter(function -> this.onlyCastsUnknown((ApplicableFunction)function, actualParameters)).collect(ImmutableList.toImmutableList());
    }

    private boolean onlyCastsUnknown(ApplicableFunction applicableFunction, List<Type> actualParameters) {
        List<Type> boundTypes = TypeUtils.resolveTypes(applicableFunction.getBoundSignature().getArgumentTypes(), this.typeManager);
        Preconditions.checkState((actualParameters.size() == boundTypes.size() ? 1 : 0) != 0, (Object)"type lists are of different lengths");
        for (int i = 0; i < actualParameters.size(); ++i) {
            if (boundTypes.get(i).equals(actualParameters.get(i)) || actualParameters.get(i) == UnknownType.UNKNOWN) continue;
            return false;
        }
        return true;
    }

    private boolean returnTypeIsTheSame(List<ApplicableFunction> applicableFunctions) {
        Set returnTypes = applicableFunctions.stream().map(function -> this.typeManager.getType(function.getBoundSignature().getReturnType())).collect(Collectors.toSet());
        return returnTypes.size() == 1;
    }

    private boolean allReturnNullOnGivenInputTypes(List<ApplicableFunction> applicableFunctions, List<Type> parameters) {
        return applicableFunctions.stream().allMatch(x -> this.returnsNullOnGivenInputTypes((ApplicableFunction)x, parameters));
    }

    private boolean returnsNullOnGivenInputTypes(ApplicableFunction applicableFunction, List<Type> parameterTypes) {
        Signature boundSignature = applicableFunction.getBoundSignature();
        FunctionKind functionKind = boundSignature.getKind();
        if (functionKind != FunctionKind.SCALAR) {
            return true;
        }
        for (int i = 0; i < parameterTypes.size(); ++i) {
            ScalarFunctionImplementation implementation;
            Type parameterType = parameterTypes.get(i);
            if (!parameterType.equals((Object)UnknownType.UNKNOWN) || (implementation = this.getScalarFunctionImplementation(boundSignature)).getArgumentProperty(i).getNullConvention() == ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL) continue;
            return false;
        }
        return true;
    }

    public WindowFunctionSupplier getWindowFunctionImplementation(Signature signature) {
        Preconditions.checkArgument((signature.getKind() == FunctionKind.WINDOW || signature.getKind() == FunctionKind.AGGREGATE ? 1 : 0) != 0, (String)"%s is not a window function", (Object)signature);
        Preconditions.checkArgument((boolean)signature.getTypeVariableConstraints().isEmpty(), (String)"%s has unbound type parameters", (Object)signature);
        try {
            return (WindowFunctionSupplier)this.specializedWindowCache.getUnchecked((Object)this.getSpecializedFunctionKey(signature));
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), PrestoException.class);
            throw e;
        }
    }

    public InternalAggregationFunction getAggregateFunctionImplementation(Signature signature) {
        Preconditions.checkArgument((signature.getKind() == FunctionKind.AGGREGATE ? 1 : 0) != 0, (String)"%s is not an aggregate function", (Object)signature);
        Preconditions.checkArgument((boolean)signature.getTypeVariableConstraints().isEmpty(), (String)"%s has unbound type parameters", (Object)signature);
        try {
            return (InternalAggregationFunction)this.specializedAggregationCache.getUnchecked((Object)this.getSpecializedFunctionKey(signature));
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), PrestoException.class);
            throw e;
        }
    }

    public ScalarFunctionImplementation getScalarFunctionImplementation(Signature signature) {
        Preconditions.checkArgument((signature.getKind() == FunctionKind.SCALAR ? 1 : 0) != 0, (String)"%s is not a scalar function", (Object)signature);
        Preconditions.checkArgument((boolean)signature.getTypeVariableConstraints().isEmpty(), (String)"%s has unbound type parameters", (Object)signature);
        try {
            return (ScalarFunctionImplementation)this.specializedScalarCache.getUnchecked((Object)this.getSpecializedFunctionKey(signature));
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), PrestoException.class);
            throw e;
        }
    }

    private SpecializedFunctionKey getSpecializedFunctionKey(Signature signature) {
        try {
            return (SpecializedFunctionKey)this.specializedFunctionKeyCache.getUnchecked((Object)signature);
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), PrestoException.class);
            throw e;
        }
    }

    private SpecializedFunctionKey doGetSpecializedFunctionKey(Signature signature) {
        Collection<SqlFunction> candidates = this.functions.get(QualifiedName.of((String)signature.getName()));
        Type returnType = this.typeManager.getType(signature.getReturnType());
        List<TypeSignatureProvider> argumentTypeSignatureProviders = TypeSignatureProvider.fromTypeSignatures(signature.getArgumentTypes());
        for (SqlFunction sqlFunction : candidates) {
            Optional<BoundVariables> boundVariables = new SignatureBinder(this.typeManager, sqlFunction.getSignature(), false).bindVariables(argumentTypeSignatureProviders, returnType);
            if (!boundVariables.isPresent()) continue;
            return new SpecializedFunctionKey(sqlFunction, boundVariables.get(), argumentTypeSignatureProviders.size());
        }
        List<Type> argumentTypes = TypeUtils.resolveTypes(signature.getArgumentTypes(), this.typeManager);
        for (SqlFunction candidate : candidates) {
            Signature boundSignature;
            SignatureBinder binder = new SignatureBinder(this.typeManager, candidate.getSignature(), true);
            Optional<BoundVariables> boundVariables = binder.bindVariables(argumentTypeSignatureProviders, returnType);
            if (!boundVariables.isPresent() || !this.typeManager.isTypeOnlyCoercion(this.typeManager.getType((boundSignature = SignatureBinder.applyBoundVariables(candidate.getSignature(), boundVariables.get(), argumentTypes.size())).getReturnType()), returnType)) continue;
            boolean nonTypeOnlyCoercion = false;
            for (int i = 0; i < argumentTypes.size(); ++i) {
                Type expectedType = this.typeManager.getType(boundSignature.getArgumentTypes().get(i));
                if (this.typeManager.isTypeOnlyCoercion(argumentTypes.get(i), expectedType)) continue;
                nonTypeOnlyCoercion = true;
                break;
            }
            if (nonTypeOnlyCoercion) continue;
            return new SpecializedFunctionKey(candidate, boundVariables.get(), argumentTypes.size());
        }
        if (signature.getName().startsWith(MAGIC_LITERAL_FUNCTION_PREFIX)) {
            List<TypeSignature> list = signature.getArgumentTypes();
            String typeName = signature.getName().substring(MAGIC_LITERAL_FUNCTION_PREFIX.length());
            Type type = this.typeManager.getType(TypeSignature.parseTypeSignature((String)typeName));
            Preconditions.checkArgument((list.size() == 1 ? 1 : 0) != 0, (String)"Expected one argument to literal function, but got %s", list);
            Type parameterType = this.typeManager.getType(list.get(0));
            Objects.requireNonNull(parameterType, String.format("Type %s not found", list.get(0)));
            return new SpecializedFunctionKey(this.magicLiteralFunction, BoundVariables.builder().setTypeVariable("T", parameterType).setTypeVariable("R", type).build(), 1);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_MISSING, String.format("%s not found", signature));
    }

    @VisibleForTesting
    public List<SqlFunction> listOperators() {
        Set operatorNames = (Set)Arrays.asList(OperatorType.values()).stream().map(FunctionRegistry::mangleOperatorName).collect(ImmutableSet.toImmutableSet());
        return (List)this.functions.list().stream().filter(function -> operatorNames.contains(function.getSignature().getName())).collect(ImmutableList.toImmutableList());
    }

    public boolean canResolveOperator(OperatorType operatorType, Type returnType, List<? extends Type> argumentTypes) {
        Signature signature = Signature.internalOperator(operatorType, returnType, argumentTypes);
        return this.isRegistered(signature);
    }

    public boolean isRegistered(Signature signature) {
        try {
            this.getScalarFunctionImplementation(signature);
            return true;
        }
        catch (PrestoException e) {
            if (e.getErrorCode().getCode() == StandardErrorCode.FUNCTION_IMPLEMENTATION_MISSING.toErrorCode().getCode()) {
                return false;
            }
            throw e;
        }
    }

    public Signature resolveOperator(OperatorType operatorType, List<? extends Type> argumentTypes) throws OperatorNotFoundException {
        try {
            return this.resolveFunction(QualifiedName.of((String)FunctionRegistry.mangleOperatorName(operatorType)), TypeSignatureProvider.fromTypes(argumentTypes));
        }
        catch (PrestoException e) {
            if (e.getErrorCode().getCode() == StandardErrorCode.FUNCTION_NOT_FOUND.toErrorCode().getCode()) {
                throw new OperatorNotFoundException(operatorType, (List)argumentTypes.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList()));
            }
            throw e;
        }
    }

    public Signature getCoercion(Type fromType, Type toType) {
        return this.getCoercion(fromType.getTypeSignature(), toType.getTypeSignature());
    }

    public Signature getCoercion(TypeSignature fromType, TypeSignature toType) {
        Signature signature = Signature.internalOperator(OperatorType.CAST.name(), toType, (List<TypeSignature>)ImmutableList.of((Object)fromType));
        try {
            this.getScalarFunctionImplementation(signature);
        }
        catch (PrestoException e) {
            if (e.getErrorCode().getCode() == StandardErrorCode.FUNCTION_IMPLEMENTATION_MISSING.toErrorCode().getCode()) {
                throw new OperatorNotFoundException(OperatorType.CAST, (List<? extends TypeSignature>)ImmutableList.of((Object)fromType), toType);
            }
            throw e;
        }
        return signature;
    }

    public static Type typeForMagicLiteral(Type type) {
        Class clazz = type.getJavaType();
        if ((clazz = Primitives.unwrap((Class)clazz)) == Long.TYPE) {
            return BigintType.BIGINT;
        }
        if (clazz == Double.TYPE) {
            return DoubleType.DOUBLE;
        }
        if (!clazz.isPrimitive()) {
            if (type instanceof VarcharType) {
                return type;
            }
            return VarbinaryType.VARBINARY;
        }
        if (clazz == Boolean.TYPE) {
            return BooleanType.BOOLEAN;
        }
        throw new IllegalArgumentException("Unhandled Java type: " + clazz.getName());
    }

    public static Signature getMagicLiteralFunctionSignature(Type type) {
        TypeSignature argumentType = FunctionRegistry.typeForMagicLiteral(type).getTypeSignature();
        return new Signature(MAGIC_LITERAL_FUNCTION_PREFIX + type.getTypeSignature(), FunctionKind.SCALAR, type.getTypeSignature(), argumentType);
    }

    public static boolean isSupportedLiteralType(Type type) {
        return SUPPORTED_LITERAL_TYPES.contains(type.getJavaType());
    }

    public static String mangleOperatorName(OperatorType operatorType) {
        return FunctionRegistry.mangleOperatorName(operatorType.name());
    }

    public static String mangleOperatorName(String operatorName) {
        return OPERATOR_PREFIX + operatorName;
    }

    @VisibleForTesting
    public static OperatorType unmangleOperator(String mangledName) {
        Preconditions.checkArgument((boolean)mangledName.startsWith(OPERATOR_PREFIX), (String)"%s is not a mangled operator name", (Object)mangledName);
        return OperatorType.valueOf((String)mangledName.substring(OPERATOR_PREFIX.length()));
    }

    public static Optional<List<Type>> toTypes(List<TypeSignatureProvider> typeSignatureProviders, TypeManager typeManager) {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (TypeSignatureProvider typeSignatureProvider : typeSignatureProviders) {
            if (typeSignatureProvider.hasDependency()) {
                return Optional.empty();
            }
            resultBuilder.add((Object)typeManager.getType(typeSignatureProvider.getTypeSignature()));
        }
        return Optional.of(resultBuilder.build());
    }

    private boolean isMoreSpecificThan(ApplicableFunction left, ApplicableFunction right) {
        List<TypeSignatureProvider> resolvedTypes = TypeSignatureProvider.fromTypeSignatures(left.getBoundSignature().getArgumentTypes());
        Optional<BoundVariables> boundVariables = new SignatureBinder(this.typeManager, right.getDeclaredSignature(), true).bindVariables(resolvedTypes);
        return boundVariables.isPresent();
    }

    private static class MagicLiteralFunction
    extends SqlScalarFunction {
        private final BlockEncodingSerde blockEncodingSerde;

        public MagicLiteralFunction(BlockEncodingSerde blockEncodingSerde) {
            super(new Signature(FunctionRegistry.MAGIC_LITERAL_FUNCTION_PREFIX, FunctionKind.SCALAR, TypeSignature.parseTypeSignature((String)"R"), TypeSignature.parseTypeSignature((String)"T")));
            this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        }

        @Override
        public boolean isHidden() {
            return true;
        }

        @Override
        public boolean isDeterministic() {
            return true;
        }

        @Override
        public String getDescription() {
            return "magic literal";
        }

        @Override
        public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
            Type parameterType = boundVariables.getTypeVariable("T");
            Type type = boundVariables.getTypeVariable("R");
            MethodHandle methodHandle = null;
            if (parameterType.getJavaType() == type.getJavaType()) {
                methodHandle = MethodHandles.identity(parameterType.getJavaType());
            }
            if (parameterType.getJavaType() == Slice.class && type.getJavaType() == Block.class) {
                methodHandle = BlockSerdeUtil.READ_BLOCK.bindTo(this.blockEncodingSerde);
            }
            Preconditions.checkArgument((methodHandle != null ? 1 : 0) != 0, (String)"Expected type %s to use (or can be converted into) Java type %s, but Java type is %s", (Object)type, (Object)parameterType.getJavaType(), (Object)type.getJavaType());
            return new ScalarFunctionImplementation(false, (List<ScalarFunctionImplementation.ArgumentProperty>)ImmutableList.of((Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL)), methodHandle, this.isDeterministic());
        }
    }

    private static class ApplicableFunction {
        private final Signature declaredSignature;
        private final Signature boundSignature;

        private ApplicableFunction(Signature declaredSignature, Signature boundSignature) {
            this.declaredSignature = declaredSignature;
            this.boundSignature = boundSignature;
        }

        public Signature getDeclaredSignature() {
            return this.declaredSignature;
        }

        public Signature getBoundSignature() {
            return this.boundSignature;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("declaredSignature", (Object)this.declaredSignature).add("boundSignature", (Object)this.boundSignature).toString();
        }
    }

    private static class FunctionMap {
        private final Multimap<QualifiedName, SqlFunction> functions;

        public FunctionMap() {
            this.functions = ImmutableListMultimap.of();
        }

        public FunctionMap(FunctionMap map, Iterable<? extends SqlFunction> functions) {
            this.functions = ImmutableListMultimap.builder().putAll(map.functions).putAll((Multimap)Multimaps.index(functions, function -> QualifiedName.of((String)function.getSignature().getName()))).build();
            for (Map.Entry entry : this.functions.asMap().entrySet()) {
                Collection values = (Collection)entry.getValue();
                long aggregations = values.stream().map(function -> function.getSignature().getKind()).filter(kind -> kind == FunctionKind.AGGREGATE).count();
                Preconditions.checkState((aggregations == 0L || aggregations == (long)values.size() ? 1 : 0) != 0, (String)"'%s' is both an aggregation and a scalar function", entry.getKey());
            }
        }

        public List<SqlFunction> list() {
            return ImmutableList.copyOf((Collection)this.functions.values());
        }

        public Collection<SqlFunction> get(QualifiedName name) {
            return this.functions.get((Object)name);
        }
    }
}

