/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.prestosql.Session;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.CatalogSchemaName;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.security.PrincipalType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.analyzer.SemanticErrorCode;
import io.prestosql.sql.analyzer.SemanticException;
import io.prestosql.sql.tree.GrantorSpecification;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.PrincipalSpecification;
import io.prestosql.sql.tree.QualifiedName;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class MetadataUtil {
    private MetadataUtil() {
    }

    public static void checkTableName(String catalogName, Optional<String> schemaName, Optional<String> tableName) {
        MetadataUtil.checkCatalogName(catalogName);
        schemaName.ifPresent(name -> MetadataUtil.checkLowerCase(name, "schemaName"));
        tableName.ifPresent(name -> MetadataUtil.checkLowerCase(name, "tableName"));
        Preconditions.checkArgument((schemaName.isPresent() || !tableName.isPresent() ? 1 : 0) != 0, (Object)"tableName specified but schemaName is missing");
    }

    public static String checkCatalogName(String catalogName) {
        return MetadataUtil.checkLowerCase(catalogName, "catalogName");
    }

    public static String checkSchemaName(String schemaName) {
        return MetadataUtil.checkLowerCase(schemaName, "schemaName");
    }

    public static String checkTableName(String tableName) {
        return MetadataUtil.checkLowerCase(tableName, "tableName");
    }

    public static void checkObjectName(String catalogName, String schemaName, String objectName) {
        MetadataUtil.checkLowerCase(catalogName, "catalogName");
        MetadataUtil.checkLowerCase(schemaName, "schemaName");
        MetadataUtil.checkLowerCase(objectName, "objectName");
    }

    public static String checkLowerCase(String value, String name) {
        if (value == null) {
            throw new NullPointerException(String.format("%s is null", name));
        }
        Preconditions.checkArgument((boolean)value.equals(value.toLowerCase(Locale.ENGLISH)), (String)"%s is not lowercase: %s", (Object)name, (Object)value);
        return value;
    }

    public static ColumnMetadata findColumnMetadata(ConnectorTableMetadata tableMetadata, String columnName) {
        for (ColumnMetadata columnMetadata : tableMetadata.getColumns()) {
            if (!columnName.equals(columnMetadata.getName())) continue;
            return columnMetadata;
        }
        return null;
    }

    public static String createCatalogName(Session session, Node node) {
        Optional<String> sessionCatalog = session.getCatalog();
        if (!sessionCatalog.isPresent()) {
            throw new SemanticException(SemanticErrorCode.CATALOG_NOT_SPECIFIED, node, "Session catalog must be set", new Object[0]);
        }
        return sessionCatalog.get();
    }

    public static CatalogSchemaName createCatalogSchemaName(Session session, Node node, Optional<QualifiedName> schema) {
        String catalogName = session.getCatalog().orElse(null);
        String schemaName = session.getSchema().orElse(null);
        if (schema.isPresent()) {
            List parts = schema.get().getParts();
            if (parts.size() > 2) {
                throw new SemanticException(SemanticErrorCode.INVALID_SCHEMA_NAME, node, "Too many parts in schema name: %s", schema.get());
            }
            if (parts.size() == 2) {
                catalogName = (String)parts.get(0);
            }
            schemaName = schema.get().getSuffix();
        }
        if (catalogName == null) {
            throw new SemanticException(SemanticErrorCode.CATALOG_NOT_SPECIFIED, node, "Catalog must be specified when session catalog is not set", new Object[0]);
        }
        if (schemaName == null) {
            throw new SemanticException(SemanticErrorCode.SCHEMA_NOT_SPECIFIED, node, "Schema must be specified when session schema is not set", new Object[0]);
        }
        return new CatalogSchemaName(catalogName, schemaName);
    }

    public static QualifiedObjectName createQualifiedObjectName(Session session, Node node, QualifiedName name) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(name, "name is null");
        if (name.getParts().size() > 3) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SYNTAX_ERROR, String.format("Too many dots in table name: %s", name));
        }
        List parts = Lists.reverse((List)name.getParts());
        String objectName = (String)parts.get(0);
        String schemaName = parts.size() > 1 ? (String)parts.get(1) : session.getSchema().orElseThrow(() -> new SemanticException(SemanticErrorCode.SCHEMA_NOT_SPECIFIED, node, "Schema must be specified when session schema is not set", new Object[0]));
        String catalogName = parts.size() > 2 ? (String)parts.get(2) : session.getCatalog().orElseThrow(() -> new SemanticException(SemanticErrorCode.CATALOG_NOT_SPECIFIED, node, "Catalog must be specified when session catalog is not set", new Object[0]));
        return new QualifiedObjectName(catalogName, schemaName, objectName);
    }

    public static PrestoPrincipal createPrincipal(Session session, GrantorSpecification specification) {
        GrantorSpecification.Type type = specification.getType();
        switch (type) {
            case PRINCIPAL: {
                return MetadataUtil.createPrincipal((PrincipalSpecification)specification.getPrincipal().get());
            }
            case CURRENT_USER: {
                return new PrestoPrincipal(PrincipalType.USER, session.getIdentity().getUser());
            }
            case CURRENT_ROLE: {
                throw new UnsupportedOperationException("CURRENT_ROLE is not yet supported");
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    public static PrestoPrincipal createPrincipal(PrincipalSpecification specification) {
        PrincipalSpecification.Type type = specification.getType();
        switch (type) {
            case UNSPECIFIED: 
            case USER: {
                return new PrestoPrincipal(PrincipalType.USER, specification.getName().getValue());
            }
            case ROLE: {
                return new PrestoPrincipal(PrincipalType.ROLE, specification.getName().getValue());
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    public static boolean tableExists(Metadata metadata, Session session, String table) {
        if (!session.getCatalog().isPresent() || !session.getSchema().isPresent()) {
            return false;
        }
        QualifiedObjectName name = new QualifiedObjectName(session.getCatalog().get(), session.getSchema().get(), table);
        return metadata.getTableHandle(session, name).isPresent();
    }

    public static class TableMetadataBuilder {
        private final SchemaTableName tableName;
        private final ImmutableList.Builder<ColumnMetadata> columns = ImmutableList.builder();
        private final ImmutableMap.Builder<String, Object> properties = ImmutableMap.builder();
        private final Optional<String> comment;

        public static TableMetadataBuilder tableMetadataBuilder(String schemaName, String tableName) {
            return new TableMetadataBuilder(new SchemaTableName(schemaName, tableName));
        }

        public static TableMetadataBuilder tableMetadataBuilder(SchemaTableName tableName) {
            return new TableMetadataBuilder(tableName);
        }

        private TableMetadataBuilder(SchemaTableName tableName) {
            this(tableName, Optional.empty());
        }

        private TableMetadataBuilder(SchemaTableName tableName, Optional<String> comment) {
            this.tableName = tableName;
            this.comment = comment;
        }

        public TableMetadataBuilder column(String columnName, Type type) {
            this.columns.add((Object)new ColumnMetadata(columnName, type));
            return this;
        }

        public TableMetadataBuilder hiddenColumn(String columnName, Type type) {
            this.columns.add((Object)new ColumnMetadata(columnName, type, null, true));
            return this;
        }

        public TableMetadataBuilder property(String name, Object value) {
            this.properties.put((Object)name, value);
            return this;
        }

        public ConnectorTableMetadata build() {
            return new ConnectorTableMetadata(this.tableName, (List)this.columns.build(), (Map)this.properties.build(), this.comment);
        }
    }

    public static class SchemaMetadataBuilder {
        private final ImmutableMap.Builder<SchemaTableName, ConnectorTableMetadata> tables = ImmutableMap.builder();

        public static SchemaMetadataBuilder schemaMetadataBuilder() {
            return new SchemaMetadataBuilder();
        }

        public SchemaMetadataBuilder table(ConnectorTableMetadata tableMetadata) {
            this.tables.put((Object)tableMetadata.getTable(), (Object)tableMetadata);
            return this;
        }

        public ImmutableMap<SchemaTableName, ConnectorTableMetadata> build() {
            return this.tables.build();
        }
    }
}

