/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.primitives.Primitives;
import io.prestosql.connector.CatalogName;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.procedure.Procedure;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.VarcharType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ProcedureRegistry {
    private final Map<CatalogName, Map<SchemaTableName, Procedure>> connectorProcedures = new ConcurrentHashMap<CatalogName, Map<SchemaTableName, Procedure>>();
    private final TypeManager typeManager;

    public ProcedureRegistry(TypeManager typeManager) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public void addProcedures(CatalogName catalogName, Collection<Procedure> procedures) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(procedures, "procedures is null");
        procedures.forEach(this::validateProcedure);
        ImmutableMap proceduresByName = Maps.uniqueIndex(procedures, procedure -> new SchemaTableName(procedure.getSchema(), procedure.getName()));
        Preconditions.checkState((this.connectorProcedures.putIfAbsent(catalogName, (Map<SchemaTableName, Procedure>)proceduresByName) == null ? 1 : 0) != 0, (String)"Procedures already registered for connector: %s", (Object)catalogName);
    }

    public void removeProcedures(CatalogName catalogName) {
        this.connectorProcedures.remove(catalogName);
    }

    public Procedure resolve(CatalogName catalogName, SchemaTableName name) {
        Procedure procedure;
        Map<SchemaTableName, Procedure> procedures = this.connectorProcedures.get(catalogName);
        if (procedures != null && (procedure = procedures.get(name)) != null) {
            return procedure;
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.PROCEDURE_NOT_FOUND, "Procedure not registered: " + name);
    }

    private void validateProcedure(Procedure procedure) {
        List parameters = procedure.getMethodHandle().type().parameterList().stream().filter(type -> !ConnectorSession.class.isAssignableFrom((Class<?>)type)).collect(Collectors.toList());
        for (int i = 0; i < procedure.getArguments().size(); ++i) {
            Procedure.Argument argument = (Procedure.Argument)procedure.getArguments().get(i);
            Type type2 = this.typeManager.getType(argument.getType());
            Class argumentType = Primitives.unwrap((Class)((Class)parameters.get(i)));
            Class<?> expectedType = ProcedureRegistry.getObjectType(type2);
            Preconditions.checkArgument((boolean)expectedType.equals(argumentType), (String)"Argument '%s' has invalid type %s (expected %s)", (Object)argument.getName(), (Object)argumentType.getName(), (Object)expectedType.getName());
        }
    }

    private static Class<?> getObjectType(Type type) {
        if (type.equals(BooleanType.BOOLEAN)) {
            return Boolean.TYPE;
        }
        if (type.equals(BigintType.BIGINT)) {
            return Long.TYPE;
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return Double.TYPE;
        }
        if (type.equals(VarcharType.VARCHAR)) {
            return String.class;
        }
        if (type.getTypeSignature().getBase().equals("array")) {
            ProcedureRegistry.getObjectType((Type)type.getTypeParameters().get(0));
            return List.class;
        }
        if (type.getTypeSignature().getBase().equals("map")) {
            ProcedureRegistry.getObjectType((Type)type.getTypeParameters().get(0));
            ProcedureRegistry.getObjectType((Type)type.getTypeParameters().get(1));
            return Map.class;
        }
        throw new IllegalArgumentException("Unsupported argument type: " + type.getDisplayName());
    }
}

