/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.google.common.collect.ImmutableList;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.TypeSignature;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class SignatureBuilder {
    private String name;
    private FunctionKind kind;
    private List<TypeVariableConstraint> typeVariableConstraints = Collections.emptyList();
    private List<LongVariableConstraint> longVariableConstraints = Collections.emptyList();
    private TypeSignature returnType;
    private List<TypeSignature> argumentTypes = Collections.emptyList();
    private boolean variableArity;

    public SignatureBuilder name(String name) {
        this.name = Objects.requireNonNull(name, "name is null");
        return this;
    }

    public SignatureBuilder kind(FunctionKind kind) {
        this.kind = kind;
        return this;
    }

    public SignatureBuilder operatorType(OperatorType operatorType) {
        this.name = FunctionRegistry.mangleOperatorName(Objects.requireNonNull(operatorType, "operatorType is null"));
        this.kind = FunctionKind.SCALAR;
        return this;
    }

    public SignatureBuilder typeVariableConstraints(TypeVariableConstraint ... typeVariableConstraints) {
        return this.typeVariableConstraints(Arrays.asList((Object[])Objects.requireNonNull(typeVariableConstraints, "typeVariableConstraints is null")));
    }

    public SignatureBuilder typeVariableConstraints(List<TypeVariableConstraint> typeVariableConstraints) {
        this.typeVariableConstraints = ImmutableList.copyOf((Collection)Objects.requireNonNull(typeVariableConstraints, "typeVariableConstraints is null"));
        return this;
    }

    public SignatureBuilder returnType(TypeSignature returnType) {
        this.returnType = Objects.requireNonNull(returnType, "returnType is null");
        return this;
    }

    public SignatureBuilder longVariableConstraints(LongVariableConstraint ... longVariableConstraints) {
        return this.longVariableConstraints(Arrays.asList((Object[])Objects.requireNonNull(longVariableConstraints, "longVariableConstraints is null")));
    }

    public SignatureBuilder longVariableConstraints(List<LongVariableConstraint> longVariableConstraints) {
        this.longVariableConstraints = ImmutableList.copyOf((Collection)Objects.requireNonNull(longVariableConstraints, "longVariableConstraints is null"));
        return this;
    }

    public SignatureBuilder argumentTypes(TypeSignature ... argumentTypes) {
        return this.argumentTypes(Arrays.asList((Object[])Objects.requireNonNull(argumentTypes, "argumentTypes is Null")));
    }

    public SignatureBuilder argumentTypes(List<TypeSignature> argumentTypes) {
        this.argumentTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
        return this;
    }

    public SignatureBuilder setVariableArity(boolean variableArity) {
        this.variableArity = variableArity;
        return this;
    }

    public Signature build() {
        return new Signature(this.name, this.kind, this.typeVariableConstraints, this.longVariableConstraints, this.returnType, this.argumentTypes, this.variableArity);
    }
}

