/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlFunction;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.aggregation.AggregationFromAnnotationsParser;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeSignature;
import java.util.List;
import java.util.Objects;

public abstract class SqlAggregationFunction
implements SqlFunction {
    private final Signature signature;
    private final boolean hidden;

    public static List<SqlAggregationFunction> createFunctionByAnnotations(Class<?> aggregationDefinition) {
        return ImmutableList.of((Object)AggregationFromAnnotationsParser.parseFunctionDefinition(aggregationDefinition));
    }

    public static List<SqlAggregationFunction> createFunctionsByAnnotations(Class<?> aggregationDefinition) {
        return (List)AggregationFromAnnotationsParser.parseFunctionDefinitions(aggregationDefinition).stream().map(x -> x).collect(ImmutableList.toImmutableList());
    }

    protected SqlAggregationFunction(String name, List<TypeVariableConstraint> typeVariableConstraints, List<LongVariableConstraint> longVariableConstraints, TypeSignature returnType, List<TypeSignature> argumentTypes) {
        this(name, typeVariableConstraints, longVariableConstraints, returnType, argumentTypes, FunctionKind.AGGREGATE);
    }

    protected SqlAggregationFunction(String name, List<TypeVariableConstraint> typeVariableConstraints, List<LongVariableConstraint> longVariableConstraints, TypeSignature returnType, List<TypeSignature> argumentTypes, FunctionKind kind) {
        this(SqlAggregationFunction.createSignature(name, typeVariableConstraints, longVariableConstraints, returnType, argumentTypes, kind), false);
    }

    protected SqlAggregationFunction(Signature signature, boolean hidden) {
        this.signature = Objects.requireNonNull(signature, "signature is null");
        this.hidden = hidden;
    }

    private static Signature createSignature(String name, List<TypeVariableConstraint> typeVariableConstraints, List<LongVariableConstraint> longVariableConstraints, TypeSignature returnType, List<TypeSignature> argumentTypes, FunctionKind kind) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(typeVariableConstraints, "typeVariableConstraints is null");
        Objects.requireNonNull(longVariableConstraints, "longVariableConstraints is null");
        Objects.requireNonNull(returnType, "returnType is null");
        Objects.requireNonNull(argumentTypes, "argumentTypes is null");
        Preconditions.checkArgument((kind == FunctionKind.AGGREGATE ? 1 : 0) != 0, (Object)"kind must be an aggregate");
        return new Signature(name, kind, (List<TypeVariableConstraint>)ImmutableList.copyOf(typeVariableConstraints), (List<LongVariableConstraint>)ImmutableList.copyOf(longVariableConstraints), returnType, (List<TypeSignature>)ImmutableList.copyOf(argumentTypes), false);
    }

    @Override
    public final Signature getSignature() {
        return this.signature;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    public abstract InternalAggregationFunction specialize(BoundVariables var1, int var2, TypeManager var3, FunctionRegistry var4);
}

