/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.google.common.base.Preconditions;
import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.metadata.PolymorphicScalarFunctionBuilder;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlFunction;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.type.TypeManager;
import java.util.Objects;

public abstract class SqlScalarFunction
implements SqlFunction {
    private final Signature signature;

    protected SqlScalarFunction(Signature signature) {
        this.signature = Objects.requireNonNull(signature, "signature is null");
        Preconditions.checkArgument((signature.getKind() == FunctionKind.SCALAR ? 1 : 0) != 0, (Object)"function kind must be SCALAR");
    }

    @Override
    public final Signature getSignature() {
        return this.signature;
    }

    public abstract ScalarFunctionImplementation specialize(BoundVariables var1, int var2, TypeManager var3, FunctionRegistry var4);

    public static PolymorphicScalarFunctionBuilder builder(Class<?> clazz) {
        return new PolymorphicScalarFunctionBuilder(clazz);
    }
}

