/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import io.prestosql.connector.CatalogName;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.SchemaTableName;
import java.util.List;
import java.util.Objects;

public class TableMetadata {
    private final CatalogName catalogName;
    private final ConnectorTableMetadata metadata;

    public TableMetadata(CatalogName catalogName, ConnectorTableMetadata metadata) {
        Objects.requireNonNull(catalogName, "catalog is null");
        Objects.requireNonNull(metadata, "metadata is null");
        this.catalogName = catalogName;
        this.metadata = metadata;
    }

    public CatalogName getCatalogName() {
        return this.catalogName;
    }

    public ConnectorTableMetadata getMetadata() {
        return this.metadata;
    }

    public SchemaTableName getTable() {
        return this.metadata.getTable();
    }

    public List<ColumnMetadata> getColumns() {
        return this.metadata.getColumns();
    }

    public ColumnMetadata getColumn(String name) {
        return this.getColumns().stream().filter(columnMetadata -> columnMetadata.getName().equals(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid column name: " + name));
    }
}

