/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ViewDefinition {
    private final String originalSql;
    private final Optional<String> catalog;
    private final Optional<String> schema;
    private final List<ViewColumn> columns;
    private final Optional<String> owner;
    private final boolean runAsInvoker;

    @JsonCreator
    public ViewDefinition(@JsonProperty(value="originalSql") String originalSql, @JsonProperty(value="catalog") Optional<String> catalog, @JsonProperty(value="schema") Optional<String> schema, @JsonProperty(value="columns") List<ViewColumn> columns, @JsonProperty(value="owner") Optional<String> owner, @JsonProperty(value="runAsInvoker") boolean runAsInvoker) {
        this.originalSql = Objects.requireNonNull(originalSql, "originalSql is null");
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        this.owner = Objects.requireNonNull(owner, "owner is null");
        this.runAsInvoker = runAsInvoker;
        Preconditions.checkArgument((!runAsInvoker || !owner.isPresent() ? 1 : 0) != 0, (Object)"owner cannot be present with runAsInvoker");
    }

    @JsonProperty
    public String getOriginalSql() {
        return this.originalSql;
    }

    @JsonProperty
    public Optional<String> getCatalog() {
        return this.catalog;
    }

    @JsonProperty
    public Optional<String> getSchema() {
        return this.schema;
    }

    @JsonProperty
    public List<ViewColumn> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public Optional<String> getOwner() {
        return this.owner;
    }

    @JsonProperty
    public boolean isRunAsInvoker() {
        return this.runAsInvoker;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("originalSql", (Object)this.originalSql).add("catalog", this.catalog.orElse(null)).add("schema", this.schema.orElse(null)).add("columns", this.columns).add("owner", this.owner.orElse(null)).add("runAsInvoker", this.runAsInvoker).omitNullValues().toString();
    }

    public ViewDefinition withOwner(String owner) {
        return new ViewDefinition(this.originalSql, this.catalog, this.schema, this.columns, Optional.of(owner), this.runAsInvoker);
    }

    public static final class ViewColumn {
        private final String name;
        private final Type type;

        @JsonCreator
        public ViewColumn(@JsonProperty(value="name") String name, @JsonProperty(value="type") Type type) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.type = Objects.requireNonNull(type, "type is null");
        }

        @JsonProperty
        public String getName() {
            return this.name;
        }

        @JsonProperty
        public Type getType() {
            return this.type;
        }

        public String toString() {
            return this.name + ":" + this.type;
        }
    }
}

