/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.execution.QueryInfo;
import io.prestosql.execution.QueryPerformanceFetcher;
import io.prestosql.execution.StageId;
import io.prestosql.execution.StageInfo;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.metadata.Metadata;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.Operator;
import io.prestosql.operator.OperatorContext;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.planner.planprinter.PlanPrinter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class ExplainAnalyzeOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final QueryPerformanceFetcher queryPerformanceFetcher;
    private final FunctionRegistry functionRegistry;
    private final Metadata metadata;
    private final boolean verbose;
    private boolean finishing;
    private boolean outputConsumed;

    public ExplainAnalyzeOperator(OperatorContext operatorContext, QueryPerformanceFetcher queryPerformanceFetcher, FunctionRegistry functionRegistry, Metadata metadata, boolean verbose) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.queryPerformanceFetcher = Objects.requireNonNull(queryPerformanceFetcher, "queryPerformanceFetcher is null");
        this.functionRegistry = Objects.requireNonNull(functionRegistry, "functionRegistry is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.verbose = verbose;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.outputConsumed;
    }

    @Override
    public boolean needsInput() {
        return !this.finishing;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((boolean)this.needsInput());
    }

    @Override
    public Page getOutput() {
        if (!this.finishing) {
            return null;
        }
        QueryInfo queryInfo = this.queryPerformanceFetcher.getQueryInfo(this.operatorContext.getDriverContext().getTaskId().getQueryId());
        Preconditions.checkState((boolean)queryInfo.getOutputStage().isPresent(), (Object)"Output stage is missing");
        Preconditions.checkState((queryInfo.getOutputStage().get().getSubStages().size() == 1 ? 1 : 0) != 0, (Object)"Expected one sub stage of explain node");
        if (!this.hasFinalStageInfo(queryInfo.getOutputStage().get())) {
            return null;
        }
        String plan = PlanPrinter.textDistributedPlan(queryInfo.getOutputStage().get().getSubStages().get(0), this.functionRegistry, Optional.of(this.metadata), this.operatorContext.getSession(), this.verbose);
        BlockBuilder builder = VarcharType.VARCHAR.createBlockBuilder(null, 1);
        VarcharType.VARCHAR.writeString(builder, plan);
        this.outputConsumed = true;
        return new Page(new Block[]{builder.build()});
    }

    private boolean hasFinalStageInfo(StageInfo stageInfo) {
        boolean isFinalStageInfo = this.isFinalStageInfo(stageInfo);
        if (!isFinalStageInfo) {
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return this.isFinalStageInfo(stageInfo);
    }

    private boolean isFinalStageInfo(StageInfo stageInfo) {
        List<StageInfo> subStages = ExplainAnalyzeOperator.getSubStagesOf(this.operatorContext.getDriverContext().getTaskId().getStageId(), stageInfo);
        return subStages.stream().allMatch(StageInfo::isFinalStageInfo);
    }

    private static List<StageInfo> getSubStagesOf(StageId stageId, StageInfo rootStage) {
        ImmutableList.Builder collector = ImmutableList.builder();
        ExplainAnalyzeOperator.getSubStages(stageId, rootStage, (ImmutableList.Builder<StageInfo>)collector, false);
        return collector.build();
    }

    private static void getSubStages(StageId stageId, StageInfo rootStage, ImmutableList.Builder<StageInfo> collector, boolean add) {
        if (rootStage.getStageId().equals(stageId)) {
            add = true;
        }
        List<StageInfo> subStages = rootStage.getSubStages();
        for (StageInfo subStage : subStages) {
            ExplainAnalyzeOperator.getSubStages(stageId, subStage, collector, add);
        }
        if (add && !rootStage.getStageId().equals(stageId)) {
            collector.add((Object)rootStage);
        }
    }

    public static class ExplainAnalyzeOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final QueryPerformanceFetcher queryPerformanceFetcher;
        private final FunctionRegistry functionRegistry;
        private final Metadata metadata;
        private final boolean verbose;
        private boolean closed;

        public ExplainAnalyzeOperatorFactory(int operatorId, PlanNodeId planNodeId, QueryPerformanceFetcher queryPerformanceFetcher, FunctionRegistry functionRegistry, Metadata metadata, boolean verbose) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.queryPerformanceFetcher = Objects.requireNonNull(queryPerformanceFetcher, "queryPerformanceFetcher is null");
            this.functionRegistry = Objects.requireNonNull(functionRegistry, "functionRegistry is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.verbose = verbose;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, ExplainAnalyzeOperator.class.getSimpleName());
            return new ExplainAnalyzeOperator(operatorContext, this.queryPerformanceFetcher, this.functionRegistry, this.metadata, this.verbose);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new ExplainAnalyzeOperatorFactory(this.operatorId, this.planNodeId, this.queryPerformanceFetcher, this.functionRegistry, this.metadata, this.verbose);
        }
    }
}

