/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.base.MoreObjects;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import io.prestosql.Session;
import io.prestosql.geospatial.Rectangle;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.operator.JoinHashSupplier;
import io.prestosql.operator.LookupSource;
import io.prestosql.operator.LookupSourceSupplier;
import io.prestosql.operator.PagesHashStrategy;
import io.prestosql.operator.PagesIndexOrdering;
import io.prestosql.operator.PagesSpatialIndexSupplier;
import io.prestosql.operator.SimplePagesHashStrategy;
import io.prestosql.operator.SpatialIndexBuilderOperator;
import io.prestosql.operator.SyntheticAddress;
import io.prestosql.spi.Page;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.SortOrder;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.sql.gen.JoinCompiler;
import io.prestosql.sql.gen.JoinFilterFunctionCompiler;
import io.prestosql.sql.gen.OrderingCompiler;
import it.unimi.dsi.fastutil.Swapper;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.IntUnaryOperator;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.openjdk.jol.info.ClassLayout;

public class PagesIndex
implements Swapper {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(PagesIndex.class).instanceSize();
    private static final Logger log = Logger.get(PagesIndex.class);
    private final OrderingCompiler orderingCompiler;
    private final JoinCompiler joinCompiler;
    private final FunctionRegistry functionRegistry;
    private final List<Type> types;
    private final LongArrayList valueAddresses;
    private final ObjectArrayList<Block>[] channels;
    private final boolean eagerCompact;
    private int nextBlockToCompact;
    private int positionCount;
    private long pagesMemorySize;
    private long estimatedSize;

    private PagesIndex(OrderingCompiler orderingCompiler, JoinCompiler joinCompiler, FunctionRegistry functionRegistry, List<Type> types, int expectedPositions, boolean eagerCompact) {
        this.orderingCompiler = Objects.requireNonNull(orderingCompiler, "orderingCompiler is null");
        this.joinCompiler = Objects.requireNonNull(joinCompiler, "joinCompiler is null");
        this.functionRegistry = Objects.requireNonNull(functionRegistry, "functionRegistry is null");
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.valueAddresses = new LongArrayList(expectedPositions);
        this.eagerCompact = eagerCompact;
        this.channels = new ObjectArrayList[types.size()];
        for (int i = 0; i < this.channels.length; ++i) {
            this.channels[i] = ObjectArrayList.wrap((Object[])new Block[1024], (int)0);
        }
        this.estimatedSize = this.calculateEstimatedSize();
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public LongArrayList getValueAddresses() {
        return this.valueAddresses;
    }

    public ObjectArrayList<Block> getChannel(int channel) {
        return this.channels[channel];
    }

    public void clear() {
        for (ObjectArrayList<Block> channel : this.channels) {
            channel.clear();
            channel.trim();
        }
        this.valueAddresses.clear();
        this.valueAddresses.trim();
        this.positionCount = 0;
        this.nextBlockToCompact = 0;
        this.pagesMemorySize = 0L;
        this.estimatedSize = this.calculateEstimatedSize();
    }

    public void addPage(Page page) {
        if (page.getPositionCount() == 0) {
            return;
        }
        this.positionCount += page.getPositionCount();
        int pageIndex = this.channels.length > 0 ? this.channels[0].size() : 0;
        for (int i = 0; i < this.channels.length; ++i) {
            Block block = page.getBlock(i);
            if (this.eagerCompact) {
                block = block.copyRegion(0, block.getPositionCount());
            }
            this.channels[i].add((Object)block);
            this.pagesMemorySize += block.getRetainedSizeInBytes();
        }
        for (int position = 0; position < page.getPositionCount(); ++position) {
            long sliceAddress = SyntheticAddress.encodeSyntheticAddress(pageIndex, position);
            this.valueAddresses.add(sliceAddress);
        }
        this.estimatedSize = this.calculateEstimatedSize();
    }

    public DataSize getEstimatedSize() {
        return new DataSize((double)this.estimatedSize, DataSize.Unit.BYTE);
    }

    public void compact() {
        if (this.eagerCompact) {
            return;
        }
        for (int channel = 0; channel < this.types.size(); ++channel) {
            ObjectArrayList<Block> blocks = this.channels[channel];
            for (int i = this.nextBlockToCompact; i < blocks.size(); ++i) {
                Block block = (Block)blocks.get(i);
                Block compactedBlock = block.copyRegion(0, block.getPositionCount());
                blocks.set(i, (Object)compactedBlock);
                this.pagesMemorySize -= block.getRetainedSizeInBytes();
                this.pagesMemorySize += compactedBlock.getRetainedSizeInBytes();
            }
        }
        this.nextBlockToCompact = this.channels[0].size();
        this.estimatedSize = this.calculateEstimatedSize();
    }

    private long calculateEstimatedSize() {
        long elementsSize = this.channels.length > 0 ? SizeOf.sizeOf((Object[])this.channels[0].elements()) : 0L;
        long channelsArraySize = elementsSize * (long)this.channels.length;
        long addressesArraySize = SizeOf.sizeOf((long[])this.valueAddresses.elements());
        return (long)INSTANCE_SIZE + this.pagesMemorySize + channelsArraySize + addressesArraySize;
    }

    public Type getType(int channel) {
        return this.types.get(channel);
    }

    public void swap(int a, int b) {
        long[] elements = this.valueAddresses.elements();
        long temp = elements[a];
        elements[a] = elements[b];
        elements[b] = temp;
    }

    public int buildPage(int position, int[] outputChannels, PageBuilder pageBuilder) {
        while (!pageBuilder.isFull() && position < this.positionCount) {
            long pageAddress = this.valueAddresses.getLong(position);
            int blockIndex = SyntheticAddress.decodeSliceIndex(pageAddress);
            int blockPosition = SyntheticAddress.decodePosition(pageAddress);
            pageBuilder.declarePosition();
            for (int i = 0; i < outputChannels.length; ++i) {
                int outputChannel = outputChannels[i];
                Type type = this.types.get(outputChannel);
                Block block = (Block)this.channels[outputChannel].get(blockIndex);
                type.appendTo(block, blockPosition, pageBuilder.getBlockBuilder(i));
            }
            ++position;
        }
        return position;
    }

    public void appendTo(int channel, int position, BlockBuilder output) {
        long pageAddress = this.valueAddresses.getLong(position);
        Type type = this.types.get(channel);
        Block block = (Block)this.channels[channel].get(SyntheticAddress.decodeSliceIndex(pageAddress));
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        type.appendTo(block, blockPosition, output);
    }

    public boolean isNull(int channel, int position) {
        long pageAddress = this.valueAddresses.getLong(position);
        Block block = (Block)this.channels[channel].get(SyntheticAddress.decodeSliceIndex(pageAddress));
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        return block.isNull(blockPosition);
    }

    public boolean getBoolean(int channel, int position) {
        long pageAddress = this.valueAddresses.getLong(position);
        Block block = (Block)this.channels[channel].get(SyntheticAddress.decodeSliceIndex(pageAddress));
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        return this.types.get(channel).getBoolean(block, blockPosition);
    }

    public long getLong(int channel, int position) {
        long pageAddress = this.valueAddresses.getLong(position);
        Block block = (Block)this.channels[channel].get(SyntheticAddress.decodeSliceIndex(pageAddress));
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        return this.types.get(channel).getLong(block, blockPosition);
    }

    public double getDouble(int channel, int position) {
        long pageAddress = this.valueAddresses.getLong(position);
        Block block = (Block)this.channels[channel].get(SyntheticAddress.decodeSliceIndex(pageAddress));
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        return this.types.get(channel).getDouble(block, blockPosition);
    }

    public Slice getSlice(int channel, int position) {
        long pageAddress = this.valueAddresses.getLong(position);
        Block block = (Block)this.channels[channel].get(SyntheticAddress.decodeSliceIndex(pageAddress));
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        return this.types.get(channel).getSlice(block, blockPosition);
    }

    public Object getObject(int channel, int position) {
        long pageAddress = this.valueAddresses.getLong(position);
        Block block = (Block)this.channels[channel].get(SyntheticAddress.decodeSliceIndex(pageAddress));
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        return this.types.get(channel).getObject(block, blockPosition);
    }

    public Block getSingleValueBlock(int channel, int position) {
        long pageAddress = this.valueAddresses.getLong(position);
        Block block = (Block)this.channels[channel].get(SyntheticAddress.decodeSliceIndex(pageAddress));
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        return block.getSingleValueBlock(blockPosition);
    }

    public void sort(List<Integer> sortChannels, List<SortOrder> sortOrders) {
        this.sort(sortChannels, sortOrders, 0, this.getPositionCount());
    }

    public void sort(List<Integer> sortChannels, List<SortOrder> sortOrders, int startPosition, int endPosition) {
        this.createPagesIndexComparator(sortChannels, sortOrders).sort(this, startPosition, endPosition);
    }

    public boolean positionEqualsPosition(PagesHashStrategy partitionHashStrategy, int leftPosition, int rightPosition) {
        long leftAddress = this.valueAddresses.getLong(leftPosition);
        int leftPageIndex = SyntheticAddress.decodeSliceIndex(leftAddress);
        int leftPagePosition = SyntheticAddress.decodePosition(leftAddress);
        long rightAddress = this.valueAddresses.getLong(rightPosition);
        int rightPageIndex = SyntheticAddress.decodeSliceIndex(rightAddress);
        int rightPagePosition = SyntheticAddress.decodePosition(rightAddress);
        return partitionHashStrategy.positionEqualsPosition(leftPageIndex, leftPagePosition, rightPageIndex, rightPagePosition);
    }

    public boolean positionEqualsRow(PagesHashStrategy pagesHashStrategy, int indexPosition, int rightPosition, Page rightPage) {
        long pageAddress = this.valueAddresses.getLong(indexPosition);
        int pageIndex = SyntheticAddress.decodeSliceIndex(pageAddress);
        int pagePosition = SyntheticAddress.decodePosition(pageAddress);
        return pagesHashStrategy.positionEqualsRow(pageIndex, pagePosition, rightPosition, rightPage);
    }

    private PagesIndexOrdering createPagesIndexComparator(List<Integer> sortChannels, List<SortOrder> sortOrders) {
        List sortTypes = (List)sortChannels.stream().map(this.types::get).collect(ImmutableList.toImmutableList());
        return this.orderingCompiler.compilePagesIndexOrdering(sortTypes, sortChannels, sortOrders);
    }

    public Supplier<LookupSource> createLookupSourceSupplier(Session session, List<Integer> joinChannels) {
        return this.createLookupSourceSupplier(session, joinChannels, OptionalInt.empty(), Optional.empty(), Optional.empty(), (List<JoinFilterFunctionCompiler.JoinFilterFunctionFactory>)ImmutableList.of());
    }

    public PagesHashStrategy createPagesHashStrategy(List<Integer> joinChannels, OptionalInt hashChannel) {
        return this.createPagesHashStrategy(joinChannels, hashChannel, Optional.empty());
    }

    public PagesHashStrategy createPagesHashStrategy(List<Integer> joinChannels, OptionalInt hashChannel, Optional<List<Integer>> outputChannels) {
        try {
            return this.joinCompiler.compilePagesHashStrategyFactory(this.types, joinChannels, outputChannels).createPagesHashStrategy((List<? extends List<Block>>)ImmutableList.copyOf((Object[])this.channels), hashChannel);
        }
        catch (Exception e) {
            log.error((Throwable)e, "Lookup source compile failed for types=%s error=%s", new Object[]{this.types, e});
            return new SimplePagesHashStrategy(this.types, outputChannels.orElse(this.rangeList(this.types.size())), (List<List<Block>>)ImmutableList.copyOf((Object[])this.channels), joinChannels, hashChannel, Optional.empty(), this.functionRegistry);
        }
    }

    public LookupSourceSupplier createLookupSourceSupplier(Session session, List<Integer> joinChannels, OptionalInt hashChannel, Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory, Optional<Integer> sortChannel, List<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> searchFunctionFactories) {
        return this.createLookupSourceSupplier(session, joinChannels, hashChannel, filterFunctionFactory, sortChannel, searchFunctionFactories, Optional.empty());
    }

    public PagesSpatialIndexSupplier createPagesSpatialIndex(Session session, int geometryChannel, Optional<Integer> radiusChannel, Optional<Integer> partitionChannel, SpatialIndexBuilderOperator.SpatialPredicate spatialRelationshipTest, Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory, List<Integer> outputChannels, Map<Integer, Rectangle> partitions) {
        ImmutableList channels = ImmutableList.copyOf((Object[])this.channels);
        return new PagesSpatialIndexSupplier(session, this.valueAddresses, this.types, outputChannels, (List<List<Block>>)channels, geometryChannel, radiusChannel, partitionChannel, spatialRelationshipTest, filterFunctionFactory, partitions);
    }

    public LookupSourceSupplier createLookupSourceSupplier(Session session, List<Integer> joinChannels, OptionalInt hashChannel, Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory, Optional<Integer> sortChannel, List<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> searchFunctionFactories, Optional<List<Integer>> outputChannels) {
        ImmutableList channels = ImmutableList.copyOf((Object[])this.channels);
        if (!joinChannels.isEmpty()) {
            try {
                JoinCompiler.LookupSourceSupplierFactory lookupSourceFactory = this.joinCompiler.compileLookupSourceFactory(this.types, joinChannels, sortChannel, outputChannels);
                return lookupSourceFactory.createLookupSourceSupplier(session, this.valueAddresses, (List<List<Block>>)channels, hashChannel, filterFunctionFactory, sortChannel, searchFunctionFactories);
            }
            catch (Exception e) {
                log.error((Throwable)e, "Lookup source compile failed for types=%s error=%s", new Object[]{this.types, e});
            }
        }
        SimplePagesHashStrategy hashStrategy = new SimplePagesHashStrategy(this.types, outputChannels.orElse(this.rangeList(this.types.size())), (List<List<Block>>)channels, joinChannels, hashChannel, sortChannel, this.functionRegistry);
        return new JoinHashSupplier(session, hashStrategy, this.valueAddresses, (List<List<Block>>)channels, filterFunctionFactory, sortChannel, searchFunctionFactories);
    }

    private List<Integer> rangeList(int endExclusive) {
        return (List)IntStream.range(0, endExclusive).boxed().collect(ImmutableList.toImmutableList());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("positionCount", this.positionCount).add("types", this.types).add("estimatedSize", this.estimatedSize).toString();
    }

    public Iterator<Page> getPages() {
        return new AbstractIterator<Page>(){
            private int pageCounter;

            protected Page computeNext() {
                if (this.pageCounter == PagesIndex.this.channels[0].size()) {
                    return (Page)this.endOfData();
                }
                Block[] blocks = (Block[])Stream.of(PagesIndex.this.channels).map(channel -> (Block)channel.get(this.pageCounter)).toArray(Block[]::new);
                ++this.pageCounter;
                return new Page(blocks);
            }
        };
    }

    public Iterator<Page> getSortedPages() {
        return new AbstractIterator<Page>(){
            private int currentPosition;
            private final PageBuilder pageBuilder;
            private final int[] outputChannels;
            {
                this.pageBuilder = new PageBuilder(PagesIndex.this.types);
                this.outputChannels = new int[PagesIndex.this.types.size()];
                Arrays.setAll(this.outputChannels, IntUnaryOperator.identity());
            }

            public Page computeNext() {
                this.currentPosition = PagesIndex.this.buildPage(this.currentPosition, this.outputChannels, this.pageBuilder);
                if (this.pageBuilder.isEmpty()) {
                    return (Page)this.endOfData();
                }
                Page page = this.pageBuilder.build();
                this.pageBuilder.reset();
                return page;
            }
        };
    }

    public static class DefaultFactory
    implements Factory {
        private final OrderingCompiler orderingCompiler;
        private final JoinCompiler joinCompiler;
        private final boolean eagerCompact;
        private final FunctionRegistry functionRegistry;

        @Inject
        public DefaultFactory(OrderingCompiler orderingCompiler, JoinCompiler joinCompiler, FeaturesConfig featuresConfig, Metadata metadata) {
            this.orderingCompiler = Objects.requireNonNull(orderingCompiler, "orderingCompiler is null");
            this.joinCompiler = Objects.requireNonNull(joinCompiler, "joinCompiler is null");
            this.eagerCompact = Objects.requireNonNull(featuresConfig, "featuresConfig is null").isPagesIndexEagerCompactionEnabled();
            this.functionRegistry = Objects.requireNonNull(metadata, "metadata is null").getFunctionRegistry();
        }

        @Override
        public PagesIndex newPagesIndex(List<Type> types, int expectedPositions) {
            return new PagesIndex(this.orderingCompiler, this.joinCompiler, this.functionRegistry, types, expectedPositions, this.eagerCompact);
        }
    }

    public static class TestingFactory
    implements Factory {
        private static final OrderingCompiler ORDERING_COMPILER = new OrderingCompiler();
        private static final JoinCompiler JOIN_COMPILER = new JoinCompiler(MetadataManager.createTestMetadataManager());
        private final boolean eagerCompact;

        public TestingFactory(boolean eagerCompact) {
            this.eagerCompact = eagerCompact;
        }

        @Override
        public PagesIndex newPagesIndex(List<Type> types, int expectedPositions) {
            return new PagesIndex(ORDERING_COMPILER, JOIN_COMPILER, MetadataManager.createTestMetadataManager().getFunctionRegistry(), types, expectedPositions, this.eagerCompact);
        }
    }

    public static interface Factory {
        public PagesIndex newPagesIndex(List<Type> var1, int var2);
    }
}

