/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.prestosql.metadata.Signature;
import io.prestosql.operator.ParametricImplementation;
import io.prestosql.operator.annotations.FunctionsParserHelper;
import io.prestosql.spi.type.TypeSignature;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ParametricImplementationsGroup<T extends ParametricImplementation> {
    private final Map<Signature, T> exactImplementations;
    private final List<T> specializedImplementations;
    private final List<T> genericImplementations;
    private final Signature signature;

    public ParametricImplementationsGroup(Map<Signature, T> exactImplementations, List<T> specializedImplementations, List<T> genericImplementations, Signature signature) {
        this.exactImplementations = ImmutableMap.copyOf(Objects.requireNonNull(exactImplementations, "exactImplementation cannot be null"));
        this.specializedImplementations = ImmutableList.copyOf((Collection)Objects.requireNonNull(specializedImplementations, "specializedImplementations cannot be null"));
        this.genericImplementations = ImmutableList.copyOf((Collection)Objects.requireNonNull(genericImplementations, "genericImplementations cannot be null"));
        this.signature = Objects.requireNonNull(signature, "signature cannot be null");
    }

    public static <T extends ParametricImplementation> ParametricImplementationsGroup<T> of(T ... implementations) {
        Builder<T> builder = ParametricImplementationsGroup.builder();
        for (T implementation : implementations) {
            builder.addImplementation(implementation);
        }
        return builder.build();
    }

    public List<T> getGenericImplementations() {
        return this.genericImplementations;
    }

    public Map<Signature, T> getExactImplementations() {
        return this.exactImplementations;
    }

    public List<T> getSpecializedImplementations() {
        return this.specializedImplementations;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public static <T extends ParametricImplementation> Builder<T> builder() {
        return new Builder();
    }

    public static final class Builder<T extends ParametricImplementation> {
        private final ImmutableMap.Builder<Signature, T> exactImplementations = ImmutableMap.builder();
        private final ImmutableList.Builder<T> specializedImplementations = ImmutableList.builder();
        private final ImmutableList.Builder<T> genericImplementations = ImmutableList.builder();

        private Builder() {
        }

        public ParametricImplementationsGroup<T> build() {
            ImmutableMap exactImplementations = this.exactImplementations.build();
            ImmutableList specializedImplementations = this.specializedImplementations.build();
            ImmutableList genericImplementations = this.genericImplementations.build();
            return new ParametricImplementationsGroup(exactImplementations, specializedImplementations, genericImplementations, Builder.determineGenericSignature(exactImplementations, specializedImplementations, genericImplementations));
        }

        public void addImplementation(T implementation) {
            if (implementation.getSignature().getTypeVariableConstraints().isEmpty() && implementation.getSignature().getArgumentTypes().stream().noneMatch(TypeSignature::isCalculated) && !implementation.getSignature().getReturnType().isCalculated()) {
                this.exactImplementations.put((Object)implementation.getSignature(), implementation);
            } else if (implementation.hasSpecializedTypeParameters()) {
                this.specializedImplementations.add(implementation);
            } else {
                this.genericImplementations.add(implementation);
            }
        }

        private static <T extends ParametricImplementation> Signature determineGenericSignature(Map<Signature, T> exactImplementations, List<T> specializedImplementations, List<T> genericImplementations) {
            if (specializedImplementations.size() + genericImplementations.size() == 0) {
                return (Signature)Iterables.getOnlyElement(exactImplementations.keySet());
            }
            Optional<Signature> signature = Optional.empty();
            for (ParametricImplementation implementation : specializedImplementations) {
                FunctionsParserHelper.validateSignaturesCompatibility(signature, implementation.getSignature());
                signature = Optional.of(implementation.getSignature());
            }
            for (ParametricImplementation implementation : genericImplementations) {
                FunctionsParserHelper.validateSignaturesCompatibility(signature, implementation.getSignature());
                signature = Optional.of(implementation.getSignature());
            }
            return signature.get();
        }
    }
}

