/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.units.DataSize;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.metadata.Split;
import io.prestosql.metadata.TableHandle;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.DriverYieldSignal;
import io.prestosql.operator.OperatorContext;
import io.prestosql.operator.SourceOperator;
import io.prestosql.operator.SourceOperatorFactory;
import io.prestosql.operator.SplitOperatorInfo;
import io.prestosql.operator.WorkProcessor;
import io.prestosql.operator.project.CursorProcessor;
import io.prestosql.operator.project.CursorProcessorOutput;
import io.prestosql.operator.project.MergePages;
import io.prestosql.operator.project.PageProcessor;
import io.prestosql.spi.Page;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.LazyBlock;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.RecordCursor;
import io.prestosql.spi.connector.RecordPageSource;
import io.prestosql.spi.connector.UpdatablePageSource;
import io.prestosql.spi.type.Type;
import io.prestosql.split.EmptySplit;
import io.prestosql.split.EmptySplitPageSource;
import io.prestosql.split.PageSourceProvider;
import io.prestosql.sql.planner.plan.PlanNodeId;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class ScanFilterAndProjectOperator
implements SourceOperator,
Closeable {
    private final OperatorContext operatorContext;
    private final PlanNodeId planNodeId;
    private final SettableFuture<?> blockedOnSplits = SettableFuture.create();
    private WorkProcessor<Page> pages;
    private RecordCursor cursor;
    private ConnectorPageSource pageSource;
    private Split split;
    private boolean operatorFinishing;
    private long deltaPositionsCount;
    private long deltaPhysicalBytes;
    private long deltaPhysicalReadTimeNanos;
    private long deltaProcessedBytes;

    private ScanFilterAndProjectOperator(OperatorContext operatorContext, PlanNodeId sourceId, PageSourceProvider pageSourceProvider, CursorProcessor cursorProcessor, PageProcessor pageProcessor, TableHandle table, Iterable<ColumnHandle> columns, Iterable<Type> types, DataSize minOutputPageSize, int minOutputPageRowCount) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.planNodeId = Objects.requireNonNull(sourceId, "sourceId is null");
        this.pages = WorkProcessor.create(new SplitToPages(pageSourceProvider, cursorProcessor, pageProcessor, table, columns, types, operatorContext.aggregateSystemMemoryContext(), minOutputPageSize, minOutputPageRowCount)).transformProcessor(WorkProcessor::flatten);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.planNodeId;
    }

    @Override
    public Supplier<Optional<UpdatablePageSource>> addSplit(Split split) {
        Objects.requireNonNull(split, "split is null");
        Preconditions.checkState((this.split == null ? 1 : 0) != 0, (Object)"Table scan split already set");
        if (this.operatorFinishing) {
            return Optional::empty;
        }
        this.split = split;
        Object splitInfo = split.getInfo();
        if (splitInfo != null) {
            this.operatorContext.setInfoSupplier(() -> new SplitOperatorInfo(splitInfo));
        }
        this.blockedOnSplits.set(null);
        return () -> {
            if (this.pageSource instanceof UpdatablePageSource) {
                return Optional.of((UpdatablePageSource)this.pageSource);
            }
            return Optional.empty();
        };
    }

    @Override
    public void noMoreSplits() {
        this.blockedOnSplits.set(null);
    }

    @Override
    public void close() {
        if (this.pageSource != null) {
            try {
                this.pageSource.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        } else if (this.cursor != null) {
            this.cursor.close();
        }
    }

    @Override
    public void finish() {
        this.blockedOnSplits.set(null);
        this.operatorFinishing = true;
    }

    @Override
    public final boolean isFinished() {
        return this.pages.isFinished();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        if (this.pages.isBlocked()) {
            return this.pages.getBlockedFuture();
        }
        return NOT_BLOCKED;
    }

    @Override
    public final boolean needsInput() {
        return false;
    }

    @Override
    public final void addInput(Page page) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Page getOutput() {
        if (!this.pages.process()) {
            return null;
        }
        if (this.pages.isFinished()) {
            return null;
        }
        return this.pages.getResult();
    }

    private Page recordProcessedInput(Page page) {
        Block[] blocks = new Block[page.getChannelCount()];
        for (int i = 0; i < page.getChannelCount(); ++i) {
            Block block = page.getBlock(i);
            if (block instanceof LazyBlock) {
                LazyBlock delegateLazyBlock = (LazyBlock)block;
                blocks[i] = new LazyBlock(page.getPositionCount(), lazyBlock -> {
                    Block loadedBlock = delegateLazyBlock.getLoadedBlock();
                    this.deltaProcessedBytes += loadedBlock.getSizeInBytes();
                    lazyBlock.setBlock(loadedBlock);
                });
                continue;
            }
            this.deltaProcessedBytes += block.getSizeInBytes();
            blocks[i] = block;
        }
        return new Page(page.getPositionCount(), blocks);
    }

    public static class ScanFilterAndProjectOperatorFactory
    implements SourceOperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final Supplier<CursorProcessor> cursorProcessor;
        private final Supplier<PageProcessor> pageProcessor;
        private final PlanNodeId sourceId;
        private final PageSourceProvider pageSourceProvider;
        private final TableHandle table;
        private final List<ColumnHandle> columns;
        private final List<Type> types;
        private final DataSize minOutputPageSize;
        private final int minOutputPageRowCount;
        private boolean closed;

        public ScanFilterAndProjectOperatorFactory(int operatorId, PlanNodeId planNodeId, PlanNodeId sourceId, PageSourceProvider pageSourceProvider, Supplier<CursorProcessor> cursorProcessor, Supplier<PageProcessor> pageProcessor, TableHandle table, Iterable<ColumnHandle> columns, List<Type> types, DataSize minOutputPageSize, int minOutputPageRowCount) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.cursorProcessor = Objects.requireNonNull(cursorProcessor, "cursorProcessor is null");
            this.pageProcessor = Objects.requireNonNull(pageProcessor, "pageProcessor is null");
            this.sourceId = Objects.requireNonNull(sourceId, "sourceId is null");
            this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
            this.table = Objects.requireNonNull(table, "table is null");
            this.columns = ImmutableList.copyOf(Objects.requireNonNull(columns, "columns is null"));
            this.types = Objects.requireNonNull(types, "types is null");
            this.minOutputPageSize = Objects.requireNonNull(minOutputPageSize, "minOutputPageSize is null");
            this.minOutputPageRowCount = minOutputPageRowCount;
        }

        @Override
        public PlanNodeId getSourceId() {
            return this.sourceId;
        }

        @Override
        public SourceOperator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, ScanFilterAndProjectOperator.class.getSimpleName());
            return new ScanFilterAndProjectOperator(operatorContext, this.sourceId, this.pageSourceProvider, this.cursorProcessor.get(), this.pageProcessor.get(), this.table, this.columns, this.types, this.minOutputPageSize, this.minOutputPageRowCount);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }
    }

    private class ConnectorPageSourceToPages
    implements WorkProcessor.Process<Page> {
        final LocalMemoryContext pageSourceMemoryContext;
        long completedBytes;
        long readTimeNanos;

        ConnectorPageSourceToPages(LocalMemoryContext pageSourceMemoryContext) {
            this.pageSourceMemoryContext = pageSourceMemoryContext;
        }

        @Override
        public WorkProcessor.ProcessState<Page> process() {
            if (ScanFilterAndProjectOperator.this.operatorFinishing || ScanFilterAndProjectOperator.this.pageSource.isFinished()) {
                return WorkProcessor.ProcessState.finished();
            }
            CompletableFuture isBlocked = ScanFilterAndProjectOperator.this.pageSource.isBlocked();
            if (!isBlocked.isDone()) {
                return WorkProcessor.ProcessState.blocked(MoreFutures.toListenableFuture((CompletableFuture)isBlocked));
            }
            Page page = ScanFilterAndProjectOperator.this.pageSource.getNextPage();
            this.pageSourceMemoryContext.setBytes(ScanFilterAndProjectOperator.this.pageSource.getSystemMemoryUsage());
            if (page == null) {
                if (ScanFilterAndProjectOperator.this.pageSource.isFinished()) {
                    return WorkProcessor.ProcessState.finished();
                }
                return WorkProcessor.ProcessState.yield();
            }
            page = ScanFilterAndProjectOperator.this.recordProcessedInput(page);
            long endCompletedBytes = ScanFilterAndProjectOperator.this.pageSource.getCompletedBytes();
            long endReadTimeNanos = ScanFilterAndProjectOperator.this.pageSource.getReadTimeNanos();
            ScanFilterAndProjectOperator.this.deltaPositionsCount = ScanFilterAndProjectOperator.this.deltaPositionsCount + (long)page.getPositionCount();
            ScanFilterAndProjectOperator.this.deltaPhysicalBytes = ScanFilterAndProjectOperator.this.deltaPhysicalBytes + (endCompletedBytes - this.completedBytes);
            ScanFilterAndProjectOperator.this.deltaPhysicalReadTimeNanos = ScanFilterAndProjectOperator.this.deltaPhysicalReadTimeNanos + (endReadTimeNanos - this.readTimeNanos);
            this.completedBytes = endCompletedBytes;
            this.readTimeNanos = endReadTimeNanos;
            return WorkProcessor.ProcessState.ofResult(page);
        }
    }

    private class RecordCursorToPages
    implements WorkProcessor.Process<Page> {
        final CursorProcessor cursorProcessor;
        final PageBuilder pageBuilder;
        final LocalMemoryContext pageSourceMemoryContext;
        final LocalMemoryContext outputMemoryContext;
        long completedBytes;
        long readTimeNanos;
        boolean finished;

        RecordCursorToPages(CursorProcessor cursorProcessor, List<Type> types, LocalMemoryContext pageSourceMemoryContext, LocalMemoryContext outputMemoryContext) {
            this.cursorProcessor = cursorProcessor;
            this.pageBuilder = new PageBuilder(types);
            this.pageSourceMemoryContext = pageSourceMemoryContext;
            this.outputMemoryContext = outputMemoryContext;
        }

        @Override
        public WorkProcessor.ProcessState<Page> process() {
            if (ScanFilterAndProjectOperator.this.operatorFinishing) {
                this.finished = true;
            }
            if (!this.finished) {
                DriverYieldSignal yieldSignal = ScanFilterAndProjectOperator.this.operatorContext.getDriverContext().getYieldSignal();
                CursorProcessorOutput output = this.cursorProcessor.process(ScanFilterAndProjectOperator.this.operatorContext.getSession().toConnectorSession(), yieldSignal, ScanFilterAndProjectOperator.this.cursor, this.pageBuilder);
                this.pageSourceMemoryContext.setBytes(ScanFilterAndProjectOperator.this.cursor.getSystemMemoryUsage());
                long bytesProcessed = ScanFilterAndProjectOperator.this.cursor.getCompletedBytes() - this.completedBytes;
                long elapsedNanos = ScanFilterAndProjectOperator.this.cursor.getReadTimeNanos() - this.readTimeNanos;
                ScanFilterAndProjectOperator.this.operatorContext.recordPhysicalInputWithTiming(bytesProcessed, output.getProcessedRows(), elapsedNanos);
                ScanFilterAndProjectOperator.this.operatorContext.recordProcessedInput(bytesProcessed, output.getProcessedRows());
                this.completedBytes = ScanFilterAndProjectOperator.this.cursor.getCompletedBytes();
                this.readTimeNanos = ScanFilterAndProjectOperator.this.cursor.getReadTimeNanos();
                if (output.isNoMoreRows()) {
                    this.finished = true;
                }
            }
            if (this.pageBuilder.isFull() || this.finished && !this.pageBuilder.isEmpty()) {
                Page page = this.pageBuilder.build();
                this.pageBuilder.reset();
                this.outputMemoryContext.setBytes(this.pageBuilder.getRetainedSizeInBytes());
                return WorkProcessor.ProcessState.ofResult(page);
            }
            if (this.finished) {
                Preconditions.checkState((boolean)this.pageBuilder.isEmpty());
                return WorkProcessor.ProcessState.finished();
            }
            this.outputMemoryContext.setBytes(this.pageBuilder.getRetainedSizeInBytes());
            return WorkProcessor.ProcessState.yield();
        }
    }

    private class SplitToPages
    implements WorkProcessor.Process<WorkProcessor<Page>> {
        final PageSourceProvider pageSourceProvider;
        final CursorProcessor cursorProcessor;
        final PageProcessor pageProcessor;
        final TableHandle table;
        final List<ColumnHandle> columns;
        final List<Type> types;
        final LocalMemoryContext memoryContext;
        final AggregatedMemoryContext localAggregatedMemoryContext;
        final LocalMemoryContext pageSourceMemoryContext;
        final LocalMemoryContext outputMemoryContext;
        final DataSize minOutputPageSize;
        final int minOutputPageRowCount;
        boolean finished;

        SplitToPages(PageSourceProvider pageSourceProvider, CursorProcessor cursorProcessor, PageProcessor pageProcessor, TableHandle table, Iterable<ColumnHandle> columns, Iterable<Type> types, AggregatedMemoryContext aggregatedMemoryContext, DataSize minOutputPageSize, int minOutputPageRowCount) {
            this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
            this.cursorProcessor = Objects.requireNonNull(cursorProcessor, "cursorProcessor is null");
            this.pageProcessor = Objects.requireNonNull(pageProcessor, "pageProcessor is null");
            this.table = Objects.requireNonNull(table, "table is null");
            this.columns = ImmutableList.copyOf(Objects.requireNonNull(columns, "columns is null"));
            this.types = ImmutableList.copyOf(Objects.requireNonNull(types, "types is null"));
            this.memoryContext = aggregatedMemoryContext.newLocalMemoryContext(ScanFilterAndProjectOperator.class.getSimpleName());
            this.localAggregatedMemoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
            this.pageSourceMemoryContext = this.localAggregatedMemoryContext.newLocalMemoryContext(ScanFilterAndProjectOperator.class.getSimpleName());
            this.outputMemoryContext = this.localAggregatedMemoryContext.newLocalMemoryContext(ScanFilterAndProjectOperator.class.getSimpleName());
            this.minOutputPageSize = Objects.requireNonNull(minOutputPageSize, "minOutputPageSize is null");
            this.minOutputPageRowCount = minOutputPageRowCount;
        }

        @Override
        public WorkProcessor.ProcessState<WorkProcessor<Page>> process() {
            if (ScanFilterAndProjectOperator.this.operatorFinishing || this.finished) {
                this.memoryContext.close();
                return WorkProcessor.ProcessState.finished();
            }
            if (!ScanFilterAndProjectOperator.this.blockedOnSplits.isDone()) {
                return WorkProcessor.ProcessState.blocked(ScanFilterAndProjectOperator.this.blockedOnSplits);
            }
            this.finished = true;
            EmptySplitPageSource source = ScanFilterAndProjectOperator.this.split.getConnectorSplit() instanceof EmptySplit ? new EmptySplitPageSource() : this.pageSourceProvider.createPageSource(ScanFilterAndProjectOperator.this.operatorContext.getSession(), ScanFilterAndProjectOperator.this.split, this.table, this.columns);
            if (source instanceof RecordPageSource) {
                ScanFilterAndProjectOperator.this.cursor = ((RecordPageSource)source).getCursor();
                return WorkProcessor.ProcessState.ofResult(this.processColumnSource());
            }
            ScanFilterAndProjectOperator.this.pageSource = (ConnectorPageSource)source;
            return WorkProcessor.ProcessState.ofResult(this.processPageSource());
        }

        WorkProcessor<Page> processColumnSource() {
            return WorkProcessor.create(new RecordCursorToPages(this.cursorProcessor, this.types, this.pageSourceMemoryContext, this.outputMemoryContext)).yielding(() -> ScanFilterAndProjectOperator.this.operatorContext.getDriverContext().getYieldSignal().isSet()).withProcessStateMonitor(state -> this.memoryContext.setBytes(this.localAggregatedMemoryContext.getBytes()));
        }

        WorkProcessor<Page> processPageSource() {
            return WorkProcessor.create(new ConnectorPageSourceToPages(this.pageSourceMemoryContext)).yielding(() -> ScanFilterAndProjectOperator.this.operatorContext.getDriverContext().getYieldSignal().isSet()).flatMap(page -> this.pageProcessor.createWorkProcessor(ScanFilterAndProjectOperator.this.operatorContext.getSession().toConnectorSession(), ScanFilterAndProjectOperator.this.operatorContext.getDriverContext().getYieldSignal(), this.outputMemoryContext, (Page)page)).transformProcessor(processor -> MergePages.mergePages(this.types, this.minOutputPageSize.toBytes(), this.minOutputPageRowCount, processor, this.localAggregatedMemoryContext)).withProcessStateMonitor(state -> {
                this.memoryContext.setBytes(this.localAggregatedMemoryContext.getBytes());
                ScanFilterAndProjectOperator.this.operatorContext.recordPhysicalInputWithTiming(ScanFilterAndProjectOperator.this.deltaPhysicalBytes, ScanFilterAndProjectOperator.this.deltaPositionsCount, ScanFilterAndProjectOperator.this.deltaPhysicalReadTimeNanos);
                ScanFilterAndProjectOperator.this.operatorContext.recordProcessedInput(ScanFilterAndProjectOperator.this.deltaProcessedBytes, ScanFilterAndProjectOperator.this.deltaPositionsCount);
                ScanFilterAndProjectOperator.this.deltaPositionsCount = 0L;
                ScanFilterAndProjectOperator.this.deltaPhysicalBytes = 0L;
                ScanFilterAndProjectOperator.this.deltaPhysicalReadTimeNanos = 0L;
                ScanFilterAndProjectOperator.this.deltaProcessedBytes = 0L;
            });
        }
    }
}

