/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.prestosql.sql.planner.plan.PlanNodeId;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class StageExecutionDescriptor {
    private final Set<PlanNodeId> groupedExecutionScanNodes;

    private StageExecutionDescriptor(Set<PlanNodeId> groupedExecutionScanNodes) {
        this.groupedExecutionScanNodes = groupedExecutionScanNodes;
    }

    public static StageExecutionDescriptor ungroupedExecution() {
        return new StageExecutionDescriptor((Set<PlanNodeId>)ImmutableSet.of());
    }

    public static StageExecutionDescriptor groupedExecution(List<PlanNodeId> capableScanNodes) {
        Objects.requireNonNull(capableScanNodes, "capableScanNodes is null");
        Preconditions.checkArgument((!capableScanNodes.isEmpty() ? 1 : 0) != 0);
        return new StageExecutionDescriptor((Set<PlanNodeId>)ImmutableSet.copyOf(capableScanNodes));
    }

    public boolean isStageGroupedExecution() {
        return !this.groupedExecutionScanNodes.isEmpty();
    }

    public boolean isScanGroupedExecution(PlanNodeId scanNodeId) {
        return this.groupedExecutionScanNodes.contains(scanNodeId);
    }

    @JsonCreator
    public static StageExecutionDescriptor jsonCreator(@JsonProperty(value="groupedExecutionScanNodes") Set<PlanNodeId> groupedExecutionCapableScanNodes) {
        return new StageExecutionDescriptor((Set<PlanNodeId>)ImmutableSet.copyOf((Collection)Objects.requireNonNull(groupedExecutionCapableScanNodes, "groupedExecutionScanNodes is null")));
    }

    @JsonProperty(value="groupedExecutionScanNodes")
    public Set<PlanNodeId> getJsonSerializableGroupedExecutionScanNodes() {
        return this.groupedExecutionScanNodes;
    }
}

