/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.MoreFutures;
import io.prestosql.Session;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.memory.context.MemoryTrackingContext;
import io.prestosql.metadata.Split;
import io.prestosql.metadata.TableHandle;
import io.prestosql.operator.WorkProcessor;
import io.prestosql.operator.WorkProcessorSourceOperator;
import io.prestosql.spi.Page;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.UpdatablePageSource;
import io.prestosql.split.PageSourceProvider;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class TableScanWorkProcessorOperator
implements WorkProcessorSourceOperator {
    private final WorkProcessor<Page> pages;
    private final SplitToPages splitToPages;

    public TableScanWorkProcessorOperator(Session session, MemoryTrackingContext memoryTrackingContext, WorkProcessor<Split> splits, PageSourceProvider pageSourceProvider, TableHandle table, Iterable<ColumnHandle> columns) {
        this.splitToPages = new SplitToPages(session, pageSourceProvider, table, columns, memoryTrackingContext.aggregateSystemMemoryContext());
        this.pages = splits.flatTransform(this.splitToPages);
    }

    @Override
    public WorkProcessor<Page> getOutputPages() {
        return this.pages;
    }

    @Override
    public Supplier<Optional<UpdatablePageSource>> getUpdatablePageSourceSupplier() {
        return this.splitToPages.getUpdatablePageSourceSupplier();
    }

    @Override
    public void close() throws Exception {
        this.splitToPages.close();
    }

    private static class ConnectorPageSourceToPages
    implements WorkProcessor.Process<Page> {
        final ConnectorPageSource pageSource;
        final LocalMemoryContext memoryContext;

        ConnectorPageSourceToPages(AggregatedMemoryContext aggregatedMemoryContext, ConnectorPageSource pageSource) {
            this.pageSource = pageSource;
            this.memoryContext = aggregatedMemoryContext.newLocalMemoryContext(TableScanWorkProcessorOperator.class.getSimpleName());
        }

        @Override
        public WorkProcessor.ProcessState<Page> process() {
            if (this.pageSource.isFinished()) {
                this.memoryContext.close();
                return WorkProcessor.ProcessState.finished();
            }
            CompletableFuture isBlocked = this.pageSource.isBlocked();
            if (!isBlocked.isDone()) {
                return WorkProcessor.ProcessState.blocked(MoreFutures.toListenableFuture((CompletableFuture)isBlocked));
            }
            Page page = this.pageSource.getNextPage();
            this.memoryContext.setBytes(this.pageSource.getSystemMemoryUsage());
            if (page == null) {
                if (this.pageSource.isFinished()) {
                    this.memoryContext.close();
                    return WorkProcessor.ProcessState.finished();
                }
                return WorkProcessor.ProcessState.yield();
            }
            return WorkProcessor.ProcessState.ofResult(page);
        }
    }

    private static class SplitToPages
    implements WorkProcessor.Transformation<Split, WorkProcessor<Page>> {
        final Session session;
        final PageSourceProvider pageSourceProvider;
        final TableHandle table;
        final List<ColumnHandle> columns;
        final AggregatedMemoryContext aggregatedMemoryContext;
        ConnectorPageSource source;

        SplitToPages(Session session, PageSourceProvider pageSourceProvider, TableHandle table, Iterable<ColumnHandle> columns, AggregatedMemoryContext aggregatedMemoryContext) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
            this.table = Objects.requireNonNull(table, "table is null");
            this.columns = ImmutableList.copyOf(Objects.requireNonNull(columns, "columns is null"));
            this.aggregatedMemoryContext = Objects.requireNonNull(aggregatedMemoryContext, "aggregatedMemoryContext is null");
        }

        @Override
        public WorkProcessor.TransformationState<WorkProcessor<Page>> process(Split split) {
            if (split == null) {
                return WorkProcessor.TransformationState.finished();
            }
            Preconditions.checkState((this.source == null ? 1 : 0) != 0, (Object)"Table scan split already set");
            this.source = this.pageSourceProvider.createPageSource(this.session, split, this.table, this.columns);
            return WorkProcessor.TransformationState.ofResult(WorkProcessor.create(new ConnectorPageSourceToPages(this.aggregatedMemoryContext, this.source)));
        }

        Supplier<Optional<UpdatablePageSource>> getUpdatablePageSourceSupplier() {
            return () -> {
                if (this.source instanceof UpdatablePageSource) {
                    return Optional.of((UpdatablePageSource)this.source);
                }
                return Optional.empty();
            };
        }

        void close() {
            if (this.source != null) {
                try {
                    this.source.close();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
    }
}

