/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.slice.Slice;
import io.airlift.units.Duration;
import io.prestosql.Session;
import io.prestosql.SystemSessionProperties;
import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.operator.DevNullOperator;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.OperationTimer;
import io.prestosql.operator.Operator;
import io.prestosql.operator.OperatorContext;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.OperatorInfo;
import io.prestosql.spi.Page;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.RunLengthEncodedBlock;
import io.prestosql.spi.connector.ConnectorPageSink;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.split.PageSinkManager;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.planner.plan.TableWriterNode;
import io.prestosql.util.AutoCloseableCloser;
import io.prestosql.util.Mergeable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class TableWriterOperator
implements Operator {
    public static final int ROW_COUNT_CHANNEL = 0;
    public static final int FRAGMENT_CHANNEL = 1;
    public static final int STATS_START_CHANNEL = 2;
    private final OperatorContext operatorContext;
    private final LocalMemoryContext pageSinkMemoryContext;
    private final ConnectorPageSink pageSink;
    private final List<Integer> columnChannels;
    private final AtomicLong pageSinkPeakMemoryUsage = new AtomicLong();
    private final Operator statisticAggregationOperator;
    private final List<Type> types;
    private ListenableFuture<?> blocked = NOT_BLOCKED;
    private CompletableFuture<Collection<Slice>> finishFuture;
    private State state = State.RUNNING;
    private long rowCount;
    private boolean committed;
    private boolean closed;
    private long writtenBytes;
    private final OperationTimer.OperationTiming statisticsTiming = new OperationTimer.OperationTiming();
    private final boolean statisticsCpuTimerEnabled;

    public TableWriterOperator(OperatorContext operatorContext, ConnectorPageSink pageSink, List<Integer> columnChannels, Operator statisticAggregationOperator, List<Type> types, boolean statisticsCpuTimerEnabled) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.pageSinkMemoryContext = operatorContext.newLocalSystemMemoryContext(TableWriterOperator.class.getSimpleName());
        this.pageSink = Objects.requireNonNull(pageSink, "pageSink is null");
        this.columnChannels = Objects.requireNonNull(columnChannels, "columnChannels is null");
        this.operatorContext.setInfoSupplier(this::getInfo);
        this.statisticAggregationOperator = Objects.requireNonNull(statisticAggregationOperator, "statisticAggregationOperator is null");
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.statisticsCpuTimerEnabled = statisticsCpuTimerEnabled;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        ListenableFuture<?> currentlyBlocked = this.blocked;
        OperationTimer timer = new OperationTimer(this.statisticsCpuTimerEnabled);
        this.statisticAggregationOperator.finish();
        timer.end(this.statisticsTiming);
        ListenableFuture<?> blockedOnAggregation = this.statisticAggregationOperator.isBlocked();
        ListenableFuture blockedOnFinish = NOT_BLOCKED;
        if (this.state == State.RUNNING) {
            this.state = State.FINISHING;
            this.finishFuture = this.pageSink.finish();
            blockedOnFinish = MoreFutures.toListenableFuture(this.finishFuture);
            this.updateWrittenBytes();
        }
        this.blocked = Futures.allAsList((ListenableFuture[])new ListenableFuture[]{currentlyBlocked, blockedOnAggregation, blockedOnFinish});
    }

    @Override
    public boolean isFinished() {
        return this.state == State.FINISHED && this.blocked.isDone();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.blocked;
    }

    @Override
    public boolean needsInput() {
        if (this.state != State.RUNNING || !this.blocked.isDone()) {
            return false;
        }
        return this.statisticAggregationOperator.needsInput();
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((boolean)this.needsInput(), (Object)"Operator does not need input");
        Block[] blocks = new Block[this.columnChannels.size()];
        for (int outputChannel = 0; outputChannel < this.columnChannels.size(); ++outputChannel) {
            blocks[outputChannel] = page.getBlock(this.columnChannels.get(outputChannel).intValue());
        }
        OperationTimer timer = new OperationTimer(this.statisticsCpuTimerEnabled);
        this.statisticAggregationOperator.addInput(page);
        timer.end(this.statisticsTiming);
        ListenableFuture<?> blockedOnAggregation = this.statisticAggregationOperator.isBlocked();
        CompletableFuture future = this.pageSink.appendPage(new Page(blocks));
        this.updateMemoryUsage();
        ListenableFuture blockedOnWrite = MoreFutures.toListenableFuture((CompletableFuture)future);
        this.blocked = Futures.allAsList((ListenableFuture[])new ListenableFuture[]{blockedOnAggregation, blockedOnWrite});
        this.rowCount += (long)page.getPositionCount();
        this.updateWrittenBytes();
    }

    @Override
    public Page getOutput() {
        if (!this.blocked.isDone()) {
            return null;
        }
        if (!this.statisticAggregationOperator.isFinished()) {
            OperationTimer timer = new OperationTimer(this.statisticsCpuTimerEnabled);
            Page aggregationOutput = this.statisticAggregationOperator.getOutput();
            timer.end(this.statisticsTiming);
            if (aggregationOutput == null) {
                return null;
            }
            return this.createStatisticsPage(aggregationOutput);
        }
        if (this.state != State.FINISHING) {
            return null;
        }
        Page fragmentsPage = this.createFragmentsPage();
        int positionCount = fragmentsPage.getPositionCount();
        Block[] outputBlocks = new Block[this.types.size()];
        for (int channel = 0; channel < this.types.size(); ++channel) {
            outputBlocks[channel] = channel < 2 ? fragmentsPage.getBlock(channel) : RunLengthEncodedBlock.create((Type)this.types.get(channel), null, (int)positionCount);
        }
        this.state = State.FINISHED;
        return new Page(positionCount, outputBlocks);
    }

    private Page createStatisticsPage(Page aggregationOutput) {
        int positionCount = aggregationOutput.getPositionCount();
        Block[] outputBlocks = new Block[this.types.size()];
        for (int channel = 0; channel < this.types.size(); ++channel) {
            outputBlocks[channel] = channel < 2 ? RunLengthEncodedBlock.create((Type)this.types.get(channel), null, (int)positionCount) : aggregationOutput.getBlock(channel - 2);
        }
        return new Page(positionCount, outputBlocks);
    }

    private Page createFragmentsPage() {
        Collection fragments = (Collection)MoreFutures.getFutureValue(this.finishFuture);
        this.committed = true;
        this.updateWrittenBytes();
        PageBuilder page = new PageBuilder(fragments.size() + 1, (List)ImmutableList.of((Object)this.types.get(0), (Object)this.types.get(1)));
        BlockBuilder rowsBuilder = page.getBlockBuilder(0);
        BlockBuilder fragmentBuilder = page.getBlockBuilder(1);
        page.declarePosition();
        BigintType.BIGINT.writeLong(rowsBuilder, this.rowCount);
        fragmentBuilder.appendNull();
        for (Slice fragment : fragments) {
            page.declarePosition();
            rowsBuilder.appendNull();
            VarbinaryType.VARBINARY.writeSlice(fragmentBuilder, fragment);
        }
        return page.build();
    }

    @Override
    public void close() throws Exception {
        AutoCloseableCloser closer = AutoCloseableCloser.create();
        if (!this.closed) {
            this.closed = true;
            if (!this.committed) {
                closer.register(() -> ((ConnectorPageSink)this.pageSink).abort());
            }
        }
        closer.register(this.statisticAggregationOperator);
        closer.register(() -> this.pageSinkMemoryContext.close());
        closer.close();
    }

    private void updateWrittenBytes() {
        long current = this.pageSink.getCompletedBytes();
        this.operatorContext.recordPhysicalWrittenData(current - this.writtenBytes);
        this.writtenBytes = current;
    }

    private void updateMemoryUsage() {
        long pageSinkMemoryUsage = this.pageSink.getSystemMemoryUsage();
        this.pageSinkMemoryContext.setBytes(pageSinkMemoryUsage);
        this.pageSinkPeakMemoryUsage.accumulateAndGet(pageSinkMemoryUsage, Math::max);
    }

    @VisibleForTesting
    Operator getStatisticAggregationOperator() {
        return this.statisticAggregationOperator;
    }

    @VisibleForTesting
    TableWriterInfo getInfo() {
        return new TableWriterInfo(this.pageSinkPeakMemoryUsage.get(), new Duration((double)this.statisticsTiming.getWallNanos(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)this.statisticsTiming.getCpuNanos(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)this.pageSink.getValidationCpuNanos(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit());
    }

    public static class TableWriterInfo
    implements Mergeable<TableWriterInfo>,
    OperatorInfo {
        private final long pageSinkPeakMemoryUsage;
        private final Duration statisticsWallTime;
        private final Duration statisticsCpuTime;
        private final Duration validationCpuTime;

        @JsonCreator
        public TableWriterInfo(@JsonProperty(value="pageSinkPeakMemoryUsage") long pageSinkPeakMemoryUsage, @JsonProperty(value="statisticsWallTime") Duration statisticsWallTime, @JsonProperty(value="statisticsCpuTime") Duration statisticsCpuTime, @JsonProperty(value="validationCpuTime") Duration validationCpuTime) {
            this.pageSinkPeakMemoryUsage = pageSinkPeakMemoryUsage;
            this.statisticsWallTime = Objects.requireNonNull(statisticsWallTime, "statisticsWallTime is null");
            this.statisticsCpuTime = Objects.requireNonNull(statisticsCpuTime, "statisticsCpuTime is null");
            this.validationCpuTime = Objects.requireNonNull(validationCpuTime, "validationCpuTime is null");
        }

        @JsonProperty
        public long getPageSinkPeakMemoryUsage() {
            return this.pageSinkPeakMemoryUsage;
        }

        @JsonProperty
        public Duration getStatisticsWallTime() {
            return this.statisticsWallTime;
        }

        @JsonProperty
        public Duration getStatisticsCpuTime() {
            return this.statisticsCpuTime;
        }

        @JsonProperty
        public Duration getValidationCpuTime() {
            return this.validationCpuTime;
        }

        @Override
        public TableWriterInfo mergeWith(TableWriterInfo other) {
            return new TableWriterInfo(Math.max(this.pageSinkPeakMemoryUsage, other.pageSinkPeakMemoryUsage), new Duration(this.statisticsWallTime.getValue(TimeUnit.NANOSECONDS) + other.statisticsWallTime.getValue(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration(this.statisticsCpuTime.getValue(TimeUnit.NANOSECONDS) + other.statisticsCpuTime.getValue(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration(this.validationCpuTime.getValue(TimeUnit.NANOSECONDS) + other.validationCpuTime.getValue(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit());
        }

        @Override
        public boolean isFinal() {
            return true;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("pageSinkPeakMemoryUsage", this.pageSinkPeakMemoryUsage).add("statisticsWallTime", (Object)this.statisticsWallTime).add("statisticsCpuTime", (Object)this.statisticsCpuTime).add("validationCpuTime", (Object)this.validationCpuTime).toString();
        }
    }

    private static enum State {
        RUNNING,
        FINISHING,
        FINISHED;

    }

    public static class TableWriterOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final PageSinkManager pageSinkManager;
        private final TableWriterNode.WriterTarget target;
        private final List<Integer> columnChannels;
        private final Session session;
        private final OperatorFactory statisticsAggregationOperatorFactory;
        private final List<Type> types;
        private boolean closed;

        public TableWriterOperatorFactory(int operatorId, PlanNodeId planNodeId, PageSinkManager pageSinkManager, TableWriterNode.WriterTarget writerTarget, List<Integer> columnChannels, Session session, OperatorFactory statisticsAggregationOperatorFactory, List<Type> types) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.columnChannels = Objects.requireNonNull(columnChannels, "columnChannels is null");
            this.pageSinkManager = Objects.requireNonNull(pageSinkManager, "pageSinkManager is null");
            Preconditions.checkArgument((writerTarget instanceof TableWriterNode.CreateHandle || writerTarget instanceof TableWriterNode.InsertHandle ? 1 : 0) != 0, (Object)"writerTarget must be CreateHandle or InsertHandle");
            this.target = Objects.requireNonNull(writerTarget, "writerTarget is null");
            this.session = session;
            this.statisticsAggregationOperatorFactory = Objects.requireNonNull(statisticsAggregationOperatorFactory, "statisticsAggregationOperatorFactory is null");
            this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext context = driverContext.addOperatorContext(this.operatorId, this.planNodeId, TableWriterOperator.class.getSimpleName());
            Operator statisticsAggregationOperator = this.statisticsAggregationOperatorFactory.createOperator(driverContext);
            boolean statisticsCpuTimerEnabled = !(statisticsAggregationOperator instanceof DevNullOperator) && SystemSessionProperties.isStatisticsCpuTimerEnabled(this.session);
            return new TableWriterOperator(context, this.createPageSink(), this.columnChannels, statisticsAggregationOperator, this.types, statisticsCpuTimerEnabled);
        }

        private ConnectorPageSink createPageSink() {
            if (this.target instanceof TableWriterNode.CreateHandle) {
                return this.pageSinkManager.createPageSink(this.session, ((TableWriterNode.CreateHandle)this.target).getHandle());
            }
            if (this.target instanceof TableWriterNode.InsertHandle) {
                return this.pageSinkManager.createPageSink(this.session, ((TableWriterNode.InsertHandle)this.target).getHandle());
            }
            throw new UnsupportedOperationException("Unhandled target type: " + this.target.getClass().getName());
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new TableWriterOperatorFactory(this.operatorId, this.planNodeId, this.pageSinkManager, this.target, this.columnChannels, this.session, this.statisticsAggregationOperatorFactory, this.types);
        }
    }
}

