/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.Session;
import io.prestosql.memory.context.MemoryTrackingContext;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.DriverYieldSignal;
import io.prestosql.operator.Operator;
import io.prestosql.operator.OperatorContext;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.TopNProcessor;
import io.prestosql.operator.TopNWorkProcessorOperator;
import io.prestosql.operator.WorkProcessor;
import io.prestosql.operator.WorkProcessorOperator;
import io.prestosql.operator.WorkProcessorOperatorFactory;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.SortOrder;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.plan.PlanNodeId;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class TopNOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final TopNProcessor topNProcessor;
    private boolean finishing;

    public TopNOperator(OperatorContext operatorContext, List<Type> types, int n, List<Integer> sortChannels, List<SortOrder> sortOrders) {
        this.operatorContext = operatorContext;
        this.topNProcessor = new TopNProcessor(Objects.requireNonNull(operatorContext, "operatorContext is null").aggregateUserMemoryContext(), types, n, sortChannels, sortOrders);
        if (n == 0) {
            this.finishing = true;
        }
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.topNProcessor.noMoreOutput();
    }

    @Override
    public boolean needsInput() {
        return !this.finishing && !this.topNProcessor.noMoreOutput();
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is already finishing");
        this.topNProcessor.addInput(page);
    }

    @Override
    public Page getOutput() {
        if (!this.finishing || this.topNProcessor.noMoreOutput()) {
            return null;
        }
        return this.topNProcessor.getOutput();
    }

    public static class TopNOperatorFactory
    implements OperatorFactory,
    WorkProcessorOperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final List<Type> sourceTypes;
        private final int n;
        private final List<Integer> sortChannels;
        private final List<SortOrder> sortOrders;
        private boolean closed;

        public TopNOperatorFactory(int operatorId, PlanNodeId planNodeId, List<? extends Type> types, int n, List<Integer> sortChannels, List<SortOrder> sortOrders) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.sourceTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
            this.n = n;
            this.sortChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortChannels, "sortChannels is null"));
            this.sortOrders = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortOrders, "sortOrders is null"));
        }

        @Override
        public int getOperatorId() {
            return this.operatorId;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, TopNOperator.class.getSimpleName());
            return new TopNOperator(operatorContext, this.sourceTypes, this.n, this.sortChannels, this.sortOrders);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new TopNOperatorFactory(this.operatorId, this.planNodeId, this.sourceTypes, this.n, this.sortChannels, this.sortOrders);
        }

        @Override
        public WorkProcessorOperator create(Session session, MemoryTrackingContext memoryTrackingContext, DriverYieldSignal yieldSignal, WorkProcessor<Page> sourcePages) {
            return new TopNWorkProcessorOperator(memoryTrackingContext, sourcePages, this.sourceTypes, this.n, this.sortChannels, this.sortOrders);
        }
    }
}

