/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import io.prestosql.memory.context.MemoryTrackingContext;
import io.prestosql.operator.TopNProcessor;
import io.prestosql.operator.WorkProcessor;
import io.prestosql.operator.WorkProcessorOperator;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.SortOrder;
import io.prestosql.spi.type.Type;
import java.util.List;
import java.util.Objects;

public class TopNWorkProcessorOperator
implements WorkProcessorOperator {
    private final TopNProcessor topNProcessor;
    private final WorkProcessor<Page> pages;

    public TopNWorkProcessorOperator(MemoryTrackingContext memoryTrackingContext, WorkProcessor<Page> sourcePages, List<Type> types, int n, List<Integer> sortChannels, List<SortOrder> sortOrders) {
        this.topNProcessor = new TopNProcessor(Objects.requireNonNull(memoryTrackingContext, "memoryTrackingContext is null").aggregateUserMemoryContext(), types, n, sortChannels, sortOrders);
        this.pages = n == 0 ? WorkProcessor.of(new Page[0]) : sourcePages.transform(new TopNPages());
    }

    @Override
    public WorkProcessor<Page> getOutputPages() {
        return this.pages;
    }

    @Override
    public void close() throws Exception {
    }

    private class TopNPages
    implements WorkProcessor.Transformation<Page, Page> {
        private TopNPages() {
        }

        @Override
        public WorkProcessor.TransformationState<Page> process(Page inputPage) {
            if (inputPage != null) {
                TopNWorkProcessorOperator.this.topNProcessor.addInput(inputPage);
                return WorkProcessor.TransformationState.needsMoreData();
            }
            Page page = null;
            while (page == null && !TopNWorkProcessorOperator.this.topNProcessor.noMoreOutput()) {
                page = TopNWorkProcessorOperator.this.topNProcessor.getOutput();
            }
            if (page != null) {
                return WorkProcessor.TransformationState.ofResult(page, false);
            }
            return WorkProcessor.TransformationState.finished();
        }
    }
}

