/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.collect.ImmutableList;
import io.prestosql.operator.window.FrameInfo;
import io.prestosql.operator.window.WindowFunctionSupplier;
import io.prestosql.spi.function.WindowFunction;
import io.prestosql.spi.type.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class WindowFunctionDefinition {
    private final WindowFunctionSupplier functionSupplier;
    private final Type type;
    private final FrameInfo frameInfo;
    private final List<Integer> argumentChannels;

    public static WindowFunctionDefinition window(WindowFunctionSupplier functionSupplier, Type type, FrameInfo frameInfo, List<Integer> inputs) {
        return new WindowFunctionDefinition(functionSupplier, type, frameInfo, inputs);
    }

    public static WindowFunctionDefinition window(WindowFunctionSupplier functionSupplier, Type type, FrameInfo frameInfo, Integer ... inputs) {
        return WindowFunctionDefinition.window(functionSupplier, type, frameInfo, Arrays.asList(inputs));
    }

    WindowFunctionDefinition(WindowFunctionSupplier functionSupplier, Type type, FrameInfo frameInfo, List<Integer> argumentChannels) {
        Objects.requireNonNull(functionSupplier, "functionSupplier is null");
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(frameInfo, "frameInfo is null");
        Objects.requireNonNull(argumentChannels, "inputs is null");
        this.functionSupplier = functionSupplier;
        this.type = type;
        this.frameInfo = frameInfo;
        this.argumentChannels = ImmutableList.copyOf(argumentChannels);
    }

    public FrameInfo getFrameInfo() {
        return this.frameInfo;
    }

    public Type getType() {
        return this.type;
    }

    public WindowFunction createWindowFunction() {
        return this.functionSupplier.createWindowFunction(this.argumentChannels);
    }
}

