/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.log.Logger;
import io.prestosql.memory.context.MemoryTrackingContext;
import io.prestosql.metadata.Split;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.OperatorContext;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.SourceOperator;
import io.prestosql.operator.SourceOperatorFactory;
import io.prestosql.operator.SplitOperatorInfo;
import io.prestosql.operator.WorkProcessor;
import io.prestosql.operator.WorkProcessorOperator;
import io.prestosql.operator.WorkProcessorOperatorFactory;
import io.prestosql.operator.WorkProcessorSourceOperator;
import io.prestosql.operator.WorkProcessorSourceOperatorFactory;
import io.prestosql.spi.Page;
import io.prestosql.spi.connector.UpdatablePageSource;
import io.prestosql.sql.planner.plan.PlanNodeId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class WorkProcessorPipelineSourceOperator
implements SourceOperator {
    private static final Logger log = Logger.get(WorkProcessorPipelineSourceOperator.class);
    private final PlanNodeId sourceId;
    private final OperatorContext operatorContext;
    private final WorkProcessor<Page> pages;
    private final List<WorkProcessorOperatorContext> workProcessorOperatorContexts = new ArrayList<WorkProcessorOperatorContext>();
    private final List<Split> pendingSplits = new ArrayList<Split>();
    private WorkProcessorSourceOperator sourceOperator;
    private SettableFuture<?> blockedOnSplits = SettableFuture.create();
    private boolean operatorFinishing;

    public static List<OperatorFactory> convertOperators(int operatorId, List<OperatorFactory> operatorFactories) {
        int operatorIndex;
        if (operatorFactories.isEmpty() || !(operatorFactories.get(0) instanceof WorkProcessorSourceOperatorFactory)) {
            return operatorFactories;
        }
        WorkProcessorSourceOperatorFactory sourceOperatorFactory = (WorkProcessorSourceOperatorFactory)((Object)operatorFactories.get(0));
        ImmutableList.Builder workProcessorOperatorFactoriesBuilder = ImmutableList.builder();
        for (operatorIndex = 1; operatorIndex < operatorFactories.size() && operatorFactories.get(operatorIndex) instanceof WorkProcessorOperatorFactory; ++operatorIndex) {
            workProcessorOperatorFactoriesBuilder.add((Object)((WorkProcessorOperatorFactory)((Object)operatorFactories.get(operatorIndex))));
        }
        ImmutableList workProcessorOperatorFactories = workProcessorOperatorFactoriesBuilder.build();
        if (workProcessorOperatorFactories.isEmpty()) {
            return operatorFactories;
        }
        return ImmutableList.builder().add((Object)new WorkProcessorPipelineSourceOperatorFactory(operatorId, sourceOperatorFactory, (List)workProcessorOperatorFactories)).addAll(operatorFactories.subList(operatorIndex, operatorFactories.size())).build();
    }

    private WorkProcessorPipelineSourceOperator(int operatorId, DriverContext driverContext, WorkProcessorSourceOperatorFactory sourceOperatorFactory, List<WorkProcessorOperatorFactory> operatorFactories) {
        Objects.requireNonNull(driverContext, "driverContext is null");
        Objects.requireNonNull(sourceOperatorFactory, "sourceOperatorFactory is null");
        Objects.requireNonNull(operatorFactories, "operatorFactories is null");
        this.sourceId = sourceOperatorFactory.getSourceId();
        this.operatorContext = driverContext.addOperatorContext(operatorId, this.sourceId, WorkProcessorPipelineSourceOperator.class.getSimpleName());
        MemoryTrackingContext sourceOperatorMemoryTrackingContext = WorkProcessorPipelineSourceOperator.createMemoryTrackingContext(this.operatorContext);
        WorkProcessor<Split> splits = WorkProcessor.create(new Splits());
        this.sourceOperator = sourceOperatorFactory.create(this.operatorContext.getSession(), sourceOperatorMemoryTrackingContext, this.operatorContext.getDriverContext().getYieldSignal(), splits);
        sourceOperatorMemoryTrackingContext.initializeLocalMemoryContexts(this.sourceOperator.getClass().getSimpleName());
        this.workProcessorOperatorContexts.add(new WorkProcessorOperatorContext(this.sourceOperator, sourceOperatorFactory.getOperatorId(), sourceOperatorMemoryTrackingContext));
        WorkProcessor<Page> pages = this.sourceOperator.getOutputPages();
        pages = pages.withProcessStateMonitor(state -> {
            if (state.getType() == WorkProcessor.ProcessState.Type.FINISHED) {
                this.closeOperators(0);
            }
        });
        for (int i = 0; i < operatorFactories.size(); ++i) {
            MemoryTrackingContext operatorMemoryTrackingContext = WorkProcessorPipelineSourceOperator.createMemoryTrackingContext(this.operatorContext);
            WorkProcessorOperator operator = operatorFactories.get(i).create(this.operatorContext.getSession(), operatorMemoryTrackingContext, this.operatorContext.getDriverContext().getYieldSignal(), pages);
            operatorMemoryTrackingContext.initializeLocalMemoryContexts(operator.getClass().getSimpleName());
            this.workProcessorOperatorContexts.add(new WorkProcessorOperatorContext(operator, operatorFactories.get(i).getOperatorId(), operatorMemoryTrackingContext));
            pages = operator.getOutputPages();
            int operatorIndex = i + 1;
            pages = pages.withProcessStateMonitor(state -> {
                if (state.getType() == WorkProcessor.ProcessState.Type.FINISHED) {
                    this.closeOperators(operatorIndex);
                }
            });
        }
        pages = pages.map(Page::getLoadedPage);
        this.pages = pages.finishWhen(() -> this.operatorFinishing);
    }

    private static MemoryTrackingContext createMemoryTrackingContext(OperatorContext operatorContext) {
        return new MemoryTrackingContext(operatorContext.newAggregateUserMemoryContext(), operatorContext.newAggregateRevocableMemoryContext(), operatorContext.newAggregateSystemMemoryContext());
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.sourceId;
    }

    @Override
    public Supplier<Optional<UpdatablePageSource>> addSplit(Split split) {
        if (this.sourceOperator == null) {
            return Optional::empty;
        }
        Object splitInfo = split.getInfo();
        if (splitInfo != null) {
            this.operatorContext.setInfoSupplier(() -> new SplitOperatorInfo(splitInfo));
        }
        this.pendingSplits.add(split);
        this.blockedOnSplits.set(null);
        return this.sourceOperator.getUpdatablePageSourceSupplier();
    }

    @Override
    public void noMoreSplits() {
        this.blockedOnSplits.set(null);
        this.sourceOperator = null;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Page getOutput() {
        if (!this.pages.process()) {
            return null;
        }
        if (this.pages.isFinished()) {
            return null;
        }
        return this.pages.getResult();
    }

    @Override
    public ListenableFuture<?> startMemoryRevoke() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void finishMemoryRevoke() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void finish() {
        this.operatorFinishing = true;
        this.noMoreSplits();
        this.closeOperators(this.workProcessorOperatorContexts.size() - 1);
    }

    @Override
    public boolean isFinished() {
        return this.pages.isFinished();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        if (!this.pages.isBlocked()) {
            return NOT_BLOCKED;
        }
        return this.pages.getBlockedFuture();
    }

    @Override
    public void close() {
        this.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeOperators(int lastOperatorIndex) {
        boolean wasInterrupted = Thread.interrupted();
        Throwable inFlightException = null;
        try {
            for (int i = 0; i <= lastOperatorIndex; ++i) {
                WorkProcessorOperatorContext workProcessorOperatorContext = this.workProcessorOperatorContexts.get(i);
                if (workProcessorOperatorContext == null) continue;
                try {
                    workProcessorOperatorContext.operator.close();
                    continue;
                }
                catch (InterruptedException t) {
                    wasInterrupted = true;
                    continue;
                }
                catch (Throwable t) {
                    inFlightException = WorkProcessorPipelineSourceOperator.handleOperatorCloseError(inFlightException, t, "Error closing WorkProcessor operator %s for task %s", workProcessorOperatorContext.operatorId, this.operatorContext.getDriverContext().getTaskId());
                    continue;
                }
                finally {
                    workProcessorOperatorContext.memoryTrackingContext.close();
                    this.workProcessorOperatorContexts.set(i, null);
                }
            }
        }
        finally {
            if (wasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
        if (inFlightException != null) {
            Throwables.throwIfUnchecked(inFlightException);
            throw new RuntimeException(inFlightException);
        }
    }

    private static Throwable handleOperatorCloseError(Throwable inFlightException, Throwable newException, String message, Object ... args) {
        if (newException instanceof Error) {
            if (inFlightException == null) {
                inFlightException = newException;
            } else if (inFlightException != newException) {
                inFlightException.addSuppressed(newException);
            }
        } else {
            log.error(newException, message, args);
        }
        return inFlightException;
    }

    public static class WorkProcessorPipelineSourceOperatorFactory
    implements SourceOperatorFactory {
        private final int operatorId;
        private final WorkProcessorSourceOperatorFactory sourceOperatorFactory;
        private final List<WorkProcessorOperatorFactory> operatorFactories;
        private boolean closed;

        private WorkProcessorPipelineSourceOperatorFactory(int operatorId, WorkProcessorSourceOperatorFactory sourceOperatorFactory, List<WorkProcessorOperatorFactory> operatorFactories) {
            this.operatorId = operatorId;
            this.sourceOperatorFactory = Objects.requireNonNull(sourceOperatorFactory, "sourceOperatorFactory is null");
            this.operatorFactories = Objects.requireNonNull(operatorFactories, "operatorFactories is null");
        }

        @Override
        public PlanNodeId getSourceId() {
            return this.sourceOperatorFactory.getSourceId();
        }

        @Override
        public SourceOperator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            return new WorkProcessorPipelineSourceOperator(this.operatorId, driverContext, this.sourceOperatorFactory, this.operatorFactories);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }
    }

    private class WorkProcessorOperatorContext {
        final WorkProcessorOperator operator;
        final int operatorId;
        final MemoryTrackingContext memoryTrackingContext;

        private WorkProcessorOperatorContext(WorkProcessorOperator operator, int operatorId, MemoryTrackingContext memoryTrackingContext) {
            this.operator = operator;
            this.operatorId = operatorId;
            this.memoryTrackingContext = memoryTrackingContext;
        }
    }

    private class Splits
    implements WorkProcessor.Process<Split> {
        private Splits() {
        }

        @Override
        public WorkProcessor.ProcessState<Split> process() {
            boolean noMoreSplits;
            boolean bl = noMoreSplits = WorkProcessorPipelineSourceOperator.this.sourceOperator == null;
            if (WorkProcessorPipelineSourceOperator.this.pendingSplits.isEmpty()) {
                if (noMoreSplits) {
                    return WorkProcessor.ProcessState.finished();
                }
                WorkProcessorPipelineSourceOperator.this.blockedOnSplits = SettableFuture.create();
                return WorkProcessor.ProcessState.blocked(WorkProcessorPipelineSourceOperator.this.blockedOnSplits);
            }
            return WorkProcessor.ProcessState.ofResult(WorkProcessorPipelineSourceOperator.this.pendingSplits.remove(0));
        }
    }
}

