/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.prestosql.operator.ParametricImplementation;
import io.prestosql.operator.ParametricImplementationsGroup;
import io.prestosql.operator.aggregation.AggregationHeader;
import io.prestosql.operator.aggregation.AggregationImplementation;
import io.prestosql.operator.aggregation.ParametricAggregation;
import io.prestosql.operator.annotations.FunctionsParserHelper;
import io.prestosql.spi.function.AccumulatorState;
import io.prestosql.spi.function.AggregationFunction;
import io.prestosql.spi.function.AggregationStateSerializerFactory;
import io.prestosql.spi.function.CombineFunction;
import io.prestosql.spi.function.InputFunction;
import io.prestosql.spi.function.OutputFunction;
import io.prestosql.spi.type.TypeSignature;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

public class AggregationFromAnnotationsParser {
    private AggregationFromAnnotationsParser() {
    }

    @VisibleForTesting
    public static ParametricAggregation parseFunctionDefinitionWithTypesConstraint(Class<?> clazz, TypeSignature returnType, List<TypeSignature> argumentTypes) {
        Objects.requireNonNull(returnType, "returnType is null");
        Objects.requireNonNull(argumentTypes, "argumentTypes is null");
        for (ParametricAggregation aggregation : AggregationFromAnnotationsParser.parseFunctionDefinitions(clazz)) {
            if (!aggregation.getSignature().getReturnType().equals((Object)returnType) || !aggregation.getSignature().getArgumentTypes().equals(argumentTypes)) continue;
            return aggregation;
        }
        throw new IllegalArgumentException(String.format("No method with return type %s and arguments %s", returnType, argumentTypes));
    }

    public static List<ParametricAggregation> parseFunctionDefinitions(Class<?> aggregationDefinition) {
        AggregationFunction aggregationAnnotation = aggregationDefinition.getAnnotation(AggregationFunction.class);
        Objects.requireNonNull(aggregationAnnotation, "aggregationAnnotation is null");
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Class<?> stateClass : AggregationFromAnnotationsParser.getStateClasses(aggregationDefinition)) {
            Method combineFunction = AggregationFromAnnotationsParser.getCombineFunction(aggregationDefinition, stateClass);
            Optional<Method> aggregationStateSerializerFactory = AggregationFromAnnotationsParser.getAggregationStateSerializerFactory(aggregationDefinition, stateClass);
            for (Method outputFunction : AggregationFromAnnotationsParser.getOutputFunctions(aggregationDefinition, stateClass)) {
                for (Method inputFunction : AggregationFromAnnotationsParser.getInputFunctions(aggregationDefinition, stateClass)) {
                    for (AggregationHeader header : AggregationFromAnnotationsParser.parseHeaders(aggregationDefinition, outputFunction)) {
                        AggregationImplementation onlyImplementation = AggregationImplementation.Parser.parseImplementation(aggregationDefinition, header, stateClass, inputFunction, outputFunction, combineFunction, aggregationStateSerializerFactory);
                        ParametricImplementationsGroup implementations = ParametricImplementationsGroup.of((ParametricImplementation[])new AggregationImplementation[]{onlyImplementation});
                        builder.add((Object)new ParametricAggregation(implementations.getSignature(), header, implementations));
                    }
                }
            }
        }
        return builder.build();
    }

    public static ParametricAggregation parseFunctionDefinition(Class<?> aggregationDefinition) {
        ParametricImplementationsGroup.Builder<AggregationImplementation> implementationsBuilder = ParametricImplementationsGroup.builder();
        AggregationHeader header = AggregationFromAnnotationsParser.parseHeader(aggregationDefinition);
        for (Class<?> stateClass : AggregationFromAnnotationsParser.getStateClasses(aggregationDefinition)) {
            Method combineFunction = AggregationFromAnnotationsParser.getCombineFunction(aggregationDefinition, stateClass);
            Optional<Method> aggregationStateSerializerFactory = AggregationFromAnnotationsParser.getAggregationStateSerializerFactory(aggregationDefinition, stateClass);
            Method outputFunction = (Method)Iterables.getOnlyElement(AggregationFromAnnotationsParser.getOutputFunctions(aggregationDefinition, stateClass));
            for (Method inputFunction : AggregationFromAnnotationsParser.getInputFunctions(aggregationDefinition, stateClass)) {
                AggregationImplementation implementation = AggregationImplementation.Parser.parseImplementation(aggregationDefinition, header, stateClass, inputFunction, outputFunction, combineFunction, aggregationStateSerializerFactory);
                implementationsBuilder.addImplementation(implementation);
            }
        }
        ParametricImplementationsGroup<AggregationImplementation> implementations = implementationsBuilder.build();
        return new ParametricAggregation(implementations.getSignature(), header, implementations);
    }

    private static Optional<Method> getAggregationStateSerializerFactory(Class<?> aggregationDefinition, Class<?> stateClass) {
        List stateSerializerFactories = (List)FunctionsParserHelper.findPublicStaticMethodsWithAnnotation(aggregationDefinition, AggregationStateSerializerFactory.class).stream().filter(method -> method.getAnnotation(AggregationStateSerializerFactory.class).value().equals(stateClass)).collect(ImmutableList.toImmutableList());
        if (stateSerializerFactories.isEmpty()) {
            return Optional.empty();
        }
        Preconditions.checkArgument((stateSerializerFactories.size() == 1 ? 1 : 0) != 0, (String)"Expect at most 1 @AggregationStateSerializerFactory(%s.class) annotation, found %s in %s", (Object)stateClass.toGenericString(), (Object)stateSerializerFactories.size(), (Object)aggregationDefinition.toGenericString());
        return Optional.of(Iterables.getOnlyElement((Iterable)stateSerializerFactories));
    }

    private static AggregationHeader parseHeader(AnnotatedElement aggregationDefinition) {
        AggregationFunction aggregationAnnotation = aggregationDefinition.getAnnotation(AggregationFunction.class);
        Objects.requireNonNull(aggregationAnnotation, "aggregationAnnotation is null");
        return new AggregationHeader(aggregationAnnotation.value(), FunctionsParserHelper.parseDescription(aggregationDefinition), aggregationAnnotation.decomposable(), aggregationAnnotation.isOrderSensitive(), aggregationAnnotation.hidden());
    }

    private static List<AggregationHeader> parseHeaders(AnnotatedElement aggregationDefinition, AnnotatedElement toParse) {
        AggregationFunction aggregationAnnotation = aggregationDefinition.getAnnotation(AggregationFunction.class);
        return (List)AggregationFromAnnotationsParser.getNames(toParse, aggregationAnnotation).stream().map(name -> new AggregationHeader((String)name, FunctionsParserHelper.parseDescription(aggregationDefinition, toParse), aggregationAnnotation.decomposable(), aggregationAnnotation.isOrderSensitive(), aggregationAnnotation.hidden())).collect(ImmutableList.toImmutableList());
    }

    private static List<String> getNames(@Nullable AnnotatedElement outputFunction, AggregationFunction aggregationAnnotation) {
        ImmutableList defaultNames = ImmutableList.builder().add((Object)aggregationAnnotation.value()).addAll(Arrays.asList(aggregationAnnotation.alias())).build();
        if (outputFunction == null) {
            return defaultNames;
        }
        AggregationFunction annotation = outputFunction.getAnnotation(AggregationFunction.class);
        if (annotation == null) {
            return defaultNames;
        }
        return ImmutableList.builder().add((Object)annotation.value()).addAll(Arrays.asList(annotation.alias())).build();
    }

    public static Method getCombineFunction(Class<?> clazz, Class<?> stateClass) {
        List combineFunctions = (List)FunctionsParserHelper.findPublicStaticMethodsWithAnnotation(clazz, CombineFunction.class).stream().filter(method -> method.getParameterTypes()[AggregationImplementation.Parser.findAggregationStateParamId(method, 0)] == stateClass).filter(method -> method.getParameterTypes()[AggregationImplementation.Parser.findAggregationStateParamId(method, 1)] == stateClass).collect(ImmutableList.toImmutableList());
        Preconditions.checkArgument((combineFunctions.size() == 1 ? 1 : 0) != 0, (String)"There must be exactly one @CombineFunction in class %s for the @AggregationState %s", (Object)clazz.toGenericString(), (Object)stateClass.toGenericString());
        return (Method)Iterables.getOnlyElement((Iterable)combineFunctions);
    }

    private static List<Method> getOutputFunctions(Class<?> clazz, Class<?> stateClass) {
        List outputFunctions = (List)FunctionsParserHelper.findPublicStaticMethodsWithAnnotation(clazz, OutputFunction.class).stream().filter(method -> method.getParameterTypes()[AggregationImplementation.Parser.findAggregationStateParamId(method)] == stateClass).collect(ImmutableList.toImmutableList());
        Preconditions.checkArgument((!outputFunctions.isEmpty() ? 1 : 0) != 0, (Object)"Aggregation has no output functions");
        return outputFunctions;
    }

    private static List<Method> getInputFunctions(Class<?> clazz, Class<?> stateClass) {
        List inputFunctions = (List)FunctionsParserHelper.findPublicStaticMethodsWithAnnotation(clazz, InputFunction.class).stream().filter(method -> method.getParameterTypes()[AggregationImplementation.Parser.findAggregationStateParamId(method)] == stateClass).collect(ImmutableList.toImmutableList());
        Preconditions.checkArgument((!inputFunctions.isEmpty() ? 1 : 0) != 0, (Object)"Aggregation has no input functions");
        return inputFunctions;
    }

    private static Set<Class<?>> getStateClasses(Class<?> clazz) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Method inputFunction : FunctionsParserHelper.findPublicStaticMethodsWithAnnotation(clazz, InputFunction.class)) {
            Preconditions.checkArgument((inputFunction.getParameterTypes().length > 0 ? 1 : 0) != 0, (Object)"Input function has no parameters");
            Class<?> stateClass = AggregationImplementation.Parser.findAggregationStateParamType(inputFunction);
            Preconditions.checkArgument((boolean)AccumulatorState.class.isAssignableFrom(stateClass), (Object)"stateClass is not a subclass of AccumulatorState");
            builder.add(stateClass);
        }
        ImmutableSet stateClasses = builder.build();
        Preconditions.checkArgument((!stateClasses.isEmpty() ? 1 : 0) != 0, (Object)"No input functions found");
        return stateClasses;
    }
}

