/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AccumulatorStateFactory;
import io.prestosql.spi.function.AccumulatorStateSerializer;
import io.prestosql.spi.type.Type;
import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class AggregationMetadata {
    public static final Set<Class<?>> SUPPORTED_PARAMETER_TYPES = ImmutableSet.of(Block.class, Long.TYPE, Double.TYPE, Boolean.TYPE, Slice.class);
    private final String name;
    private final List<ParameterMetadata> valueInputMetadata;
    private final List<Class> lambdaInterfaces;
    private final MethodHandle inputFunction;
    private final MethodHandle combineFunction;
    private final MethodHandle outputFunction;
    private final List<AccumulatorStateDescriptor> accumulatorStateDescriptors;
    private final Type outputType;

    public AggregationMetadata(String name, List<ParameterMetadata> valueInputMetadata, MethodHandle inputFunction, MethodHandle combineFunction, MethodHandle outputFunction, List<AccumulatorStateDescriptor> accumulatorStateDescriptors, Type outputType) {
        this(name, valueInputMetadata, inputFunction, combineFunction, outputFunction, accumulatorStateDescriptors, outputType, (List<Class>)ImmutableList.of());
    }

    public AggregationMetadata(String name, List<ParameterMetadata> valueInputMetadata, MethodHandle inputFunction, MethodHandle combineFunction, MethodHandle outputFunction, List<AccumulatorStateDescriptor> accumulatorStateDescriptors, Type outputType, List<Class> lambdaInterfaces) {
        this.outputType = Objects.requireNonNull(outputType);
        this.valueInputMetadata = ImmutableList.copyOf((Collection)Objects.requireNonNull(valueInputMetadata, "valueInputMetadata is null"));
        this.name = Objects.requireNonNull(name, "name is null");
        this.inputFunction = Objects.requireNonNull(inputFunction, "inputFunction is null");
        this.combineFunction = Objects.requireNonNull(combineFunction, "combineFunction is null");
        this.outputFunction = Objects.requireNonNull(outputFunction, "outputFunction is null");
        this.accumulatorStateDescriptors = Objects.requireNonNull(accumulatorStateDescriptors, "accumulatorStateDescriptors is null");
        this.lambdaInterfaces = ImmutableList.copyOf((Collection)Objects.requireNonNull(lambdaInterfaces, "lambdaInterfaces is null"));
        AggregationMetadata.verifyInputFunctionSignature(inputFunction, valueInputMetadata, lambdaInterfaces, accumulatorStateDescriptors);
        AggregationMetadata.verifyCombineFunction(combineFunction, lambdaInterfaces, accumulatorStateDescriptors);
        AggregationMetadata.verifyExactOutputFunction(outputFunction, accumulatorStateDescriptors);
    }

    public Type getOutputType() {
        return this.outputType;
    }

    public List<ParameterMetadata> getValueInputMetadata() {
        return this.valueInputMetadata;
    }

    public List<Class> getLambdaInterfaces() {
        return this.lambdaInterfaces;
    }

    public String getName() {
        return this.name;
    }

    public MethodHandle getInputFunction() {
        return this.inputFunction;
    }

    public MethodHandle getCombineFunction() {
        return this.combineFunction;
    }

    public MethodHandle getOutputFunction() {
        return this.outputFunction;
    }

    public List<AccumulatorStateDescriptor> getAccumulatorStateDescriptors() {
        return this.accumulatorStateDescriptors;
    }

    private static void verifyInputFunctionSignature(MethodHandle method, List<ParameterMetadata> dataChannelMetadata, List<Class> lambdaInterfaces, List<AccumulatorStateDescriptor> stateDescriptors) {
        int i;
        Class<?>[] parameters = method.type().parameterArray();
        Preconditions.checkArgument((parameters.length > 0 ? 1 : 0) != 0, (Object)"Aggregation input function must have at least one parameter");
        Preconditions.checkArgument((parameters.length == dataChannelMetadata.size() + lambdaInterfaces.size() ? 1 : 0) != 0, (Object)"Wenlei TODO...");
        Preconditions.checkArgument((dataChannelMetadata.stream().filter(m -> m.getParameterType() == ParameterMetadata.ParameterType.STATE).count() == (long)stateDescriptors.size() ? 1 : 0) != 0, (Object)"Number of state parameter in input function must be the same as size of stateDescriptors");
        Preconditions.checkArgument((dataChannelMetadata.get(0).getParameterType() == ParameterMetadata.ParameterType.STATE ? 1 : 0) != 0, (Object)"First parameter must be state");
        int stateIndex = 0;
        block6: for (i = 0; i < dataChannelMetadata.size(); ++i) {
            ParameterMetadata metadata = dataChannelMetadata.get(i);
            switch (metadata.getParameterType()) {
                case STATE: {
                    Preconditions.checkArgument((stateDescriptors.get(stateIndex).getStateInterface() == parameters[i] ? 1 : 0) != 0, (String)"State argument must be of type %s", stateDescriptors.get(stateIndex).getStateInterface());
                    ++stateIndex;
                    continue block6;
                }
                case BLOCK_INPUT_CHANNEL: 
                case NULLABLE_BLOCK_INPUT_CHANNEL: {
                    Preconditions.checkArgument((parameters[i] == Block.class ? 1 : 0) != 0, (Object)"Parameter must be Block if it has @BlockPosition");
                    continue block6;
                }
                case INPUT_CHANNEL: {
                    Preconditions.checkArgument((boolean)SUPPORTED_PARAMETER_TYPES.contains(parameters[i]), (String)"Unsupported type: %s", (Object)parameters[i].getSimpleName());
                    AggregationMetadata.verifyMethodParameterType(method, i, metadata.getSqlType().getJavaType(), metadata.getSqlType().getDisplayName());
                    continue block6;
                }
                case BLOCK_INDEX: {
                    Preconditions.checkArgument((parameters[i] == Integer.TYPE ? 1 : 0) != 0, (Object)"Block index parameter must be an int");
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported parameter: " + (Object)((Object)metadata.getParameterType()));
                }
            }
        }
        Preconditions.checkArgument((stateIndex == stateDescriptors.size() ? 1 : 0) != 0, (String)"Input function only has %s states, expected: %s", (int)stateIndex, (int)stateDescriptors.size());
        for (i = 0; i < lambdaInterfaces.size(); ++i) {
            AggregationMetadata.verifyMethodParameterType(method, i + dataChannelMetadata.size(), lambdaInterfaces.get(i), "function");
        }
    }

    private static void verifyCombineFunction(MethodHandle method, List<Class> lambdaInterfaces, List<AccumulatorStateDescriptor> stateDescriptors) {
        int i;
        Class<?>[] parameterTypes = method.type().parameterArray();
        Preconditions.checkArgument((parameterTypes.length == stateDescriptors.size() * 2 + lambdaInterfaces.size() ? 1 : 0) != 0, (Object)"Number of arguments for combine function must be 2 times the size of states plus number of lambda channels.");
        for (i = 0; i < stateDescriptors.size() * 2; ++i) {
            Preconditions.checkArgument((boolean)parameterTypes[i].equals(stateDescriptors.get(i % stateDescriptors.size()).getStateInterface()), (String)"Type for Parameter index %s is unexpected. Arguments for combine function must appear in the order of state1, state2, ..., otherState1, otherState2, ...", (int)i);
        }
        for (i = 0; i < lambdaInterfaces.size(); ++i) {
            AggregationMetadata.verifyMethodParameterType(method, i + stateDescriptors.size() * 2, lambdaInterfaces.get(i), "function");
        }
    }

    private static void verifyExactOutputFunction(MethodHandle method, List<AccumulatorStateDescriptor> stateDescriptors) {
        if (method == null) {
            return;
        }
        Class<?>[] parameterTypes = method.type().parameterArray();
        Preconditions.checkArgument((parameterTypes.length == stateDescriptors.size() + 1 ? 1 : 0) != 0, (Object)"Number of arguments for combine function must be exactly one plus than number of states.");
        for (int i = 0; i < stateDescriptors.size(); ++i) {
            Preconditions.checkArgument((boolean)parameterTypes[i].equals(stateDescriptors.get(i).getStateInterface()), (String)"Type for Parameter index %s is unexpected", (int)i);
        }
        Preconditions.checkArgument((Arrays.stream(parameterTypes).filter(type -> type.equals(BlockBuilder.class)).count() == 1L ? 1 : 0) != 0, (Object)"Output function must take exactly one BlockBuilder parameter");
    }

    private static void verifyMethodParameterType(MethodHandle method, int index, Class javaType, String sqlTypeDisplayName) {
        Preconditions.checkArgument((method.type().parameterArray()[index] == javaType ? 1 : 0) != 0, (String)"Expected method %s parameter %s type to be %s (%s)", (Object)method, (Object)index, (Object)javaType.getName(), (Object)sqlTypeDisplayName);
    }

    public static int countInputChannels(List<ParameterMetadata> metadatas) {
        int parameters = 0;
        for (ParameterMetadata metadata : metadatas) {
            if (metadata.getParameterType() != ParameterMetadata.ParameterType.INPUT_CHANNEL && metadata.getParameterType() != ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL && metadata.getParameterType() != ParameterMetadata.ParameterType.NULLABLE_BLOCK_INPUT_CHANNEL) continue;
            ++parameters;
        }
        return parameters;
    }

    public static class AccumulatorStateDescriptor {
        private final Class<?> stateInterface;
        private final AccumulatorStateSerializer<?> serializer;
        private final AccumulatorStateFactory<?> factory;

        public AccumulatorStateDescriptor(Class<?> stateInterface, AccumulatorStateSerializer<?> serializer, AccumulatorStateFactory<?> factory) {
            this.stateInterface = Objects.requireNonNull(stateInterface, "stateInterface is null");
            this.serializer = Objects.requireNonNull(serializer, "serializer is null");
            this.factory = Objects.requireNonNull(factory, "factory is null");
        }

        public Class<?> getStateInterface() {
            return this.stateInterface;
        }

        public AccumulatorStateSerializer<?> getSerializer() {
            return this.serializer;
        }

        public AccumulatorStateFactory<?> getFactory() {
            return this.factory;
        }
    }

    public static class ParameterMetadata {
        private final ParameterType parameterType;
        private final Type sqlType;

        public ParameterMetadata(ParameterType parameterType) {
            this(parameterType, null);
        }

        public ParameterMetadata(ParameterType parameterType, Type sqlType) {
            Preconditions.checkArgument((sqlType == null == (parameterType == ParameterType.BLOCK_INDEX || parameterType == ParameterType.STATE) ? 1 : 0) != 0, (Object)"sqlType must be provided only for input channels");
            this.parameterType = parameterType;
            this.sqlType = sqlType;
        }

        public static ParameterMetadata fromSqlType(Type sqlType, boolean isBlock, boolean isNullable, String methodName) {
            return new ParameterMetadata(ParameterType.inputChannelParameterType(isNullable, isBlock, methodName), sqlType);
        }

        public static ParameterMetadata forBlockIndexParameter() {
            return new ParameterMetadata(ParameterType.BLOCK_INDEX);
        }

        public static ParameterMetadata forStateParameter() {
            return new ParameterMetadata(ParameterType.STATE);
        }

        public ParameterType getParameterType() {
            return this.parameterType;
        }

        public Type getSqlType() {
            return this.sqlType;
        }

        public static enum ParameterType {
            INPUT_CHANNEL,
            BLOCK_INPUT_CHANNEL,
            NULLABLE_BLOCK_INPUT_CHANNEL,
            BLOCK_INDEX,
            STATE;


            static ParameterType inputChannelParameterType(boolean isNullable, boolean isBlock, String methodName) {
                if (isBlock) {
                    if (isNullable) {
                        return NULLABLE_BLOCK_INPUT_CHANNEL;
                    }
                    return BLOCK_INPUT_CHANNEL;
                }
                if (isNullable) {
                    throw new IllegalArgumentException(methodName + " contains a parameter with @NullablePosition that is not @BlockPosition");
                }
                return INPUT_CHANNEL;
            }
        }
    }
}

