/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import io.airlift.stats.QuantileDigest;
import io.prestosql.operator.aggregation.ApproximateLongPercentileArrayAggregations;
import io.prestosql.operator.aggregation.FloatingPointBitsConverterUtil;
import io.prestosql.operator.aggregation.state.DigestAndPercentileArrayState;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AggregationFunction;
import io.prestosql.spi.function.AggregationState;
import io.prestosql.spi.function.CombineFunction;
import io.prestosql.spi.function.InputFunction;
import io.prestosql.spi.function.OutputFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DoubleType;
import java.util.List;

@AggregationFunction(value="approx_percentile")
public final class ApproximateDoublePercentileArrayAggregations {
    private ApproximateDoublePercentileArrayAggregations() {
    }

    @InputFunction
    public static void input(@AggregationState DigestAndPercentileArrayState state, @SqlType(value="double") double value, @SqlType(value="array(double)") Block percentilesArrayBlock) {
        ApproximateLongPercentileArrayAggregations.input(state, FloatingPointBitsConverterUtil.doubleToSortableLong(value), percentilesArrayBlock);
    }

    @InputFunction
    public static void weightedInput(@AggregationState DigestAndPercentileArrayState state, @SqlType(value="double") double value, @SqlType(value="bigint") long weight, @SqlType(value="array(double)") Block percentilesArrayBlock) {
        ApproximateLongPercentileArrayAggregations.weightedInput(state, FloatingPointBitsConverterUtil.doubleToSortableLong(value), weight, percentilesArrayBlock);
    }

    @CombineFunction
    public static void combine(@AggregationState DigestAndPercentileArrayState state, DigestAndPercentileArrayState otherState) {
        ApproximateLongPercentileArrayAggregations.combine(state, otherState);
    }

    @OutputFunction(value="array(double)")
    public static void output(@AggregationState DigestAndPercentileArrayState state, BlockBuilder out) {
        QuantileDigest digest = state.getDigest();
        List<Double> percentiles = state.getPercentiles();
        if (percentiles == null || digest == null) {
            out.appendNull();
            return;
        }
        BlockBuilder blockBuilder = out.beginBlockEntry();
        for (int i = 0; i < percentiles.size(); ++i) {
            Double percentile = percentiles.get(i);
            DoubleType.DOUBLE.writeDouble(blockBuilder, FloatingPointBitsConverterUtil.sortableLongToDouble(digest.getQuantile(percentile.doubleValue())));
        }
        out.closeEntry();
    }
}

