/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.base.Preconditions;
import io.airlift.stats.QuantileDigest;
import io.prestosql.operator.aggregation.ApproximateLongPercentileAggregations;
import io.prestosql.operator.aggregation.FloatingPointBitsConverterUtil;
import io.prestosql.operator.aggregation.state.DigestAndPercentileState;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AggregationFunction;
import io.prestosql.spi.function.AggregationState;
import io.prestosql.spi.function.CombineFunction;
import io.prestosql.spi.function.InputFunction;
import io.prestosql.spi.function.OutputFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.RealType;
import io.prestosql.util.Failures;

@AggregationFunction(value="approx_percentile")
public class ApproximateRealPercentileAggregations {
    private ApproximateRealPercentileAggregations() {
    }

    @InputFunction
    public static void input(@AggregationState DigestAndPercentileState state, @SqlType(value="real") long value, @SqlType(value="double") double percentile) {
        ApproximateLongPercentileAggregations.input(state, FloatingPointBitsConverterUtil.floatToSortableInt(Float.intBitsToFloat((int)value)), percentile);
    }

    @InputFunction
    public static void weightedInput(@AggregationState DigestAndPercentileState state, @SqlType(value="real") long value, @SqlType(value="bigint") long weight, @SqlType(value="double") double percentile) {
        ApproximateLongPercentileAggregations.weightedInput(state, FloatingPointBitsConverterUtil.floatToSortableInt(Float.intBitsToFloat((int)value)), weight, percentile);
    }

    @InputFunction
    public static void weightedInput(@AggregationState DigestAndPercentileState state, @SqlType(value="real") long value, @SqlType(value="bigint") long weight, @SqlType(value="double") double percentile, @SqlType(value="double") double accuracy) {
        ApproximateLongPercentileAggregations.weightedInput(state, FloatingPointBitsConverterUtil.floatToSortableInt(Float.intBitsToFloat((int)value)), weight, percentile, accuracy);
    }

    @CombineFunction
    public static void combine(@AggregationState DigestAndPercentileState state, @AggregationState DigestAndPercentileState otherState) {
        ApproximateLongPercentileAggregations.combine(state, otherState);
    }

    @OutputFunction(value="real")
    public static void output(@AggregationState DigestAndPercentileState state, BlockBuilder out) {
        QuantileDigest digest = state.getDigest();
        double percentile = state.getPercentile();
        if (digest == null || digest.getCount() == 0.0) {
            out.appendNull();
        } else {
            Preconditions.checkState((percentile != -1.0 ? 1 : 0) != 0, (Object)"Percentile is missing");
            Failures.checkCondition(0.0 <= percentile && percentile <= 1.0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Percentile must be between 0 and 1", new Object[0]);
            RealType.REAL.writeLong(out, (long)Float.floatToRawIntBits(FloatingPointBitsConverterUtil.sortableIntToFloat((int)digest.getQuantile(percentile))));
        }
    }
}

