/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import io.prestosql.operator.aggregation.AggregationUtils;
import io.prestosql.operator.aggregation.state.RegressionState;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AggregationFunction;
import io.prestosql.spi.function.AggregationState;
import io.prestosql.spi.function.CombineFunction;
import io.prestosql.spi.function.InputFunction;
import io.prestosql.spi.function.OutputFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DoubleType;

@AggregationFunction
public class DoubleRegressionAggregation {
    private DoubleRegressionAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState RegressionState state, @SqlType(value="double") double dependentValue, @SqlType(value="double") double independentValue) {
        AggregationUtils.updateRegressionState(state, independentValue, dependentValue);
    }

    @CombineFunction
    public static void combine(@AggregationState RegressionState state, @AggregationState RegressionState otherState) {
        AggregationUtils.mergeRegressionState(state, otherState);
    }

    @AggregationFunction(value="regr_slope")
    @OutputFunction(value="double")
    public static void regrSlope(@AggregationState RegressionState state, BlockBuilder out) {
        double result = AggregationUtils.getRegressionSlope(state);
        if (Double.isFinite(result)) {
            DoubleType.DOUBLE.writeDouble(out, result);
        } else {
            out.appendNull();
        }
    }

    @AggregationFunction(value="regr_intercept")
    @OutputFunction(value="double")
    public static void regrIntercept(@AggregationState RegressionState state, BlockBuilder out) {
        double result = AggregationUtils.getRegressionIntercept(state);
        if (Double.isFinite(result)) {
            DoubleType.DOUBLE.writeDouble(out, result);
        } else {
            out.appendNull();
        }
    }
}

