/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import io.prestosql.operator.aggregation.state.NullableDoubleState;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AggregationFunction;
import io.prestosql.spi.function.AggregationState;
import io.prestosql.spi.function.CombineFunction;
import io.prestosql.spi.function.InputFunction;
import io.prestosql.spi.function.OutputFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.Type;

@AggregationFunction(value="sum")
public final class DoubleSumAggregation {
    private DoubleSumAggregation() {
    }

    @InputFunction
    public static void sum(@AggregationState NullableDoubleState state, @SqlType(value="double") double value) {
        state.setNull(false);
        state.setDouble(state.getDouble() + value);
    }

    @CombineFunction
    public static void combine(@AggregationState NullableDoubleState state, @AggregationState NullableDoubleState otherState) {
        if (state.isNull()) {
            state.setNull(false);
            state.setDouble(otherState.getDouble());
            return;
        }
        state.setDouble(state.getDouble() + otherState.getDouble());
    }

    @OutputFunction(value="double")
    public static void output(@AggregationState NullableDoubleState state, BlockBuilder out) {
        NullableDoubleState.write((Type)DoubleType.DOUBLE, state, out);
    }
}

