/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.annotations.VisibleForTesting;
import io.prestosql.Session;
import io.prestosql.operator.PagesIndex;
import io.prestosql.operator.aggregation.Accumulator;
import io.prestosql.operator.aggregation.AccumulatorFactory;
import io.prestosql.operator.aggregation.AccumulatorFactoryBinder;
import io.prestosql.operator.aggregation.AggregationMetadata;
import io.prestosql.operator.aggregation.GenericAccumulatorFactory;
import io.prestosql.operator.aggregation.GroupedAccumulator;
import io.prestosql.operator.aggregation.LambdaProvider;
import io.prestosql.spi.block.SortOrder;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.gen.JoinCompiler;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class GenericAccumulatorFactoryBinder
implements AccumulatorFactoryBinder {
    private final List<AggregationMetadata.AccumulatorStateDescriptor> stateDescriptors;
    private final Constructor<? extends Accumulator> accumulatorConstructor;
    private final Constructor<? extends GroupedAccumulator> groupedAccumulatorConstructor;

    public GenericAccumulatorFactoryBinder(List<AggregationMetadata.AccumulatorStateDescriptor> stateDescriptors, Class<? extends Accumulator> accumulatorClass, Class<? extends GroupedAccumulator> groupedAccumulatorClass) {
        this.stateDescriptors = Objects.requireNonNull(stateDescriptors, "stateDescriptors is null");
        try {
            this.accumulatorConstructor = accumulatorClass.getConstructor(List.class, List.class, Optional.class, List.class);
            this.groupedAccumulatorConstructor = groupedAccumulatorClass.getConstructor(List.class, List.class, Optional.class, List.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public AccumulatorFactory bind(List<Integer> argumentChannels, Optional<Integer> maskChannel, List<Type> sourceTypes, List<Integer> orderByChannels, List<SortOrder> orderings, PagesIndex.Factory pagesIndexFactory, boolean distinct, JoinCompiler joinCompiler, List<LambdaProvider> lambdaProviders, Session session) {
        return new GenericAccumulatorFactory(this.stateDescriptors, this.accumulatorConstructor, this.groupedAccumulatorConstructor, lambdaProviders, argumentChannels, maskChannel, sourceTypes, orderByChannels, orderings, pagesIndexFactory, joinCompiler, session, distinct);
    }

    @VisibleForTesting
    public List<AggregationMetadata.AccumulatorStateDescriptor> getStateDescriptors() {
        return this.stateDescriptors;
    }
}

