/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.DynamicClassLoader;
import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SignatureBinder;
import io.prestosql.metadata.SqlAggregationFunction;
import io.prestosql.operator.ParametricFunctionHelpers;
import io.prestosql.operator.ParametricImplementationsGroup;
import io.prestosql.operator.aggregation.AggregationHeader;
import io.prestosql.operator.aggregation.AggregationImplementation;
import io.prestosql.operator.aggregation.AggregationMetadata;
import io.prestosql.operator.aggregation.AggregationUtils;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.operator.aggregation.LazyAccumulatorFactoryBinder;
import io.prestosql.operator.aggregation.state.StateCompiler;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.AccumulatorStateFactory;
import io.prestosql.spi.function.AccumulatorStateSerializer;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeSignature;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ParametricAggregation
extends SqlAggregationFunction {
    private final AggregationHeader details;
    private final ParametricImplementationsGroup<AggregationImplementation> implementations;

    public ParametricAggregation(Signature signature, AggregationHeader details, ParametricImplementationsGroup<AggregationImplementation> implementations) {
        super(signature, details.isHidden());
        this.details = Objects.requireNonNull(details, "details is null");
        this.implementations = Objects.requireNonNull(implementations, "implementations is null");
    }

    @Override
    public InternalAggregationFunction specialize(BoundVariables variables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Signature boundSignature = SignatureBinder.applyBoundVariables(this.getSignature(), variables, arity);
        AggregationImplementation concreteImplementation = this.findMatchingImplementation(boundSignature, variables, typeManager, functionRegistry);
        List inputTypes = (List)boundSignature.getArgumentTypes().stream().map(arg_0 -> ((TypeManager)typeManager).getType(arg_0)).collect(ImmutableList.toImmutableList());
        Type outputType = typeManager.getType(boundSignature.getReturnType());
        Class<?> definitionClass = concreteImplementation.getDefinitionClass();
        DynamicClassLoader classLoader = new DynamicClassLoader(definitionClass.getClassLoader(), this.getClass().getClassLoader());
        Class<?> stateClass = concreteImplementation.getStateClass();
        AccumulatorStateSerializer<?> stateSerializer = ParametricAggregation.getAccumulatorStateSerializer(concreteImplementation, variables, typeManager, functionRegistry, stateClass, classLoader);
        AccumulatorStateFactory<?> stateFactory = StateCompiler.generateStateFactory(stateClass, classLoader);
        MethodHandle inputHandle = ParametricFunctionHelpers.bindDependencies(concreteImplementation.getInputFunction(), concreteImplementation.getInputDependencies(), variables, typeManager, functionRegistry);
        MethodHandle combineHandle = ParametricFunctionHelpers.bindDependencies(concreteImplementation.getCombineFunction(), concreteImplementation.getCombineDependencies(), variables, typeManager, functionRegistry);
        MethodHandle outputHandle = ParametricFunctionHelpers.bindDependencies(concreteImplementation.getOutputFunction(), concreteImplementation.getOutputDependencies(), variables, typeManager, functionRegistry);
        List<AggregationMetadata.ParameterMetadata> parametersMetadata = ParametricAggregation.buildParameterMetadata(concreteImplementation.getInputParameterMetadataTypes(), inputTypes);
        String aggregationName = AggregationUtils.generateAggregationName(this.getSignature().getName(), outputType.getTypeSignature(), ParametricAggregation.signaturesFromTypes(inputTypes));
        AggregationMetadata metadata = new AggregationMetadata(aggregationName, parametersMetadata, inputHandle, combineHandle, outputHandle, (List<AggregationMetadata.AccumulatorStateDescriptor>)ImmutableList.of((Object)new AggregationMetadata.AccumulatorStateDescriptor(stateClass, stateSerializer, stateFactory)), outputType);
        return new InternalAggregationFunction(this.getSignature().getName(), inputTypes, (List<Type>)ImmutableList.of((Object)stateSerializer.getSerializedType()), outputType, this.details.isDecomposable(), this.details.isOrderSensitive(), new LazyAccumulatorFactoryBinder(metadata, classLoader));
    }

    @VisibleForTesting
    public ParametricImplementationsGroup<AggregationImplementation> getImplementations() {
        return this.implementations;
    }

    @Override
    public String getDescription() {
        return this.details.getDescription().orElse("");
    }

    private AggregationImplementation findMatchingImplementation(Signature boundSignature, BoundVariables variables, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Optional<Object> foundImplementation = Optional.empty();
        if (this.implementations.getExactImplementations().containsKey(boundSignature)) {
            foundImplementation = Optional.of(this.implementations.getExactImplementations().get(boundSignature));
        } else {
            for (AggregationImplementation candidate : this.implementations.getGenericImplementations()) {
                if (!candidate.areTypesAssignable(boundSignature, variables, typeManager, functionRegistry)) continue;
                if (foundImplementation.isPresent()) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_FUNCTION_CALL, String.format("Ambiguous function call (%s) for %s", variables, this.getSignature()));
                }
                foundImplementation = Optional.of(candidate);
            }
        }
        if (!foundImplementation.isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_MISSING, String.format("Unsupported type parameters (%s) for %s", variables, this.getSignature()));
        }
        return (AggregationImplementation)foundImplementation.get();
    }

    private static AccumulatorStateSerializer<?> getAccumulatorStateSerializer(AggregationImplementation implementation, BoundVariables variables, TypeManager typeManager, FunctionRegistry functionRegistry, Class<?> stateClass, DynamicClassLoader classLoader) {
        AccumulatorStateSerializer stateSerializer;
        Optional<MethodHandle> stateSerializerFactory = implementation.getStateSerializerFactory();
        if (stateSerializerFactory.isPresent()) {
            try {
                MethodHandle factoryHandle = ParametricFunctionHelpers.bindDependencies(stateSerializerFactory.get(), implementation.getStateSerializerFactoryDependencies(), variables, typeManager, functionRegistry);
                stateSerializer = factoryHandle.invoke();
            }
            catch (Throwable t) {
                Throwables.throwIfUnchecked((Throwable)t);
                throw new RuntimeException(t);
            }
        } else {
            stateSerializer = StateCompiler.generateStateSerializer(stateClass, classLoader);
        }
        return stateSerializer;
    }

    public InternalAggregationFunction specialize(BoundVariables variables, int arity, TypeManager typeManager) {
        return this.specialize(variables, arity, typeManager, null);
    }

    private static List<TypeSignature> signaturesFromTypes(List<Type> types) {
        return (List)types.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList());
    }

    private static List<AggregationMetadata.ParameterMetadata> buildParameterMetadata(List<AggregationMetadata.ParameterMetadata.ParameterType> parameterMetadataTypes, List<Type> inputTypes) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int inputId = 0;
        for (AggregationMetadata.ParameterMetadata.ParameterType parameterMetadataType : parameterMetadataTypes) {
            switch (parameterMetadataType) {
                case STATE: 
                case BLOCK_INDEX: {
                    builder.add((Object)new AggregationMetadata.ParameterMetadata(parameterMetadataType));
                    break;
                }
                case INPUT_CHANNEL: 
                case BLOCK_INPUT_CHANNEL: 
                case NULLABLE_BLOCK_INPUT_CHANNEL: {
                    builder.add((Object)new AggregationMetadata.ParameterMetadata(parameterMetadataType, inputTypes.get(inputId++)));
                }
            }
        }
        return builder.build();
    }
}

