/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.DynamicClassLoader;
import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.SqlAggregationFunction;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.aggregation.AccumulatorCompiler;
import io.prestosql.operator.aggregation.AggregationMetadata;
import io.prestosql.operator.aggregation.AggregationUtils;
import io.prestosql.operator.aggregation.AverageAggregations;
import io.prestosql.operator.aggregation.GenericAccumulatorFactoryBinder;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.operator.aggregation.state.DoubleState;
import io.prestosql.operator.aggregation.state.LongState;
import io.prestosql.operator.aggregation.state.StateCompiler;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AccumulatorStateSerializer;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class RealAverageAggregation
extends SqlAggregationFunction {
    public static final RealAverageAggregation REAL_AVERAGE_AGGREGATION = new RealAverageAggregation();
    private static final String NAME = "avg";
    private static final MethodHandle INPUT_FUNCTION = Reflection.methodHandle(RealAverageAggregation.class, "input", LongState.class, DoubleState.class, Long.TYPE);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(RealAverageAggregation.class, "combine", LongState.class, DoubleState.class, LongState.class, DoubleState.class);
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(RealAverageAggregation.class, "output", LongState.class, DoubleState.class, BlockBuilder.class);

    protected RealAverageAggregation() {
        super(NAME, (List<TypeVariableConstraint>)ImmutableList.of(), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"real"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"real")));
    }

    @Override
    public String getDescription() {
        return "Returns the average value of the argument";
    }

    @Override
    public InternalAggregationFunction specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        DynamicClassLoader classLoader = new DynamicClassLoader(AverageAggregations.class.getClassLoader());
        Class<LongState> longStateInterface = LongState.class;
        Class<DoubleState> doubleStateInterface = DoubleState.class;
        AccumulatorStateSerializer<LongState> longStateSerializer = StateCompiler.generateStateSerializer(longStateInterface, classLoader);
        AccumulatorStateSerializer<DoubleState> doubleStateSerializer = StateCompiler.generateStateSerializer(doubleStateInterface, classLoader);
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(NAME, TypeSignature.parseTypeSignature((String)"real"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"real"))), (List<AggregationMetadata.ParameterMetadata>)ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL, (Type)RealType.REAL)), INPUT_FUNCTION, COMBINE_FUNCTION, OUTPUT_FUNCTION, (List<AggregationMetadata.AccumulatorStateDescriptor>)ImmutableList.of((Object)new AggregationMetadata.AccumulatorStateDescriptor(longStateInterface, longStateSerializer, StateCompiler.generateStateFactory(longStateInterface, classLoader)), (Object)new AggregationMetadata.AccumulatorStateDescriptor(doubleStateInterface, doubleStateSerializer, StateCompiler.generateStateFactory(doubleStateInterface, classLoader))), (Type)RealType.REAL);
        GenericAccumulatorFactoryBinder factory = AccumulatorCompiler.generateAccumulatorFactoryBinder(metadata, classLoader);
        return new InternalAggregationFunction(NAME, (List<Type>)ImmutableList.of((Object)RealType.REAL), (List<Type>)ImmutableList.of((Object)longStateSerializer.getSerializedType(), (Object)doubleStateSerializer.getSerializedType()), (Type)RealType.REAL, true, false, factory);
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type value) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL, value), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
    }

    public static void input(LongState count, DoubleState sum, long value) {
        count.setLong(count.getLong() + 1L);
        sum.setDouble(sum.getDouble() + (double)Float.intBitsToFloat((int)value));
    }

    public static void combine(LongState count, DoubleState sum, LongState otherCount, DoubleState otherSum) {
        count.setLong(count.getLong() + otherCount.getLong());
        sum.setDouble(sum.getDouble() + otherSum.getDouble());
    }

    public static void output(LongState count, DoubleState sum, BlockBuilder out) {
        if (count.getLong() == 0L) {
            out.appendNull();
        } else {
            RealType.REAL.writeLong(out, (long)Float.floatToIntBits((float)(sum.getDouble() / (double)count.getLong())));
        }
    }
}

