/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import io.prestosql.operator.aggregation.AggregationUtils;
import io.prestosql.operator.aggregation.DoubleCorrelationAggregation;
import io.prestosql.operator.aggregation.state.CorrelationState;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AggregationFunction;
import io.prestosql.spi.function.AggregationState;
import io.prestosql.spi.function.CombineFunction;
import io.prestosql.spi.function.InputFunction;
import io.prestosql.spi.function.OutputFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.RealType;

@AggregationFunction(value="corr")
public class RealCorrelationAggregation {
    private RealCorrelationAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState CorrelationState state, @SqlType(value="real") long dependentValue, @SqlType(value="real") long independentValue) {
        DoubleCorrelationAggregation.input(state, Float.intBitsToFloat((int)dependentValue), Float.intBitsToFloat((int)independentValue));
    }

    @CombineFunction
    public static void combine(@AggregationState CorrelationState state, @AggregationState CorrelationState otherState) {
        DoubleCorrelationAggregation.combine(state, otherState);
    }

    @OutputFunction(value="real")
    public static void corr(@AggregationState CorrelationState state, BlockBuilder out) {
        double result = AggregationUtils.getCorrelation(state);
        if (Double.isFinite(result)) {
            long resultBits = Float.floatToRawIntBits((float)result);
            RealType.REAL.writeLong(out, resultBits);
        } else {
            out.appendNull();
        }
    }
}

