/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import io.prestosql.operator.aggregation.AggregationUtils;
import io.prestosql.operator.aggregation.DoubleCovarianceAggregation;
import io.prestosql.operator.aggregation.state.CovarianceState;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AggregationFunction;
import io.prestosql.spi.function.AggregationState;
import io.prestosql.spi.function.CombineFunction;
import io.prestosql.spi.function.InputFunction;
import io.prestosql.spi.function.OutputFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.RealType;

@AggregationFunction
public class RealCovarianceAggregation {
    private RealCovarianceAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState CovarianceState state, @SqlType(value="real") long dependentValue, @SqlType(value="real") long independentValue) {
        DoubleCovarianceAggregation.input(state, Float.intBitsToFloat((int)dependentValue), Float.intBitsToFloat((int)independentValue));
    }

    @CombineFunction
    public static void combine(@AggregationState CovarianceState state, @AggregationState CovarianceState otherState) {
        DoubleCovarianceAggregation.combine(state, otherState);
    }

    @AggregationFunction(value="covar_samp")
    @OutputFunction(value="real")
    public static void covarSamp(@AggregationState CovarianceState state, BlockBuilder out) {
        if (state.getCount() <= 1L) {
            out.appendNull();
        } else {
            double result = AggregationUtils.getCovarianceSample(state);
            RealType.REAL.writeLong(out, (long)Float.floatToRawIntBits((float)result));
        }
    }

    @AggregationFunction(value="covar_pop")
    @OutputFunction(value="real")
    public static void covarPop(@AggregationState CovarianceState state, BlockBuilder out) {
        if (state.getCount() == 0L) {
            out.appendNull();
        } else {
            double result = AggregationUtils.getCovariancePopulation(state);
            RealType.REAL.writeLong(out, (long)Float.floatToRawIntBits((float)result));
        }
    }
}

