/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation.minmaxby;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.prestosql.operator.aggregation.minmaxby.BlockAndBlockPositionStateSerializer;
import io.prestosql.operator.aggregation.minmaxby.BlockAndBlockPositionValueState;
import io.prestosql.operator.aggregation.minmaxby.BlockBooleanState;
import io.prestosql.operator.aggregation.minmaxby.BlockDoubleState;
import io.prestosql.operator.aggregation.minmaxby.BlockLongState;
import io.prestosql.operator.aggregation.minmaxby.BooleanAndBlockPositionStateSerializer;
import io.prestosql.operator.aggregation.minmaxby.BooleanAndBlockPositionValueState;
import io.prestosql.operator.aggregation.minmaxby.BooleanBooleanState;
import io.prestosql.operator.aggregation.minmaxby.BooleanDoubleState;
import io.prestosql.operator.aggregation.minmaxby.BooleanLongState;
import io.prestosql.operator.aggregation.minmaxby.DoubleAndBlockPositionStateSerializer;
import io.prestosql.operator.aggregation.minmaxby.DoubleAndBlockPositionValueState;
import io.prestosql.operator.aggregation.minmaxby.DoubleBooleanState;
import io.prestosql.operator.aggregation.minmaxby.DoubleDoubleState;
import io.prestosql.operator.aggregation.minmaxby.DoubleLongState;
import io.prestosql.operator.aggregation.minmaxby.LongAndBlockPositionStateSerializer;
import io.prestosql.operator.aggregation.minmaxby.LongAndBlockPositionValueState;
import io.prestosql.operator.aggregation.minmaxby.LongBooleanState;
import io.prestosql.operator.aggregation.minmaxby.LongDoubleState;
import io.prestosql.operator.aggregation.minmaxby.LongLongState;
import io.prestosql.operator.aggregation.minmaxby.SliceAndBlockPositionStateSerializer;
import io.prestosql.operator.aggregation.minmaxby.SliceAndBlockPositionValueState;
import io.prestosql.operator.aggregation.minmaxby.SliceBooleanState;
import io.prestosql.operator.aggregation.minmaxby.SliceDoubleState;
import io.prestosql.operator.aggregation.minmaxby.SliceLongState;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.AccumulatorState;
import io.prestosql.spi.function.AccumulatorStateSerializer;
import io.prestosql.spi.type.Type;
import java.util.List;
import java.util.Map;

public final class TwoNullableValueStateMapping {
    private static final Map<List<Class<?>>, Class<? extends AccumulatorState>> STATE_MAPPINGS = new ImmutableMap.Builder().put((Object)ImmutableList.of(Boolean.TYPE, Block.class), BooleanAndBlockPositionValueState.class).put((Object)ImmutableList.of(Boolean.TYPE, Boolean.TYPE), BooleanBooleanState.class).put((Object)ImmutableList.of(Boolean.TYPE, Double.TYPE), BooleanDoubleState.class).put((Object)ImmutableList.of(Boolean.TYPE, Long.TYPE), BooleanLongState.class).put((Object)ImmutableList.of(Boolean.TYPE, Slice.class), BooleanAndBlockPositionValueState.class).put((Object)ImmutableList.of(Double.TYPE, Boolean.TYPE), DoubleBooleanState.class).put((Object)ImmutableList.of(Double.TYPE, Block.class), DoubleAndBlockPositionValueState.class).put((Object)ImmutableList.of(Double.TYPE, Double.TYPE), DoubleDoubleState.class).put((Object)ImmutableList.of(Double.TYPE, Long.TYPE), DoubleLongState.class).put((Object)ImmutableList.of(Double.TYPE, Slice.class), DoubleAndBlockPositionValueState.class).put((Object)ImmutableList.of(Long.TYPE, Block.class), LongAndBlockPositionValueState.class).put((Object)ImmutableList.of(Long.TYPE, Boolean.TYPE), LongBooleanState.class).put((Object)ImmutableList.of(Long.TYPE, Double.TYPE), LongDoubleState.class).put((Object)ImmutableList.of(Long.TYPE, Long.TYPE), LongLongState.class).put((Object)ImmutableList.of(Long.TYPE, Slice.class), LongAndBlockPositionValueState.class).put((Object)ImmutableList.of(Slice.class, Boolean.TYPE), SliceBooleanState.class).put((Object)ImmutableList.of(Slice.class, Block.class), SliceAndBlockPositionValueState.class).put((Object)ImmutableList.of(Slice.class, Double.TYPE), SliceDoubleState.class).put((Object)ImmutableList.of(Slice.class, Long.TYPE), SliceLongState.class).put((Object)ImmutableList.of(Slice.class, Slice.class), SliceAndBlockPositionValueState.class).put((Object)ImmutableList.of(Block.class, Boolean.TYPE), BlockBooleanState.class).put((Object)ImmutableList.of(Block.class, Block.class), BlockAndBlockPositionValueState.class).put((Object)ImmutableList.of(Block.class, Double.TYPE), BlockDoubleState.class).put((Object)ImmutableList.of(Block.class, Long.TYPE), BlockLongState.class).put((Object)ImmutableList.of(Block.class, Slice.class), BlockAndBlockPositionValueState.class).build();

    private TwoNullableValueStateMapping() {
    }

    public static Class<? extends AccumulatorState> getStateClass(Class<?> first, Class<?> second) {
        ImmutableList key = ImmutableList.of(first, second);
        Class<? extends AccumulatorState> state = STATE_MAPPINGS.get(key);
        Preconditions.checkArgument((state != null ? 1 : 0) != 0, (String)"Unsupported state type combination: (%s, %s)", (Object)first.getName(), (Object)second.getName());
        return state;
    }

    public static AccumulatorStateSerializer<?> getStateSerializer(Type firstType, Type secondType) {
        Class firstJavaType = firstType.getJavaType();
        Class secondJavaType = secondType.getJavaType();
        if (secondJavaType != Block.class && secondJavaType != Slice.class) {
            throw new IllegalArgumentException(String.format("Unsupported state type combination: (%s, %s)", firstJavaType.getName(), secondJavaType.getName()));
        }
        if (firstJavaType == Boolean.TYPE) {
            return new BooleanAndBlockPositionStateSerializer(firstType, secondType);
        }
        if (firstJavaType == Long.TYPE) {
            return new LongAndBlockPositionStateSerializer(firstType, secondType);
        }
        if (firstJavaType == Double.TYPE) {
            return new DoubleAndBlockPositionStateSerializer(firstType, secondType);
        }
        if (firstJavaType == Slice.class) {
            return new SliceAndBlockPositionStateSerializer(firstType, secondType);
        }
        if (firstJavaType == Block.class) {
            return new BlockAndBlockPositionStateSerializer(firstType, secondType);
        }
        throw new IllegalArgumentException(String.format("Unsupported state type combination: (%s, %s)", firstJavaType.getName(), secondJavaType.getName()));
    }
}

