/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.annotations;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.operator.annotations.FunctionImplementationDependency;
import io.prestosql.operator.annotations.FunctionsParserHelper;
import io.prestosql.operator.annotations.LiteralImplementationDependency;
import io.prestosql.operator.annotations.OperatorImplementationDependency;
import io.prestosql.operator.annotations.TypeImplementationDependency;
import io.prestosql.spi.function.Convention;
import io.prestosql.spi.function.FunctionDependency;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.OperatorDependency;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public interface ImplementationDependency {
    public Object resolve(BoundVariables var1, TypeManager var2, FunctionRegistry var3);

    public static boolean isImplementationDependencyAnnotation(Annotation annotation) {
        return annotation instanceof TypeParameter || annotation instanceof LiteralParameter || annotation instanceof FunctionDependency || annotation instanceof OperatorDependency;
    }

    public static Optional<Annotation> getImplementationDependencyAnnotation(AnnotatedElement element) {
        if (!FunctionsParserHelper.containsImplementationDependencyAnnotation(element.getAnnotations())) {
            return Optional.empty();
        }
        Annotation[] annotations = element.getAnnotations();
        Preconditions.checkArgument((annotations.length == 1 ? 1 : 0) != 0, (String)"Meta parameters may only have a single annotation [%s]", (Object)element);
        return Optional.of(annotations[0]);
    }

    public static void validateImplementationDependencyAnnotation(AnnotatedElement element, Annotation annotation, Set<String> typeParametersNames, Collection<String> literalParameters) {
        if (annotation instanceof TypeParameter) {
            ImplementationDependency.checkTypeParameters(TypeSignature.parseTypeSignature((String)((TypeParameter)annotation).value()), typeParametersNames, element);
        }
        if (annotation instanceof LiteralParameter) {
            Preconditions.checkArgument((boolean)literalParameters.contains(((LiteralParameter)annotation).value()), (String)"Parameter injected by @LiteralParameter must be declared with @LiteralParameters on the method [%s]", (Object)element);
        }
    }

    public static void checkTypeParameters(TypeSignature typeSignature, Set<String> typeParameterNames, AnnotatedElement element) {
        if (typeParameterNames.contains(typeSignature.getBase())) {
            Preconditions.checkArgument((boolean)typeSignature.getParameters().isEmpty(), (String)"Expected type parameter not to take parameters, but got %s on method [%s]", (Object)typeSignature.getBase(), (Object)element);
            return;
        }
        for (TypeSignatureParameter parameter : typeSignature.getParameters()) {
            Optional childTypeSignature = parameter.getTypeSignatureOrNamedTypeSignature();
            if (!childTypeSignature.isPresent()) continue;
            ImplementationDependency.checkTypeParameters((TypeSignature)childTypeSignature.get(), typeParameterNames, element);
        }
    }

    public static class Factory {
        private Factory() {
        }

        public static ImplementationDependency createDependency(Annotation annotation, Set<String> literalParameters) {
            if (annotation instanceof TypeParameter) {
                return new TypeImplementationDependency(((TypeParameter)annotation).value());
            }
            if (annotation instanceof LiteralParameter) {
                return new LiteralImplementationDependency(((LiteralParameter)annotation).value());
            }
            if (annotation instanceof FunctionDependency) {
                FunctionDependency functionDependency = (FunctionDependency)annotation;
                return new FunctionImplementationDependency(functionDependency.name(), TypeSignature.parseTypeSignature((String)functionDependency.returnType(), literalParameters), (List)Arrays.stream(functionDependency.argumentTypes()).map(signature -> TypeSignature.parseTypeSignature((String)signature, (Set)literalParameters)).collect(ImmutableList.toImmutableList()), Factory.toInvocationConvention(functionDependency.convention()));
            }
            if (annotation instanceof OperatorDependency) {
                OperatorDependency operatorDependency = (OperatorDependency)annotation;
                return new OperatorImplementationDependency(operatorDependency.operator(), TypeSignature.parseTypeSignature((String)operatorDependency.returnType(), literalParameters), (List)Arrays.stream(operatorDependency.argumentTypes()).map(signature -> TypeSignature.parseTypeSignature((String)signature, (Set)literalParameters)).collect(ImmutableList.toImmutableList()), Factory.toInvocationConvention(operatorDependency.convention()));
            }
            throw new IllegalArgumentException("Unsupported annotation " + annotation.getClass().getSimpleName());
        }

        private static Optional<InvocationConvention> toInvocationConvention(Convention convention) {
            if (convention.$notSpecified()) {
                return Optional.empty();
            }
            ArrayList argumentConventions = new ArrayList();
            Collections.addAll(argumentConventions, convention.arguments());
            return Optional.of(new InvocationConvention(argumentConventions, convention.result(), convention.session()));
        }
    }
}

