/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.annotations;

import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SignatureBinder;
import io.prestosql.operator.annotations.ImplementationDependency;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.type.TypeManager;
import java.lang.invoke.MethodHandle;
import java.util.Objects;
import java.util.Optional;

public abstract class ScalarImplementationDependency
implements ImplementationDependency {
    private final Signature signature;
    private final Optional<InvocationConvention> invocationConvention;

    protected ScalarImplementationDependency(Signature signature, Optional<InvocationConvention> invocationConvention) {
        this.signature = Objects.requireNonNull(signature, "signature is null");
        this.invocationConvention = invocationConvention;
    }

    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public MethodHandle resolve(BoundVariables boundVariables, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Signature signature = SignatureBinder.applyBoundVariables(this.signature, boundVariables, this.signature.getArgumentTypes().size());
        if (this.invocationConvention.isPresent()) {
            return functionRegistry.getFunctionInvokerProvider().createFunctionInvoker(signature, this.invocationConvention).methodHandle();
        }
        return functionRegistry.getScalarFunctionImplementation(signature).getMethodHandle();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScalarImplementationDependency that = (ScalarImplementationDependency)o;
        return Objects.equals(this.signature, that.signature) && Objects.equals(this.invocationConvention, that.invocationConvention);
    }

    public int hashCode() {
        return Objects.hash(this.signature, this.invocationConvention);
    }
}

