/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.index;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.units.DataSize;
import io.prestosql.operator.FilterAndProjectOperator;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.index.TuplePageFilter;
import io.prestosql.operator.project.PageProcessor;
import io.prestosql.operator.project.PageProjection;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.gen.PageFunctionCompiler;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.relational.Expressions;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Supplier;
import java.util.stream.IntStream;

public class DynamicTupleFilterFactory {
    private final int filterOperatorId;
    private final PlanNodeId planNodeId;
    private final int[] tupleFilterChannels;
    private final List<Integer> outputFilterChannels;
    private final List<Type> filterTypes;
    private final List<Type> outputTypes;
    private final List<Supplier<PageProjection>> outputProjections;

    public DynamicTupleFilterFactory(int filterOperatorId, PlanNodeId planNodeId, int[] tupleFilterChannels, int[] outputFilterChannels, List<Type> outputTypes, PageFunctionCompiler pageFunctionCompiler) {
        Objects.requireNonNull(planNodeId, "planNodeId is null");
        Objects.requireNonNull(tupleFilterChannels, "tupleFilterChannels is null");
        Preconditions.checkArgument((tupleFilterChannels.length > 0 ? 1 : 0) != 0, (Object)"Must have at least one tupleFilterChannel");
        Objects.requireNonNull(outputFilterChannels, "outputFilterChannels is null");
        Preconditions.checkArgument((outputFilterChannels.length == tupleFilterChannels.length ? 1 : 0) != 0, (Object)"outputFilterChannels must have same length as tupleFilterChannels");
        Objects.requireNonNull(outputTypes, "outputTypes is null");
        Preconditions.checkArgument((outputTypes.size() >= outputFilterChannels.length ? 1 : 0) != 0, (Object)"Must have at least as many output channels as those used for filtering");
        Objects.requireNonNull(pageFunctionCompiler, "pageFunctionCompiler is null");
        this.filterOperatorId = filterOperatorId;
        this.planNodeId = planNodeId;
        this.tupleFilterChannels = (int[])tupleFilterChannels.clone();
        this.outputFilterChannels = ImmutableList.copyOf((Collection)Ints.asList((int[])outputFilterChannels));
        this.filterTypes = (List)IntStream.of(outputFilterChannels).mapToObj(outputTypes::get).collect(ImmutableList.toImmutableList());
        this.outputTypes = ImmutableList.copyOf(outputTypes);
        this.outputProjections = (List)IntStream.range(0, outputTypes.size()).mapToObj(field -> pageFunctionCompiler.compileProjection(Expressions.field(field, (Type)outputTypes.get(field)), Optional.empty())).collect(ImmutableList.toImmutableList());
    }

    public OperatorFactory filterWithTuple(Page tuplePage) {
        Page filterTuple = this.getFilterTuple(tuplePage);
        Supplier<PageProcessor> processor = this.createPageProcessor(filterTuple, OptionalInt.empty());
        return new FilterAndProjectOperator.FilterAndProjectOperatorFactory(this.filterOperatorId, this.planNodeId, processor, this.outputTypes, new DataSize(0.0, DataSize.Unit.BYTE), 0);
    }

    @VisibleForTesting
    public Supplier<PageProcessor> createPageProcessor(Page filterTuple, OptionalInt initialBatchSize) {
        TuplePageFilter filter = new TuplePageFilter(filterTuple, this.filterTypes, this.outputFilterChannels);
        return () -> new PageProcessor(Optional.of(filter), (List)this.outputProjections.stream().map(Supplier::get).collect(ImmutableList.toImmutableList()), initialBatchSize);
    }

    private Page getFilterTuple(Page tuplePage) {
        Block[] normalizedBlocks = new Block[this.tupleFilterChannels.length];
        for (int i = 0; i < this.tupleFilterChannels.length; ++i) {
            normalizedBlocks[i] = tuplePage.getBlock(this.tupleFilterChannels[i]);
        }
        return new Page(normalizedBlocks);
    }
}

