/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.project;

import io.prestosql.operator.CompletedWork;
import io.prestosql.operator.DriverYieldSignal;
import io.prestosql.operator.Work;
import io.prestosql.operator.project.InputChannels;
import io.prestosql.operator.project.PageProjection;
import io.prestosql.operator.project.SelectedPositions;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.type.Type;
import java.util.Objects;

public class InputPageProjection
implements PageProjection {
    private final Type type;
    private final InputChannels inputChannels;

    public InputPageProjection(int inputChannel, Type type) {
        this.type = type;
        this.inputChannels = new InputChannels(inputChannel);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public InputChannels getInputChannels() {
        return this.inputChannels;
    }

    @Override
    public Work<Block> project(ConnectorSession session, DriverYieldSignal yieldSignal, Page page, SelectedPositions selectedPositions) {
        Block block = Objects.requireNonNull(page, "page is null").getBlock(0);
        Objects.requireNonNull(selectedPositions, "selectedPositions is null");
        Block result = selectedPositions.isList() ? block.copyPositions(selectedPositions.getPositions(), selectedPositions.getOffset(), selectedPositions.size()) : block.getRegion(selectedPositions.getOffset(), selectedPositions.size());
        return new CompletedWork<Block>(result);
    }
}

