/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.project;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.operator.WorkProcessor;
import io.prestosql.spi.Page;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.type.Type;
import java.util.List;
import java.util.Objects;

public class MergePages {
    private static final int MAX_MIN_PAGE_SIZE = 0x100000;

    private MergePages() {
    }

    public static WorkProcessor<Page> mergePages(Iterable<? extends Type> types, long minPageSizeInBytes, int minRowCount, WorkProcessor<Page> pages, AggregatedMemoryContext memoryContext) {
        return MergePages.mergePages(types, minPageSizeInBytes, minRowCount, 0x100000, pages, memoryContext);
    }

    public static WorkProcessor<Page> mergePages(Iterable<? extends Type> types, long minPageSizeInBytes, int minRowCount, int maxPageSizeInBytes, WorkProcessor<Page> pages, AggregatedMemoryContext memoryContext) {
        return pages.transform(new MergePagesTransformation(types, minPageSizeInBytes, minRowCount, maxPageSizeInBytes, memoryContext.newLocalMemoryContext(MergePages.class.getSimpleName())));
    }

    private static class MergePagesTransformation
    implements WorkProcessor.Transformation<Page, Page> {
        private final List<Type> types;
        private final long minPageSizeInBytes;
        private final int minRowCount;
        private final LocalMemoryContext memoryContext;
        private final PageBuilder pageBuilder;
        private Page queuedPage;

        private MergePagesTransformation(Iterable<? extends Type> types, long minPageSizeInBytes, int minRowCount, int maxPageSizeInBytes, LocalMemoryContext memoryContext) {
            this.types = ImmutableList.copyOf(Objects.requireNonNull(types, "types is null"));
            Preconditions.checkArgument((minPageSizeInBytes >= 0L ? 1 : 0) != 0, (Object)"minPageSizeInBytes must be greater or equal than zero");
            Preconditions.checkArgument((minRowCount >= 0 ? 1 : 0) != 0, (Object)"minRowCount must be greater or equal than zero");
            Preconditions.checkArgument((maxPageSizeInBytes > 0 ? 1 : 0) != 0, (Object)"maxPageSizeInBytes must be greater than zero");
            Preconditions.checkArgument(((long)maxPageSizeInBytes >= minPageSizeInBytes ? 1 : 0) != 0, (Object)"maxPageSizeInBytes must be greater or equal than minPageSizeInBytes");
            Preconditions.checkArgument((minPageSizeInBytes <= 0x100000L ? 1 : 0) != 0, (String)"minPageSizeInBytes must be less or equal than %d", (int)0x100000);
            this.minPageSizeInBytes = minPageSizeInBytes;
            this.minRowCount = minRowCount;
            this.memoryContext = Objects.requireNonNull(memoryContext, "memoryContext is null");
            this.pageBuilder = PageBuilder.withMaxPageSize((int)maxPageSizeInBytes, this.types);
        }

        @Override
        public WorkProcessor.TransformationState<Page> process(Page inputPage) {
            boolean inputFinished;
            if (this.queuedPage != null) {
                Page output = this.queuedPage;
                this.queuedPage = null;
                this.memoryContext.setBytes(this.pageBuilder.getRetainedSizeInBytes());
                return WorkProcessor.TransformationState.ofResult(output);
            }
            boolean bl = inputFinished = inputPage == null;
            if (inputFinished) {
                if (this.pageBuilder.isEmpty()) {
                    this.memoryContext.close();
                    return WorkProcessor.TransformationState.finished();
                }
                return WorkProcessor.TransformationState.ofResult(this.flush(), false);
            }
            if (inputPage.getPositionCount() >= this.minRowCount || inputPage.getSizeInBytes() >= this.minPageSizeInBytes) {
                if (this.pageBuilder.isEmpty()) {
                    return WorkProcessor.TransformationState.ofResult(inputPage);
                }
                Page output = this.pageBuilder.build();
                this.pageBuilder.reset();
                this.queuedPage = inputPage;
                this.memoryContext.setBytes(this.pageBuilder.getRetainedSizeInBytes() + inputPage.getRetainedSizeInBytes());
                return WorkProcessor.TransformationState.ofResult(output, false);
            }
            this.appendPage(inputPage);
            if (this.pageBuilder.isFull()) {
                return WorkProcessor.TransformationState.ofResult(this.flush());
            }
            this.memoryContext.setBytes(this.pageBuilder.getRetainedSizeInBytes());
            return WorkProcessor.TransformationState.needsMoreData();
        }

        private void appendPage(Page page) {
            this.pageBuilder.declarePositions(page.getPositionCount());
            for (int channel = 0; channel < this.types.size(); ++channel) {
                Type type = this.types.get(channel);
                for (int position = 0; position < page.getPositionCount(); ++position) {
                    type.appendTo(page.getBlock(channel), position, this.pageBuilder.getBlockBuilder(channel));
                }
            }
        }

        private Page flush() {
            Page output = this.pageBuilder.build();
            this.pageBuilder.reset();
            this.memoryContext.setBytes(this.pageBuilder.getRetainedSizeInBytes());
            return output;
        }
    }
}

