/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.BlockIndex;
import io.prestosql.spi.function.BlockPosition;
import io.prestosql.spi.function.Convention;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.function.IsNull;
import io.prestosql.spi.function.OperatorDependency;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.type.Type;
import io.prestosql.util.Failures;
import java.lang.invoke.MethodHandle;

@ScalarOperator(value=OperatorType.IS_DISTINCT_FROM)
public final class ArrayDistinctFromOperator {
    private ArrayDistinctFromOperator() {
    }

    @TypeParameter(value="E")
    @SqlType(value="boolean")
    public static boolean isDistinctFrom(@OperatorDependency(operator=OperatorType.IS_DISTINCT_FROM, returnType="boolean", argumentTypes={"E", "E"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle function, @SqlType(value="array(E)") Block left, @IsNull boolean leftNull, @SqlType(value="array(E)") Block right, @IsNull boolean rightNull) {
        if (leftNull != rightNull) {
            return true;
        }
        if (leftNull) {
            return false;
        }
        if (left.getPositionCount() != right.getPositionCount()) {
            return true;
        }
        for (int i = 0; i < left.getPositionCount(); ++i) {
            try {
                if (!function.invokeExact(left, i, right, i)) continue;
                return true;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return false;
    }

    @TypeParameter(value="E")
    @SqlType(value="boolean")
    public static boolean isDistinctFrom(@OperatorDependency(operator=OperatorType.IS_DISTINCT_FROM, returnType="boolean", argumentTypes={"E", "E"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle elementIsDistinctFrom, @TypeParameter(value="array(E)") Type type, @BlockPosition @SqlType(value="array(E)", nativeContainerType=Block.class) Block left, @BlockIndex int leftPosition, @BlockPosition @SqlType(value="array(E)", nativeContainerType=Block.class) Block right, @BlockIndex int rightPosition) {
        return ArrayDistinctFromOperator.isDistinctFrom(elementIsDistinctFrom, (Block)type.getObject(left, leftPosition), left.isNull(leftPosition), (Block)type.getObject(right, rightPosition), right.isNull(rightPosition));
    }
}

