/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.airlift.slice.Slice;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.function.TypeParameterSpecialization;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.gen.lambda.LambdaFunctionInterface;

@Description(value="return array containing elements that match the given predicate")
@ScalarFunction(value="filter", deterministic=false)
public final class ArrayFilterFunction {
    private ArrayFilterFunction() {
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=long.class)
    @SqlType(value="array(T)")
    public static Block filterLong(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") FilterLongLambda function) {
        int positionCount = arrayBlock.getPositionCount();
        BlockBuilder resultBuilder = elementType.createBlockBuilder(null, positionCount);
        for (int position = 0; position < positionCount; ++position) {
            Boolean keep;
            Long input = null;
            if (!arrayBlock.isNull(position)) {
                input = elementType.getLong(arrayBlock, position);
            }
            if (!Boolean.TRUE.equals(keep = function.apply(input))) continue;
            elementType.appendTo(arrayBlock, position, resultBuilder);
        }
        return resultBuilder.build();
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=double.class)
    @SqlType(value="array(T)")
    public static Block filterDouble(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") FilterDoubleLambda function) {
        int positionCount = arrayBlock.getPositionCount();
        BlockBuilder resultBuilder = elementType.createBlockBuilder(null, positionCount);
        for (int position = 0; position < positionCount; ++position) {
            Boolean keep;
            Double input = null;
            if (!arrayBlock.isNull(position)) {
                input = elementType.getDouble(arrayBlock, position);
            }
            if (!Boolean.TRUE.equals(keep = function.apply(input))) continue;
            elementType.appendTo(arrayBlock, position, resultBuilder);
        }
        return resultBuilder.build();
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=boolean.class)
    @SqlType(value="array(T)")
    public static Block filterBoolean(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") FilterBooleanLambda function) {
        int positionCount = arrayBlock.getPositionCount();
        BlockBuilder resultBuilder = elementType.createBlockBuilder(null, positionCount);
        for (int position = 0; position < positionCount; ++position) {
            Boolean keep;
            Boolean input = null;
            if (!arrayBlock.isNull(position)) {
                input = elementType.getBoolean(arrayBlock, position);
            }
            if (!Boolean.TRUE.equals(keep = function.apply(input))) continue;
            elementType.appendTo(arrayBlock, position, resultBuilder);
        }
        return resultBuilder.build();
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=Slice.class)
    @SqlType(value="array(T)")
    public static Block filterSlice(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") FilterSliceLambda function) {
        int positionCount = arrayBlock.getPositionCount();
        BlockBuilder resultBuilder = elementType.createBlockBuilder(null, positionCount);
        for (int position = 0; position < positionCount; ++position) {
            Boolean keep;
            Slice input = null;
            if (!arrayBlock.isNull(position)) {
                input = elementType.getSlice(arrayBlock, position);
            }
            if (!Boolean.TRUE.equals(keep = function.apply(input))) continue;
            elementType.appendTo(arrayBlock, position, resultBuilder);
        }
        return resultBuilder.build();
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=Block.class)
    @SqlType(value="array(T)")
    public static Block filterBlock(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") FilterBlockLambda function) {
        int positionCount = arrayBlock.getPositionCount();
        BlockBuilder resultBuilder = elementType.createBlockBuilder(null, positionCount);
        for (int position = 0; position < positionCount; ++position) {
            Boolean keep;
            Block input = null;
            if (!arrayBlock.isNull(position)) {
                input = (Block)elementType.getObject(arrayBlock, position);
            }
            if (!Boolean.TRUE.equals(keep = function.apply(input))) continue;
            elementType.appendTo(arrayBlock, position, resultBuilder);
        }
        return resultBuilder.build();
    }

    @FunctionalInterface
    public static interface FilterVoidLambda
    extends LambdaFunctionInterface {
        public Boolean apply(Void var1);
    }

    @FunctionalInterface
    public static interface FilterBlockLambda
    extends LambdaFunctionInterface {
        public Boolean apply(Block var1);
    }

    @FunctionalInterface
    public static interface FilterSliceLambda
    extends LambdaFunctionInterface {
        public Boolean apply(Slice var1);
    }

    @FunctionalInterface
    public static interface FilterBooleanLambda
    extends LambdaFunctionInterface {
        public Boolean apply(Boolean var1);
    }

    @FunctionalInterface
    public static interface FilterDoubleLambda
    extends LambdaFunctionInterface {
        public Boolean apply(Double var1);
    }

    @FunctionalInterface
    public static interface FilterLongLambda
    extends LambdaFunctionInterface {
        public Boolean apply(Long var1);
    }
}

