/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.OperatorDependency;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.function.TypeParameterSpecialization;
import io.prestosql.spi.type.Type;
import io.prestosql.type.TypeUtils;
import io.prestosql.util.Failures;
import java.lang.invoke.MethodHandle;

@ScalarOperator(value=OperatorType.GREATER_THAN)
public final class ArrayGreaterThanOperator {
    private ArrayGreaterThanOperator() {
    }

    @TypeParameter(value="T")
    @SqlType(value="boolean")
    public static boolean greaterThan(@OperatorDependency(operator=OperatorType.GREATER_THAN, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle greaterThanFunction, @TypeParameter(value="T") Type type, @SqlType(value="array(T)") Block leftArray, @SqlType(value="array(T)") Block rightArray) {
        int len = Math.min(leftArray.getPositionCount(), rightArray.getPositionCount());
        for (int index = 0; index < len; ++index) {
            TypeUtils.checkElementNotNull(leftArray.isNull(index), "ARRAY comparison not supported for arrays with null elements");
            TypeUtils.checkElementNotNull(rightArray.isNull(index), "ARRAY comparison not supported for arrays with null elements");
            Object leftElement = io.prestosql.spi.type.TypeUtils.readNativeValue((Type)type, (Block)leftArray, (int)index);
            Object rightElement = io.prestosql.spi.type.TypeUtils.readNativeValue((Type)type, (Block)rightArray, (int)index);
            try {
                if (greaterThanFunction.invoke(leftElement, rightElement)) {
                    return true;
                }
                if (!greaterThanFunction.invoke(rightElement, leftElement)) continue;
                return false;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return leftArray.getPositionCount() > rightArray.getPositionCount();
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=long.class)
    @SqlType(value="boolean")
    public static boolean greaterThanLong(@OperatorDependency(operator=OperatorType.GREATER_THAN, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle greaterThanFunction, @TypeParameter(value="T") Type type, @SqlType(value="array(T)") Block leftArray, @SqlType(value="array(T)") Block rightArray) {
        int len = Math.min(leftArray.getPositionCount(), rightArray.getPositionCount());
        for (int index = 0; index < len; ++index) {
            TypeUtils.checkElementNotNull(leftArray.isNull(index), "ARRAY comparison not supported for arrays with null elements");
            TypeUtils.checkElementNotNull(rightArray.isNull(index), "ARRAY comparison not supported for arrays with null elements");
            long leftElement = type.getLong(leftArray, index);
            long rightElement = type.getLong(rightArray, index);
            try {
                if (greaterThanFunction.invokeExact(leftElement, rightElement)) {
                    return true;
                }
                if (!greaterThanFunction.invokeExact(rightElement, leftElement)) continue;
                return false;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return leftArray.getPositionCount() > rightArray.getPositionCount();
    }
}

