/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.OperatorDependency;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.type.Type;
import io.prestosql.type.TypeUtils;
import io.prestosql.util.Failures;
import java.lang.invoke.MethodHandle;

@ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
public final class ArrayGreaterThanOrEqualOperator {
    private ArrayGreaterThanOrEqualOperator() {
    }

    @TypeParameter(value="T")
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@OperatorDependency(operator=OperatorType.GREATER_THAN, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle greaterThanFunction, @TypeParameter(value="T") Type type, @SqlType(value="array(T)") Block leftArray, @SqlType(value="array(T)") Block rightArray) {
        int len = Math.min(leftArray.getPositionCount(), rightArray.getPositionCount());
        for (int index = 0; index < len; ++index) {
            TypeUtils.checkElementNotNull(leftArray.isNull(index), "ARRAY comparison not supported for arrays with null elements");
            TypeUtils.checkElementNotNull(rightArray.isNull(index), "ARRAY comparison not supported for arrays with null elements");
            Object leftElement = io.prestosql.spi.type.TypeUtils.readNativeValue((Type)type, (Block)leftArray, (int)index);
            Object rightElement = io.prestosql.spi.type.TypeUtils.readNativeValue((Type)type, (Block)rightArray, (int)index);
            try {
                if (greaterThanFunction.invoke(leftElement, rightElement)) {
                    return true;
                }
                if (!greaterThanFunction.invoke(rightElement, leftElement)) continue;
                return false;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return leftArray.getPositionCount() >= rightArray.getPositionCount();
    }
}

