/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.airlift.slice.Slice;
import io.prestosql.operator.scalar.CombineHashFunction;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.OperatorDependency;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.function.TypeParameterSpecialization;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeUtils;
import io.prestosql.util.Failures;
import java.lang.invoke.MethodHandle;

@ScalarOperator(value=OperatorType.HASH_CODE)
public final class ArrayHashCodeOperator {
    private ArrayHashCodeOperator() {
    }

    @TypeParameter(value="T")
    @SqlType(value="bigint")
    public static long hash(@OperatorDependency(operator=OperatorType.HASH_CODE, returnType="bigint", argumentTypes={"T"}) MethodHandle hashFunction, @TypeParameter(value="T") Type type, @SqlType(value="array(T)") Block block) {
        try {
            long hash = 0L;
            for (int i = 0; i < block.getPositionCount(); ++i) {
                hash = CombineHashFunction.getHash(hash, block.isNull(i) ? 0L : hashFunction.invoke(TypeUtils.readNativeValue((Type)type, (Block)block, (int)i)));
            }
            return hash;
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=long.class)
    @SqlType(value="bigint")
    public static long hashLong(@OperatorDependency(operator=OperatorType.HASH_CODE, returnType="bigint", argumentTypes={"T"}) MethodHandle hashFunction, @TypeParameter(value="T") Type type, @SqlType(value="array(T)") Block block) {
        try {
            long hash = 0L;
            for (int i = 0; i < block.getPositionCount(); ++i) {
                hash = CombineHashFunction.getHash(hash, block.isNull(i) ? 0L : hashFunction.invokeExact(type.getLong(block, i)));
            }
            return hash;
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=boolean.class)
    @SqlType(value="bigint")
    public static long hashBoolean(@OperatorDependency(operator=OperatorType.HASH_CODE, returnType="bigint", argumentTypes={"T"}) MethodHandle hashFunction, @TypeParameter(value="T") Type type, @SqlType(value="array(T)") Block block) {
        try {
            long hash = 0L;
            for (int i = 0; i < block.getPositionCount(); ++i) {
                hash = CombineHashFunction.getHash(hash, block.isNull(i) ? 0L : hashFunction.invokeExact(type.getBoolean(block, i)));
            }
            return hash;
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=Slice.class)
    @SqlType(value="bigint")
    public static long hashSlice(@OperatorDependency(operator=OperatorType.HASH_CODE, returnType="bigint", argumentTypes={"T"}) MethodHandle hashFunction, @TypeParameter(value="T") Type type, @SqlType(value="array(T)") Block block) {
        try {
            long hash = 0L;
            for (int i = 0; i < block.getPositionCount(); ++i) {
                hash = CombineHashFunction.getHash(hash, block.isNull(i) ? 0L : hashFunction.invokeExact(type.getSlice(block, i)));
            }
            return hash;
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=double.class)
    @SqlType(value="bigint")
    public static long hashDouble(@OperatorDependency(operator=OperatorType.HASH_CODE, returnType="bigint", argumentTypes={"T"}) MethodHandle hashFunction, @TypeParameter(value="T") Type type, @SqlType(value="array(T)") Block block) {
        try {
            long hash = 0L;
            for (int i = 0; i < block.getPositionCount(); ++i) {
                hash = CombineHashFunction.getHash(hash, block.isNull(i) ? 0L : hashFunction.invokeExact(type.getDouble(block, i)));
            }
            return hash;
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
    }
}

