/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.OperatorDependency;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.function.TypeParameterSpecialization;
import io.prestosql.spi.type.Type;
import io.prestosql.type.TypeUtils;
import io.prestosql.util.Failures;
import java.lang.invoke.MethodHandle;

@ScalarOperator(value=OperatorType.LESS_THAN)
public final class ArrayLessThanOperator {
    private ArrayLessThanOperator() {
    }

    @TypeParameter(value="E")
    @SqlType(value="boolean")
    public static boolean lessThan(@OperatorDependency(operator=OperatorType.LESS_THAN, returnType="boolean", argumentTypes={"E", "E"}) MethodHandle lessThanFunction, @TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block leftArray, @SqlType(value="array(E)") Block rightArray) {
        int len = Math.min(leftArray.getPositionCount(), rightArray.getPositionCount());
        for (int index = 0; index < len; ++index) {
            TypeUtils.checkElementNotNull(leftArray.isNull(index), "ARRAY comparison not supported for arrays with null elements");
            TypeUtils.checkElementNotNull(rightArray.isNull(index), "ARRAY comparison not supported for arrays with null elements");
            Object leftElement = io.prestosql.spi.type.TypeUtils.readNativeValue((Type)type, (Block)leftArray, (int)index);
            Object rightElement = io.prestosql.spi.type.TypeUtils.readNativeValue((Type)type, (Block)rightArray, (int)index);
            try {
                if (lessThanFunction.invoke(leftElement, rightElement)) {
                    return true;
                }
                if (!lessThanFunction.invoke(rightElement, leftElement)) continue;
                return false;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return leftArray.getPositionCount() < rightArray.getPositionCount();
    }

    @TypeParameter(value="E")
    @TypeParameterSpecialization(name="E", nativeContainerType=long.class)
    @SqlType(value="boolean")
    public static boolean lessThanLong(@OperatorDependency(operator=OperatorType.LESS_THAN, returnType="boolean", argumentTypes={"E", "E"}) MethodHandle lessThanFunction, @TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block leftArray, @SqlType(value="array(E)") Block rightArray) {
        int len = Math.min(leftArray.getPositionCount(), rightArray.getPositionCount());
        for (int index = 0; index < len; ++index) {
            TypeUtils.checkElementNotNull(leftArray.isNull(index), "ARRAY comparison not supported for arrays with null elements");
            TypeUtils.checkElementNotNull(rightArray.isNull(index), "ARRAY comparison not supported for arrays with null elements");
            long leftElement = type.getLong(leftArray, index);
            long rightElement = type.getLong(rightArray, index);
            try {
                if (lessThanFunction.invokeExact(leftElement, rightElement)) {
                    return true;
                }
                if (!lessThanFunction.invokeExact(rightElement, leftElement)) continue;
                return false;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return leftArray.getPositionCount() < rightArray.getPositionCount();
    }
}

