/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.airlift.slice.Slice;
import io.prestosql.operator.scalar.ArrayMinMaxUtils;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.OperatorDependency;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlNullable;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.type.Type;
import io.prestosql.util.Failures;
import java.lang.invoke.MethodHandle;

@ScalarFunction(value="array_min")
@Description(value="Get minimum value of array")
public final class ArrayMinFunction {
    private ArrayMinFunction() {
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @SqlNullable
    public static Long longArrayMin(@OperatorDependency(operator=OperatorType.LESS_THAN, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle compareMethodHandle, @TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block block) {
        return ArrayMinMaxUtils.longArrayMinMax(compareMethodHandle, elementType, block);
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @SqlNullable
    public static Boolean booleanArrayMin(@OperatorDependency(operator=OperatorType.LESS_THAN, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle compareMethodHandle, @TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block block) {
        return ArrayMinMaxUtils.booleanArrayMinMax(compareMethodHandle, elementType, block);
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @SqlNullable
    public static Double doubleArrayMin(@OperatorDependency(operator=OperatorType.LESS_THAN, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle compareMethodHandle, @TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block block) {
        return ArrayMinMaxUtils.doubleArrayMinMax(compareMethodHandle, elementType, block);
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @SqlNullable
    public static Slice sliceArrayMin(@OperatorDependency(operator=OperatorType.LESS_THAN, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle compareMethodHandle, @TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block block) {
        return ArrayMinMaxUtils.sliceArrayMinMax(compareMethodHandle, elementType, block);
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @SqlNullable
    public static Block blockArrayMin(@OperatorDependency(operator=OperatorType.LESS_THAN, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle compareMethodHandle, @TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block block) {
        try {
            if (block.getPositionCount() == 0) {
                return null;
            }
            Block selectedValue = (Block)elementType.getObject(block, 0);
            for (int i = 0; i < block.getPositionCount(); ++i) {
                if (block.isNull(i)) {
                    return null;
                }
                Block value = (Block)elementType.getObject(block, i);
                if (!compareMethodHandle.invokeExact(value, selectedValue)) continue;
                selectedValue = value;
            }
            return selectedValue;
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
    }
}

