/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlScalarFunction;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeUtils;
import io.prestosql.sql.gen.lambda.BinaryFunctionInterface;
import io.prestosql.sql.gen.lambda.UnaryFunctionInterface;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;

public final class ArrayReduceFunction
extends SqlScalarFunction {
    public static final ArrayReduceFunction ARRAY_REDUCE_FUNCTION = new ArrayReduceFunction();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ArrayReduceFunction.class, "reduce", Type.class, Block.class, Object.class, BinaryFunctionInterface.class, UnaryFunctionInterface.class);

    private ArrayReduceFunction() {
        super(new Signature("reduce", FunctionKind.SCALAR, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("T"), (Object)Signature.typeVariable("S"), (Object)Signature.typeVariable("R")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"R"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"array(T)"), (Object)TypeSignature.parseTypeSignature((String)"S"), (Object)TypeSignature.parseTypeSignature((String)"function(S,T,S)"), (Object)TypeSignature.parseTypeSignature((String)"function(S,R)")), false));
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    @Override
    public String getDescription() {
        return "Reduce elements of the array into a single value";
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type inputType = boundVariables.getTypeVariable("T");
        Type intermediateType = boundVariables.getTypeVariable("S");
        Type outputType = boundVariables.getTypeVariable("R");
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(inputType);
        return new ScalarFunctionImplementation(true, (List<ScalarFunctionImplementation.ArgumentProperty>)ImmutableList.of((Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL), (Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementation.NullConvention.USE_BOXED_TYPE), (Object)ScalarFunctionImplementation.ArgumentProperty.functionTypeArgumentProperty(BinaryFunctionInterface.class), (Object)ScalarFunctionImplementation.ArgumentProperty.functionTypeArgumentProperty(UnaryFunctionInterface.class)), methodHandle.asType(methodHandle.type().changeParameterType(1, Primitives.wrap((Class)intermediateType.getJavaType())).changeReturnType(Primitives.wrap((Class)outputType.getJavaType()))), this.isDeterministic());
    }

    public static Object reduce(Type inputType, Block block, Object initialIntermediateValue, BinaryFunctionInterface inputFunction, UnaryFunctionInterface outputFunction) {
        int positionCount = block.getPositionCount();
        Object intermediateValue = initialIntermediateValue;
        for (int position = 0; position < positionCount; ++position) {
            Object input = TypeUtils.readNativeValue((Type)inputType, (Block)block, (int)position);
            intermediateValue = inputFunction.apply(intermediateValue, input);
        }
        return outputFunction.apply(intermediateValue);
    }
}

