/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.OperatorDependency;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.type.Type;
import java.lang.invoke.MethodHandle;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@ScalarFunction(value="array_sort")
@Description(value="Sorts the given array in ascending order according to the natural ordering of its elements.")
public final class ArraySortFunction {
    private final PageBuilder pageBuilder;
    private static final int INITIAL_LENGTH = 128;
    private List<Integer> positions = Ints.asList((int[])new int[128]);

    @TypeParameter(value="E")
    public ArraySortFunction(@TypeParameter(value="E") Type elementType) {
        this.pageBuilder = new PageBuilder((List)ImmutableList.of((Object)elementType));
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public Block sort(@OperatorDependency(operator=OperatorType.LESS_THAN, returnType="boolean", argumentTypes={"E", "E"}) MethodHandle lessThanFunction, final @TypeParameter(value="E") Type type, final @SqlType(value="array(E)") Block block) {
        int arrayLength = block.getPositionCount();
        if (this.positions.size() < arrayLength) {
            this.positions = Ints.asList((int[])new int[arrayLength]);
        }
        for (int i = 0; i < arrayLength; ++i) {
            this.positions.set(i, i);
        }
        Collections.sort(this.positions.subList(0, arrayLength), new Comparator<Integer>(){

            @Override
            public int compare(Integer p1, Integer p2) {
                boolean nullLeft = block.isNull(p1.intValue());
                boolean nullRight = block.isNull(p2.intValue());
                if (nullLeft && nullRight) {
                    return 0;
                }
                if (nullLeft) {
                    return 1;
                }
                if (nullRight) {
                    return -1;
                }
                return type.compareTo(block, p1.intValue(), block, p2.intValue());
            }
        });
        if (this.pageBuilder.isFull()) {
            this.pageBuilder.reset();
        }
        BlockBuilder blockBuilder = this.pageBuilder.getBlockBuilder(0);
        for (int i = 0; i < arrayLength; ++i) {
            type.appendTo(block, this.positions.get(i).intValue(), blockBuilder);
        }
        this.pageBuilder.declarePositions(arrayLength);
        return blockBuilder.getRegion(blockBuilder.getPositionCount() - arrayLength, arrayLength);
    }
}

