/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.MethodDefinition;
import io.airlift.bytecode.Parameter;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlOperator;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.sql.gen.ArrayGeneratorUtils;
import io.prestosql.sql.gen.ArrayMapBytecodeExpression;
import io.prestosql.sql.gen.CachedInstanceBinder;
import io.prestosql.sql.gen.CallSiteBinder;
import io.prestosql.util.CompilerUtils;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class ArrayToArrayCast
extends SqlOperator {
    public static final ArrayToArrayCast ARRAY_TO_ARRAY_CAST = new ArrayToArrayCast();

    private ArrayToArrayCast() {
        super(OperatorType.CAST, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("F"), (Object)Signature.typeVariable("T")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"array(T)"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"array(F)")));
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Preconditions.checkArgument((arity == 1 ? 1 : 0) != 0, (Object)"Expected arity to be 1");
        Type fromType = boundVariables.getTypeVariable("F");
        Type toType = boundVariables.getTypeVariable("T");
        Signature signature = Signature.internalOperator(OperatorType.CAST.name(), toType.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)fromType.getTypeSignature()));
        ScalarFunctionImplementation function = functionRegistry.getScalarFunctionImplementation(signature);
        Class<?> castOperatorClass = ArrayToArrayCast.generateArrayCast(typeManager, signature, function);
        MethodHandle methodHandle = Reflection.methodHandle(castOperatorClass, "castArray", ConnectorSession.class, Block.class);
        return new ScalarFunctionImplementation(false, (List<ScalarFunctionImplementation.ArgumentProperty>)ImmutableList.of((Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL), (Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL)), methodHandle, this.isDeterministic());
    }

    private static Class<?> generateArrayCast(TypeManager typeManager, Signature elementCastSignature, ScalarFunctionImplementation elementCast) {
        CallSiteBinder binder = new CallSiteBinder();
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName(Joiner.on((String)"$").join((Object)"ArrayCast", (Object)elementCastSignature.getArgumentTypes().get(0), new Object[]{elementCastSignature.getReturnType()})), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
        Parameter value = Parameter.arg((String)"value", Block.class);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "castArray", ParameterizedType.type(Block.class), new Parameter[]{session, value});
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        Variable wasNull = scope.declareVariable(Boolean.TYPE, "wasNull");
        body.append((BytecodeNode)wasNull.set(BytecodeExpressions.constantBoolean((boolean)false)));
        Type fromElementType = typeManager.getType(elementCastSignature.getArgumentTypes().get(0));
        Type toElementType = typeManager.getType(elementCastSignature.getReturnType());
        CachedInstanceBinder cachedInstanceBinder = new CachedInstanceBinder(definition, binder);
        ArrayMapBytecodeExpression newArray = ArrayGeneratorUtils.map(scope, cachedInstanceBinder, fromElementType, toElementType, (Variable)value, elementCastSignature.getName(), elementCast);
        body.append((BytecodeNode)newArray.ret());
        MethodDefinition constructorDefinition = definition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[0]);
        BytecodeBlock constructorBody = constructorDefinition.getBody();
        Variable thisVariable = constructorDefinition.getThis();
        constructorBody.comment("super();").append((BytecodeNode)thisVariable).invokeConstructor(Object.class, new Class[0]);
        cachedInstanceBinder.generateInitializations(thisVariable, constructorBody);
        constructorBody.ret();
        return CompilerUtils.defineClass(definition, Object.class, binder.getBindings(), ArrayToArrayCast.class.getClassLoader());
    }
}

